/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import java.util.List;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.base.ext.ui.text.CommentScanner;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;

public class RoxygenScanner
extends CommentScanner {
    public RoxygenScanner(TextStyleManager textStyles, PreferenceAccess corePrefs) {
        super(textStyles, "text_R_rRoxygen", "text_R_taskTag", corePrefs);
    }

    protected void createRules(List<IRule> rules) {
        super.createRules(rules);
        rules.add((IRule)new RoxygenTagRule(this.getToken("text_R_rRoxygenTag"), this.fDefaultReturnToken));
    }

    private static class RoxygenTagRule
    implements IPredicateRule {
        private final IToken fTagToken;
        private final IToken fDefaultToken;

        public RoxygenTagRule(IToken tagToken, IToken defaultToken) {
            this.fTagToken = tagToken;
            this.fDefaultToken = defaultToken;
        }

        public IToken getSuccessToken() {
            return this.fTagToken;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return this.evaluate(scanner, false);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            int c;
            if (!resume) {
                int c0 = scanner.read();
                if (c0 != 64) {
                    if (c0 != -1) {
                        scanner.unread();
                    }
                    return Token.UNDEFINED;
                }
                c = scanner.read();
                if (c == 64) {
                    return this.fDefaultToken;
                }
            } else {
                c = scanner.read();
            }
            while (c != -1) {
                if (c == 64 || !this.isRoxygenTagChar(c)) {
                    scanner.unread();
                    break;
                }
                c = scanner.read();
            }
            return this.fTagToken;
        }

        private boolean isRoxygenTagChar(int c) {
            if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                return true;
            }
            int type = Character.getType(c);
            return type > 0 && (type < 12 || type > 19);
        }
    }
}

