/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInformationProposal;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.model.IRMethod;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class RArgumentListContextInformation
implements AssistInformationProposal,
IContextInformationExtension {
    private final int offset;
    private final @Nullable ArgsDefinition args;
    private final String information;
    private final int[] informationArgumentIdxs;

    public RArgumentListContextInformation(int offset, IRMethod method) {
        this.offset = offset;
        this.args = method.getArgsDefinition();
        StringBuilder sb = new StringBuilder();
        IntArrayList idxs = new IntArrayList();
        new RLabelProvider().appendArgumentInformation(sb, (IntList)idxs, this.args);
        this.information = sb.toString();
        this.informationArgumentIdxs = idxs.toArray();
    }

    public int getCallArgsOffset() {
        return this.offset;
    }

    public @Nullable ArgsDefinition getArgsDefinition() {
        return this.args;
    }

    public String getContextDisplayString() {
        return this.getInformationDisplayString();
    }

    public @Nullable Image getImage() {
        return null;
    }

    public int getContextInformationPosition() {
        return Math.max(this.offset, 0);
    }

    public String getInformationDisplayString() {
        return this.information;
    }

    public int[] getInformationDisplayStringArgumentIdxs() {
        return this.informationArgumentIdxs;
    }

    public boolean equals(@Nullable Object obj) {
        return true;
    }
}

