/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.statet.docmlet.wikitext.ui.WikitextLabelProvider;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.MarkupTemplates;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.MarkupTemplatesManager;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.WikitextTemplateAssistComputer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.ltk.ui.templates.SourceEditorTemplateContext;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class MarkupTemplateAssistComputer
extends WikitextTemplateAssistComputer {
    private MarkupTemplates markupTemplates;
    private final WikitextLabelProvider labelProvider = new WikitextLabelProvider();
    private @Nullable IRegion startLineInfo;

    @Override
    public void onSessionStarted(ISourceEditor editor, ContentAssist assist) {
        super.onSessionStarted(editor, assist);
        this.markupTemplates = MarkupTemplatesManager.INSTANCE.getTemplates(this.getMarkupLanguage());
    }

    protected boolean handleRequest(int mode, String prefix) {
        return true;
    }

    protected List<Template> getTemplates(String contextTypeId) {
        return this.markupTemplates.getTemplates();
    }

    private boolean isBlockTemplate(Template template) {
        return this.markupTemplates.getMarkupInfo(template) != null;
    }

    protected boolean include(Template template, TemplateProposal.TemplateProposalParameters<?> parameters) {
        if (super.include(template, parameters)) {
            return true;
        }
        if (!this.isBlockTemplate(template)) {
            parameters.matchRule = 0x1000000;
            return true;
        }
        return false;
    }

    protected @Nullable Image getImage(Template template) {
        MarkupTemplates.MarkupInfo markupInfo = this.markupTemplates.getMarkupInfo(template);
        if (markupInfo != null && markupInfo.getElementType() != 0) {
            return this.labelProvider.getImage(markupInfo);
        }
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy");
    }

    protected @Nullable SourceEditorTemplateContext createTemplateContext(AssistInvocationContext context, TextRegion region, int flags) {
        try {
            this.startLineInfo = context.getDocument().getLineInformationOfOffset(context.getInvocationOffset());
        }
        catch (Exception e) {
            this.startLineInfo = null;
        }
        return super.createTemplateContext(context, region, flags);
    }

    protected TemplateProposal createProposal(TemplateProposal.TemplateProposalParameters<?> parameters) {
        if (parameters.baseRelevance > 0 && this.startLineInfo != null && this.startLineInfo.getOffset() == parameters.templateContext.getStart() && this.isBlockTemplate(parameters.template)) {
            parameters.baseRelevance += 10;
        }
        return super.createProposal(parameters);
    }
}

