/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.CommonmarkConfig;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.CommonmarkLanguage;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.AtxHeaderBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.BlockQuoteBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.EmptyBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.FencedCodeBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.HtmlBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.IndentedCodeBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ListBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ParagraphBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.SetextHeaderOrParagraphBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ThematicBreakBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.AutoLinkSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.AutoLinkWithoutDemarcationSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.BackslashEscapeSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.CodeSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.HtmlEntitySpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.HtmlTagSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.LineBreakSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialBracketSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialStyleSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.StringCharactersSpan;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class Commonmark {
    public static SourceBlocks newSourceBlocks() {
        return new SourceBlocks(new BlockQuoteBlock(), new AtxHeaderBlock(), new ThematicBreakBlock(), new ListBlock(), new FencedCodeBlock(), new IndentedCodeBlock(), new HtmlBlock(), new SetextHeaderOrParagraphBlock(), new EmptyBlock());
    }

    public static SourceBlocks newSourceBlocks(@Nullable CommonmarkConfig config) {
        ArrayList<Class<? extends SourceBlock>> interruptParagraphExclusions;
        if (config == null) {
            return Commonmark.newSourceBlocks();
        }
        if (config.isHeaderInterruptParagraphDisabled() || config.isBlockquoteInterruptParagraphDisabled()) {
            interruptParagraphExclusions = new ArrayList<Class<? extends SourceBlock>>();
            interruptParagraphExclusions.addAll((Collection<Class<? extends SourceBlock>>)ParagraphBlock.DEFAULT_INTERRUPT_EXCLUSIONS);
            if (config.isHeaderInterruptParagraphDisabled()) {
                interruptParagraphExclusions.add(AtxHeaderBlock.class);
            }
            if (config.isBlockquoteInterruptParagraphDisabled()) {
                interruptParagraphExclusions.add(BlockQuoteBlock.class);
            }
        } else {
            interruptParagraphExclusions = ParagraphBlock.DEFAULT_INTERRUPT_EXCLUSIONS;
        }
        return new SourceBlocks(new BlockQuoteBlock(), new AtxHeaderBlock(), new ThematicBreakBlock(), new ListBlock(), new FencedCodeBlock(), new IndentedCodeBlock(), new HtmlBlock(), new SetextHeaderOrParagraphBlock(interruptParagraphExclusions), new EmptyBlock());
    }

    public static InlineParser newInlineParser() {
        return Commonmark.newInlineParserCommonMarkStrict();
    }

    public static InlineParser newInlineParserCommonMarkStrict() {
        return Commonmark.newInlineParserCommonMark(null);
    }

    public static InlineParser newInlineParserCommonMark(@Nullable CommonmarkConfig config) {
        ArrayList<SourceSpan> spans = new ArrayList<SourceSpan>();
        spans.add(new LineBreakSpan());
        spans.add(new BackslashEscapeSpan());
        spans.add(new CodeSpan());
        spans.add(new AutoLinkSpan());
        spans.add(new HtmlTagSpan());
        spans.add(new HtmlEntitySpan());
        PotentialStyleSpan styleSpan = config != null ? new PotentialStyleSpan(config.isStrikeoutByDTildeEnabled(), config.isSuperscriptBySCircumflexEnabled(), config.isSubscriptBySTildeEnabled()) : new PotentialStyleSpan();
        spans.add(styleSpan);
        spans.add(new PotentialBracketSpan());
        spans.add(new StringCharactersSpan(styleSpan.getControlChars()));
        return new InlineParser((ImList<SourceSpan>)ImCollections.toList(spans));
    }

    public static InlineParser newInlineParserMarkdown() {
        ArrayList<SourceSpan> spans = new ArrayList<SourceSpan>();
        spans.add(new LineBreakSpan());
        spans.add(new BackslashEscapeSpan());
        spans.add(new CodeSpan());
        spans.add(new AutoLinkSpan());
        spans.add(new AutoLinkWithoutDemarcationSpan());
        spans.add(new HtmlTagSpan());
        spans.add(new HtmlEntitySpan());
        spans.add(new PotentialStyleSpan());
        spans.add(new PotentialBracketSpan());
        spans.add(new StringCharactersSpan("h"));
        return new InlineParser((ImList<SourceSpan>)ImCollections.toList(spans));
    }

    public static class MylynLanguage
    extends CommonmarkLanguage {
        public MylynLanguage() {
            super("Mylyn", 256, null);
        }
    }
}

