/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.refactoring.core.RefactoringDestination;

public abstract class MultiRefactoringFactory
extends CommonRefactoringFactory {
    private static final Object NO_FACTORY = new Object();
    private final String defaultTypeId;
    private final CommonRefactoringFactory defaultFactory;
    private final Map<String, Object> secondaryFactories = new IdentityHashMap<String, Object>(8);

    public MultiRefactoringFactory(String defaultTypeId, CommonRefactoringFactory defaultFactory) {
        this.defaultTypeId = defaultTypeId;
        this.defaultFactory = defaultFactory;
    }

    protected final CommonRefactoringFactory getFactory(String modelTypeId) {
        if (modelTypeId == this.defaultTypeId || modelTypeId == null) {
            return this.defaultFactory;
        }
        Object factory = this.secondaryFactories.get(modelTypeId);
        if (factory == null) {
            factory = this.createFactory(modelTypeId);
            if (factory == null) {
                factory = NO_FACTORY;
            }
            this.secondaryFactories.put(modelTypeId, factory);
        }
        return factory != NO_FACTORY ? (CommonRefactoringFactory)factory : null;
    }

    protected abstract CommonRefactoringFactory createFactory(String var1);

    @Override
    public RefactoringAdapter createAdapter(Object elements) {
        String type = null;
        if (elements instanceof ElementSet) {
            elements = ((ElementSet)((Object)elements)).getInitialObjects();
        } else if (elements instanceof Object[]) {
            Object[] array = (Object[])elements;
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof IModelElement) {
                    String elementType = ((IModelElement)array[i]).getModelTypeId();
                    if (type == null) {
                        type = elementType;
                    } else if (type != elementType) {
                        return null;
                    }
                }
                ++i;
            }
        } else if (elements instanceof IModelElement) {
            type = ((IModelElement)((Object)elements)).getModelTypeId();
        }
        CommonRefactoringFactory factory = this.getFactory(type);
        return factory != null ? factory.createAdapter(elements) : null;
    }

    @Override
    public DeleteProcessor createDeleteProcessor(Object elementsToDelete, RefactoringAdapter adapter) {
        CommonRefactoringFactory factory = this.getFactory(adapter.getModelTypeId());
        return factory != null ? factory.createDeleteProcessor(elementsToDelete, adapter) : null;
    }

    @Override
    public MoveProcessor createMoveProcessor(Object elementsToMove, RefactoringDestination destination, RefactoringAdapter adapter) {
        CommonRefactoringFactory factory = this.getFactory(adapter.getModelTypeId());
        return factory != null ? factory.createMoveProcessor(elementsToMove, destination, adapter) : null;
    }

    @Override
    public CopyProcessor createCopyProcessor(Object elementsToCopy, RefactoringDestination destination, RefactoringAdapter adapter) {
        CommonRefactoringFactory factory = this.getFactory(adapter.getModelTypeId());
        return factory != null ? factory.createCopyProcessor(elementsToCopy, destination, adapter) : null;
    }

    @Override
    public RefactoringProcessor createPasteProcessor(Object elementsToPaste, RefactoringDestination destination, RefactoringAdapter adapter) {
        CommonRefactoringFactory factory = this.getFactory(adapter.getModelTypeId());
        return factory != null ? factory.createPasteProcessor(elementsToPaste, destination, adapter) : null;
    }
}

