/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.docmlet.tex.core.ast.TexAst;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAssistInvocationContext;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.PathCompletionComputor;

public class TexPathCompletionComputer
extends PathCompletionComputor {
    private IContainer baseResource;
    private IFileStore baseFileStore;

    public String getPluginId() {
        return "org.eclipse.statet.docmlet.tex.ui";
    }

    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
        this.baseResource = null;
        this.baseFileStore = null;
        ISourceUnit su = editor.getSourceUnit();
        if (su instanceof IWorkspaceSourceUnit) {
            IResource resource = ((IWorkspaceSourceUnit)su).getResource();
            if (this.baseResource == null) {
                this.baseResource = resource.getParent();
            }
            if (this.baseResource != null) {
                try {
                    this.baseFileStore = EFS.getStore((URI)this.baseResource.getLocationURI());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        super.sessionStarted(editor, assist);
    }

    public void sessionEnded() {
        super.sessionEnded();
    }

    protected char getDefaultFileSeparator() {
        return '/';
    }

    protected TextRegion getContentRange(AssistInvocationContext context, int mode) throws BadLocationException {
        LtxAssistInvocationContext texContext;
        int argIdx;
        if (context instanceof LtxAssistInvocationContext && (argIdx = (texContext = (LtxAssistInvocationContext)context).getInvocationArgIdx()) >= 0) {
            TextRegion region;
            TexCommand command = texContext.getInvocationControlNode().getCommand();
            Argument argDef = (Argument)command.getArguments().get(argIdx);
            TexAstNode argNode = texContext.getInvocationArgNodes()[argIdx];
            int offset = texContext.getInvocationOffset();
            if ((mode == 2 || (argDef.getContent() & 0xF0) == 64) && (region = TexAst.getInnerRegion((TexAstNode)argNode)) != null && region.getStartOffset() >= offset && offset <= region.getEndOffset()) {
                return region;
            }
        }
        return null;
    }

    protected IPath getRelativeBasePath() {
        if (this.baseResource != null) {
            return this.baseResource.getLocation();
        }
        return null;
    }

    protected IFileStore getRelativeBaseStore() {
        if (this.baseFileStore != null) {
            return this.baseFileStore;
        }
        return null;
    }
}

