/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;

public class IntervalVariableFilter
extends VariableFilter {
    public static final int MIN_IDX = 0;
    public static final int MAX_IDX = 1;
    public static final int NA_IDX = 2;
    private RStore<? extends Number> minMaxData;
    private final IObservableValue<Number> selectedLowerValue;
    private final IObservableValue<Number> selectedUpperValue;
    private final IObservableValue<Boolean> selectedNA;

    protected IntervalVariableFilter(FilterSet set, RDataTableColumn column) {
        super(set, column);
        this.selectedLowerValue = new WritableValue(set.getRealm());
        this.selectedUpperValue = new WritableValue(set.getRealm());
        this.selectedNA = new WritableValue(set.getRealm(), (Object)true, Boolean.TYPE);
        this.registerObservable((IObservable)this.selectedLowerValue);
        this.registerObservable((IObservable)this.selectedUpperValue);
        this.registerObservable((IObservable)this.selectedNA);
    }

    @Override
    public FilterType getType() {
        return FilterType.INTERVAL;
    }

    @Override
    public void load(VariableFilter filter) {
        if (filter.getType() == FilterType.INTERVAL && filter.getColumn().getDataStore().getStoreType() == this.getColumn().getDataStore().getStoreType()) {
            final IntervalVariableFilter intervalFilter = (IntervalVariableFilter)filter;
            this.runInRealm(new Runnable(){

                @Override
                public void run() {
                    if (IntervalVariableFilter.this.minMaxData == null) {
                        IntervalVariableFilter.this.selectedLowerValue.setValue((Object)((Number)intervalFilter.getSelectedLowerValue().getValue()));
                        IntervalVariableFilter.this.selectedUpperValue.setValue((Object)((Number)intervalFilter.getSelectedUpperValue().getValue()));
                        IntervalVariableFilter.this.selectedNA.setValue((Object)((Boolean)intervalFilter.getSelectedNA().getValue()));
                    }
                }
            });
        }
    }

    @Override
    public void reset() {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                if (IntervalVariableFilter.this.minMaxData == null) {
                    return;
                }
                IntervalVariableFilter.this.selectedLowerValue.setValue((Object)((Number)IntervalVariableFilter.this.minMaxData.get(0)));
                IntervalVariableFilter.this.selectedUpperValue.setValue((Object)((Number)IntervalVariableFilter.this.minMaxData.get(1)));
                IntervalVariableFilter.this.selectedNA.setValue((Object)Boolean.TRUE);
            }
        });
    }

    @Override
    protected void update(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RDataTableColumn column = this.getColumn();
        FunctionCall fcall = r.createFunctionCall("rj:::.getDataIntervalValues");
        fcall.add(column.getRExpression());
        RObject data = fcall.evalData(m);
        RDataUtils.checkRVector((RObject)data);
        this.setValues((RStore<? extends Number>)RDataUtils.checkData((RStore)data.getData(), (byte)column.getDataStore().getStoreType()));
    }

    @Override
    protected void setError(final String message) {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                IntervalVariableFilter.this.minMaxData = null;
                IntervalVariableFilter.super.setError(message);
                IntervalVariableFilter.this.notifyListeners();
            }
        });
    }

    protected void setValues(final RStore<? extends Number> minMaxData) {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                Object value = IntervalVariableFilter.this.selectedLowerValue.getValue();
                boolean wasMin = value == null || value.equals(minMaxData.get(0));
                Object value2 = IntervalVariableFilter.this.selectedLowerValue.getValue();
                boolean wasMax = value2 == null || value2.equals(minMaxData.get(1));
                IntervalVariableFilter.this.minMaxData = minMaxData;
                if (wasMin) {
                    IntervalVariableFilter.this.selectedLowerValue.setValue((Object)((Number)IntervalVariableFilter.this.minMaxData.get(0)));
                }
                if (wasMax) {
                    IntervalVariableFilter.this.selectedUpperValue.setValue((Object)((Number)IntervalVariableFilter.this.minMaxData.get(1)));
                }
                IntervalVariableFilter.super.setError(null);
                IntervalVariableFilter.this.notifyListeners();
            }
        });
    }

    private static boolean isSmaller(Number e1, Number e2) {
        if (e1 instanceof Integer) {
            return (Integer)e1 < (Integer)e2;
        }
        return e1.doubleValue() < e2.doubleValue();
    }

    private static boolean isGreater(Object e1, Object e2) {
        if (e1 instanceof Integer) {
            return (Integer)e1 > (Integer)e2;
        }
        return ((Number)e1).doubleValue() > ((Number)e2).doubleValue();
    }

    @Override
    protected String createFilter(String varExpression) {
        Boolean na;
        Number upper;
        if (this.minMaxData == null || this.selectedLowerValue.getValue() == null || this.selectedUpperValue.getValue() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Number lower = (Number)this.selectedLowerValue.getValue();
        if (IntervalVariableFilter.isGreater(lower, this.minMaxData.get(0))) {
            sb.append(varExpression);
            sb.append(" >= ");
            sb.append(lower);
        }
        if (IntervalVariableFilter.isSmaller(upper = (Number)this.selectedUpperValue.getValue(), (Number)this.minMaxData.get(1))) {
            if (sb.length() > 1) {
                sb.append(" & ");
            }
            sb.append(varExpression);
            sb.append(" <= ");
            sb.append(upper);
        }
        if ((na = Boolean.valueOf(!this.minMaxData.getLogi(2) || (Boolean)this.selectedNA.getValue() != false)).booleanValue()) {
            if (sb.length() > 1) {
                sb.insert(0, '(');
                sb.append(") | ");
                sb.append("is.na(").append(varExpression).append(')');
            }
        } else {
            if (sb.length() > 1) {
                sb.append(" & ");
            }
            sb.append("!is.na(").append(varExpression).append(')');
        }
        sb.append(')');
        return sb.length() <= 2 ? "" : sb.toString();
    }

    public RStore<? extends Number> getMinMaxData() {
        return this.minMaxData;
    }

    public IObservableValue<Number> getSelectedLowerValue() {
        return this.selectedLowerValue;
    }

    public IObservableValue<Number> getSelectedUpperValue() {
        return this.selectedUpperValue;
    }

    public IObservableValue<Boolean> getSelectedNA() {
        return this.selectedNA;
    }
}

