/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.util;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class DirtyTracker
implements IValueChangeListener<Object>,
IChangeListener {
    private boolean dirty;

    public DirtyTracker(DataBindingContext dbc) {
        for (Object obj : dbc.getBindings()) {
            this.track((Binding)obj, true);
        }
        dbc.getBindings().addListChangeListener((IListChangeListener)new IListChangeListener<Binding>(){

            public void handleListChange(ListChangeEvent<? extends Binding> event) {
                ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
                int n = listDiffEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ListDiffEntry diff = listDiffEntryArray[n2];
                    DirtyTracker.this.track((Binding)diff.getElement(), diff.isAddition());
                    ++n2;
                }
            }
        });
    }

    public DirtyTracker() {
    }

    public void add(Binding binding) {
        this.track(binding, true);
    }

    public void remove(Binding binding) {
        this.track(binding, false);
    }

    private void track(Binding binding, boolean add) {
        IObservable obs = binding.getModel();
        if (obs instanceof IObservableValue) {
            IObservableValue value = (IObservableValue)obs;
            if (add) {
                value.addValueChangeListener((IValueChangeListener)this);
            } else {
                value.removeValueChangeListener((IValueChangeListener)this);
            }
            return;
        }
        if (add) {
            obs.addChangeListener((IChangeListener)this);
        } else {
            obs.removeChangeListener((IChangeListener)this);
        }
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        this.handleChange((ObservableEvent)event);
    }

    public void handleChange(ChangeEvent event) {
        this.handleChange((ObservableEvent)event);
    }

    public void handleChange(ObservableEvent event) {
        this.dirty = true;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

