/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.statet.ecommons.text.core.IFragmentDocument;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.text.core.util.AbstractSynchronizableDocument;
import org.eclipse.statet.internal.ecommons.text.core.ECommonsTextCorePlugin;
import org.eclipse.statet.jcommons.text.core.TextRegion;

public abstract class AbstractFragmentDocument
extends AbstractSynchronizableDocument
implements IFragmentDocument {
    private static final byte NO_CHANGE = 0;
    private static final byte PREFIX_CHANGE = 1;
    private static final byte FRAGMENT_CHANGE = 2;
    private final AbstractDocument master = this.createMasterDocument();
    private int offsetInMaster = 0;
    private byte change = 0;

    public AbstractFragmentDocument() {
        this.master.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
                switch (AbstractFragmentDocument.this.change) {
                    case 1: {
                        AbstractFragmentDocument abstractFragmentDocument = AbstractFragmentDocument.this;
                        abstractFragmentDocument.offsetInMaster = abstractFragmentDocument.offsetInMaster + (-event.fLength + event.fText.length());
                        return;
                    }
                    case 2: {
                        return;
                    }
                }
                throw new UnsupportedOperationException();
            }

            public void documentChanged(DocumentEvent event) {
            }
        });
        this.master.addDocumentPartitioningListener(new IDocumentPartitioningListener(){

            public void documentPartitioningChanged(IDocument document) {
                AbstractFragmentDocument.this.fireDocumentPartitioningChanged((IRegion)new Region(0, AbstractFragmentDocument.this.getLength()));
            }
        });
    }

    protected void completeInitialization() {
        super.completeInitialization();
        this.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (AbstractFragmentDocument.this.change != 0) {
                    throw new IllegalStateException(String.valueOf(AbstractFragmentDocument.this.change));
                }
                AbstractFragmentDocument.this.change = (byte)2;
                try {
                    try {
                        AbstractFragmentDocument.this.replaceInMaster(AbstractFragmentDocument.this.offsetInMaster + event.fOffset, event.fLength, event.fText);
                    }
                    catch (BadLocationException e) {
                        ECommonsTextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.text.core", "Failed to edit master document.", (Throwable)e));
                        AbstractFragmentDocument.this.change = (byte)0;
                    }
                }
                finally {
                    AbstractFragmentDocument.this.change = (byte)0;
                }
            }
        });
    }

    protected abstract AbstractDocument createMasterDocument();

    @Override
    public AbstractDocument getMasterDocument() {
        return this.master;
    }

    @Override
    public int getOffsetInMasterDocument() {
        return this.offsetInMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextRegion getRegionInMasterDocument() {
        Object object = this.getLockObject();
        synchronized (object) {
            return JFaceTextRegion.newByStartLength(this.offsetInMaster, this.getLength());
        }
    }

    protected void replaceInMaster(int offset, int length, String text) throws BadLocationException {
        this.master.replace(offset, length, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPrefix(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        Object object = this.getLockObject();
        synchronized (object) {
            block10: {
                if (this.change != 0) {
                    throw new IllegalStateException(String.valueOf(this.change));
                }
                this.change = 1;
                try {
                    try {
                        this.replaceInMaster(0, this.offsetInMaster, text);
                        this.offsetInMaster = text.length();
                    }
                    catch (BadLocationException e) {
                        ECommonsTextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.text.core", "Failed to edit master document.", (Throwable)e));
                        this.change = 0;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.change = 0;
                    throw throwable;
                }
                this.change = 0;
            }
        }
    }

    @Override
    public void setInitialLineDelimiter(String lineDelimiter) {
        this.master.setInitialLineDelimiter(lineDelimiter);
        super.setInitialLineDelimiter(lineDelimiter);
    }

    public void setDocumentPartitioner(IDocumentPartitioner partitioner) {
        this.master.setDocumentPartitioner(partitioner);
    }

    public void setDocumentPartitioner(String partitioning, IDocumentPartitioner partitioner) {
        this.master.setDocumentPartitioner(partitioning, partitioner);
    }

    @Override
    public String[] getPartitionings() {
        return this.master.getPartitionings();
    }

    public IDocumentPartitioner getDocumentPartitioner() {
        return this.getDocumentPartitioner("__dftl_partitioning");
    }

    public IDocumentPartitioner getDocumentPartitioner(String partitioning) {
        IDocumentPartitioner masterPartitioner = this.master.getDocumentPartitioner(partitioning);
        if (masterPartitioner instanceof IDocumentPartitionerExtension2) {
            return new PartitionerMapper2(masterPartitioner);
        }
        return new PartitionerMapper(masterPartitioner);
    }

    public String[] getLegalContentTypes() {
        return this.master.getLegalContentTypes();
    }

    public String[] getLegalContentTypes(String partitioning) throws BadPartitioningException {
        return this.master.getLegalContentTypes(partitioning);
    }

    public ITypedRegion[] computePartitioning(int offset, int length) throws BadLocationException {
        return this.remap(this.master.computePartitioning(this.offsetInMaster + offset, length));
    }

    @Override
    public ITypedRegion[] computePartitioning(String partitioning, int offset, int length, boolean includeZeroLengthPartitions) throws BadLocationException, BadPartitioningException {
        return this.remap(this.master.computePartitioning(partitioning, this.offsetInMaster + offset, length, includeZeroLengthPartitions));
    }

    public ITypedRegion getPartition(int offset) throws BadLocationException {
        return this.remap(this.master.getPartition(this.offsetInMaster + offset));
    }

    public ITypedRegion getPartition(String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException, BadPartitioningException {
        return this.remap(this.master.getPartition(partitioning, this.offsetInMaster + offset, preferOpenPartitions));
    }

    public String getContentType(int offset) throws BadLocationException {
        return this.master.getContentType(this.offsetInMaster + offset);
    }

    @Override
    public String getContentType(String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException, BadPartitioningException {
        return this.master.getContentType(partitioning, this.offsetInMaster + offset, preferOpenPartitions);
    }

    private ITypedRegion[] remap(ITypedRegion[] masterRegions) {
        ArrayList<ITypedRegion> regions = new ArrayList<ITypedRegion>(masterRegions.length);
        ITypedRegion[] iTypedRegionArray = masterRegions;
        int n = masterRegions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion masterRegion = iTypedRegionArray[n2];
            ITypedRegion region = this.remap(masterRegion);
            if (region != null) {
                regions.add(region);
            }
            ++n2;
        }
        return regions.toArray(new ITypedRegion[regions.size()]);
    }

    private ITypedRegion remap(ITypedRegion masterRegion) {
        int length;
        int offset = masterRegion.getOffset() - this.offsetInMaster;
        if (offset + (length = masterRegion.getLength()) >= 0) {
            if (offset < 0) {
                length += offset;
                offset = 0;
            }
            return new TypedRegion(offset, length, masterRegion.getType());
        }
        BadPartitioningException e = new BadPartitioningException("Failed to map partition from master to fragment document.");
        e.fillInStackTrace();
        ECommonsTextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.text.core", "Failed to compute partition.", (Throwable)e));
        return null;
    }

    private class PartitionerMapper
    implements IDocumentPartitioner {
        private final IDocumentPartitioner masterPartitioner;

        public PartitionerMapper(IDocumentPartitioner partitioner) {
            this.masterPartitioner = partitioner;
        }

        public void connect(IDocument document) {
            throw new UnsupportedOperationException();
        }

        public void disconnect() {
            throw new UnsupportedOperationException();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            throw new UnsupportedOperationException();
        }

        public boolean documentChanged(DocumentEvent event) {
            throw new UnsupportedOperationException();
        }

        public ITypedRegion[] computePartitioning(int offset, int length) {
            return AbstractFragmentDocument.this.remap(this.masterPartitioner.computePartitioning(AbstractFragmentDocument.this.offsetInMaster + offset, length));
        }

        public String getContentType(int offset) {
            return this.masterPartitioner.getContentType(AbstractFragmentDocument.this.offsetInMaster + offset);
        }

        public String[] getLegalContentTypes() {
            return this.masterPartitioner.getLegalContentTypes();
        }

        public ITypedRegion getPartition(int offset) {
            return AbstractFragmentDocument.this.remap(this.masterPartitioner.getPartition(AbstractFragmentDocument.this.offsetInMaster + offset));
        }
    }

    private class PartitionerMapper2
    extends PartitionerMapper
    implements IDocumentPartitionerExtension2 {
        private final IDocumentPartitionerExtension2 masterPartitioner2;

        public PartitionerMapper2(IDocumentPartitioner partitioner) {
            super(partitioner);
            this.masterPartitioner2 = (IDocumentPartitionerExtension2)partitioner;
        }

        public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
            return this.masterPartitioner2.computePartitioning(AbstractFragmentDocument.this.offsetInMaster + offset, length, includeZeroLengthPartitions);
        }

        public String getContentType(int offset, boolean preferOpenPartitions) {
            return this.masterPartitioner2.getContentType(AbstractFragmentDocument.this.offsetInMaster + offset, preferOpenPartitions);
        }

        public String[] getManagingPositionCategories() {
            return this.masterPartitioner2.getManagingPositionCategories();
        }

        public ITypedRegion getPartition(int offset, boolean preferOpenPartitions) {
            return this.masterPartitioner2.getPartition(AbstractFragmentDocument.this.offsetInMaster + offset, preferOpenPartitions);
        }
    }
}

