/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.preferences.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.internal.ecommons.preferences.core.DefaultPreferenceSetService;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.osgi.framework.BundleContext;

public final class ECommonsPreferencesCorePlugin
extends Plugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.ecommons.preferences.core";
    private static ECommonsPreferencesCorePlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private DefaultPreferenceSetService defaultPreferenceSetService;

    public static ECommonsPreferencesCorePlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        ECommonsPreferencesCorePlugin plugin = ECommonsPreferencesCorePlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public ECommonsPreferencesCorePlugin() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        ECommonsPreferencesCorePlugin eCommonsPreferencesCorePlugin = this;
        synchronized (eCommonsPreferencesCorePlugin) {
            this.started = true;
            this.defaultPreferenceSetService = new DefaultPreferenceSetService();
            this.addStoppingListener(this.defaultPreferenceSetService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            ECommonsPreferencesCorePlugin eCommonsPreferencesCorePlugin = this;
            synchronized (eCommonsPreferencesCorePlugin) {
                this.started = false;
            }
            try {
                for (Disposable listener : this.disposables) {
                    listener.dispose();
                }
            }
            finally {
                this.disposables.clear();
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ECommonsPreferencesCorePlugin eCommonsPreferencesCorePlugin = this;
        synchronized (eCommonsPreferencesCorePlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    public void removeStoppingListener(Disposable listener) {
        this.disposables.remove(listener);
    }

    public PreferenceSetService getPreferenceSetService() {
        return this.defaultPreferenceSetService;
    }
}

