/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.WikitextBuildParticipant;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocWorkspaceSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSuModelContainer;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextCorePlugin;
import org.eclipse.statet.internal.docmlet.wikitext.core.builder.WikidocBuildReconciler;
import org.eclipse.statet.internal.docmlet.wikitext.core.builder.WikitextProjectBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.core.builder.WikitextProjectTask;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikitextModelManager;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.ISourceUnitManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;

public class WikitextProjectBuild
extends WikitextProjectTask
implements IResourceVisitor,
IResourceDeltaVisitor {
    private final ISourceUnitManager suManager = LTK.getSourceUnitManager();
    private final MultiStatus status = new MultiStatus("org.eclipse.statet.docmlet.wikitext.core", 0, NLS.bind((String)"Wikitext build status for ''{0}''", (Object)this.getWikitextProject().getProject().getName()), null);
    private final List<IWikidocWorkspaceSourceUnit> updatedDocUnits = new ArrayList<IWikidocWorkspaceSourceUnit>();
    private final List<VirtualSourceUnit> removedDocFiles = new ArrayList<VirtualSourceUnit>();
    private SubMonitor visitProgress;

    public WikitextProjectBuild(WikitextProjectBuilder builder) {
        super(builder);
    }

    private void dispose(SubMonitor m) {
        m.setWorkRemaining(this.updatedDocUnits.size());
        for (IWikitextSourceUnit iWikitextSourceUnit : this.updatedDocUnits) {
            iWikitextSourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    public void build(int kind, SubMonitor m) throws CoreException {
        try {
            IResourceDelta delta;
            m.beginTask(NLS.bind((String)"Preparing Wikitext build for ''{0}''", (Object)this.getWikitextProject().getProject().getName()), 12);
            switch (kind) {
                case 9: 
                case 10: {
                    delta = this.getWikitextProjectBuilder().getDelta(this.getWikitextProject().getProject());
                    m.worked(1);
                    break;
                }
                default: {
                    delta = null;
                }
            }
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            m.setWorkRemaining(11);
            this.visitProgress = m.newChild(2);
            if (delta != null) {
                this.setBuildType(10);
                delta.accept((IResourceDeltaVisitor)this);
            } else {
                this.setBuildType(6);
                this.getWikitextProject().getProject().accept((IResourceVisitor)this);
            }
            this.visitProgress = null;
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.processDocFiles(m.newChild(8, 0));
        }
        finally {
            m.setWorkRemaining(1);
            this.dispose(m.newChild(1));
            if (!this.status.isOK()) {
                WikitextCorePlugin.log((IStatus)this.status);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 1) {
            if (this.visitProgress.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.visitProgress.setWorkRemaining(100);
            try {
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        this.visitFileAdded((IFile)resource, delta, this.visitProgress.newChild(1));
                        break;
                    }
                    case 2: {
                        this.visitFileRemove((IFile)resource, delta, this.visitProgress.newChild(1));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when checking file ''{0}''", (Object)resource.getFullPath()), (Throwable)e));
            }
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            this.visitProgress.setWorkRemaining(100);
            this.visitFileAdded((IFile)resource, null, this.visitProgress.newChild(1));
        }
        return true;
    }

    private void visitFileAdded(IFile file, IResourceDelta delta, SubMonitor m) throws CoreException {
        IContentDescription contentDescription = file.getContentDescription();
        if (contentDescription == null) {
            return;
        }
        IContentType contentType = contentDescription.getContentType();
        if (contentType == null) {
            return;
        }
        if (contentType.isKindOf(WikitextCore.WIKIDOC_CONTENT_TYPE)) {
            ISourceUnit unit = this.suManager.getSourceUnit(LTK.PERSISTENCE_CONTEXT, (Object)file, contentType, true, (IProgressMonitor)m);
            if (unit instanceof IWikidocWorkspaceSourceUnit) {
                this.updatedDocUnits.add((IWikidocWorkspaceSourceUnit)unit);
            } else {
                if (unit != null) {
                    unit.disconnect((IProgressMonitor)m);
                }
                this.clearText(file, null);
            }
        }
    }

    private void visitFileRemove(IFile file, IResourceDelta delta, SubMonitor m) throws CoreException {
    }

    private void processDocFiles(SubMonitor m) throws CoreException {
        m.beginTask(NLS.bind((String)"Analyzing Wikitext file(s) of ''{0}''", (Object)this.getWikitextProject().getProject().getName()), 20);
        WikitextModelManager wikitextModelManager = WikitextCorePlugin.getInstance().getWikidocModelManager();
        SubMonitor m1 = m.newChild(10);
        int workRemaining = this.removedDocFiles.size() + this.updatedDocUnits.size() * 5;
        for (VirtualSourceUnit unit : this.removedDocFiles) {
            m1.setWorkRemaining(workRemaining--);
            try {
                WikitextBuildParticipant participant = this.getParticipant(unit.getModelTypeId());
                if (participant != null) {
                    participant.docUnitRemoved(unit.getResource(), (IProgressMonitor)m1.newChild(1));
                }
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", 0, NLS.bind((String)"An error occurred when processing removed file ''{0}''.", (Object)unit.getResource()), (Throwable)e));
            }
            if (!m1.isCanceled()) continue;
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (!this.updatedDocUnits.isEmpty()) {
            WikidocBuildReconciler docReconciler = new WikidocBuildReconciler(wikitextModelManager);
            for (IWikidocWorkspaceSourceUnit unit : this.updatedDocUnits) {
                m1.setWorkRemaining(workRemaining);
                workRemaining -= 5;
                try {
                    WikitextBuildParticipant participant = this.getParticipant(unit.getModelTypeId());
                    this.clearText((IFile)unit.getResource(), participant);
                    WikidocSuModelContainer adapter = (WikidocSuModelContainer)((Object)unit.getAdapter(WikidocSuModelContainer.class));
                    if (adapter != null) {
                        docReconciler.reconcile(adapter, 2, (IProgressMonitor)m1.newChild(3));
                        if (m1.isCanceled()) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                    }
                    if (participant != null && participant.isEnabled()) {
                        participant.docUnitUpdated(unit, (IProgressMonitor)m1.newChild(2));
                    }
                }
                catch (Exception e) {
                    this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when processing file ''{0}''.", (Object)unit.getResource()), (Throwable)e));
                }
                if (!m1.isCanceled()) continue;
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        m1 = m.newChild(10);
        Collection<WikitextBuildParticipant> participants = this.getParticipants();
        int workRemaining2 = participants.size();
        for (WikitextBuildParticipant participant : participants) {
            m1.setWorkRemaining(workRemaining2--);
            if (!participant.isEnabled()) continue;
            try {
                participant.docFinished((IProgressMonitor)m1.newChild(1));
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when processing Wikitext file(s) in ''{0}''.", (Object)this.getWikitextProject().getProject().getName()), (Throwable)e));
            }
        }
    }

    private void clearText(IFile file, WikitextBuildParticipant partitipant) throws CoreException {
        if (partitipant != null) {
            partitipant.clear(file);
        }
    }

    private static final class VirtualSourceUnit {
        private final IFile file;
        private final String modelTypeId;

        public VirtualSourceUnit(IFile file, String modelTypeId) {
            this.file = file;
            this.modelTypeId = modelTypeId;
        }

        public IFile getResource() {
            return this.file;
        }

        public String getModelTypeId() {
            return this.modelTypeId;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

