/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.docmlet.tex.core.source.LtxBracketPairMatcher;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.PairMatcher;

public class LtxDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    private final String partitioning;
    private final PairMatcher pairMatcher;
    private final BasicHeuristicTokenScanner scanner;

    public LtxDoubleClickStrategy(LtxHeuristicTokenScanner scanner) {
        this.partitioning = scanner.getDocumentPartitioning();
        this.pairMatcher = new LtxBracketPairMatcher(scanner);
        this.scanner = scanner;
    }

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        try {
            int partitionOffset;
            int partitionEnd;
            IRegion region;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)offset, (boolean)true);
            String type = partition.getType();
            if (type == "Ltx.Default" && (region = this.pairMatcher.match(document, offset)) != null && region.getLength() >= 2) {
                textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
                return;
            }
            partition = TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)offset, (boolean)false);
            type = partition.getType();
            if (type == "Ltx.Math" && (partitionEnd = (partitionOffset = partition.getOffset()) + partition.getLength()) - partitionOffset >= 4 && (offset == partitionOffset || offset == partitionOffset + 1 || offset == partitionEnd || offset == partitionEnd - 1)) {
                char c0 = document.getChar(partitionOffset);
                char c1 = document.getChar(partitionOffset + 1);
                int start = -1;
                char[] endPattern = null;
                if (c0 == '$') {
                    if (c1 == '$') {
                        start = partitionOffset + 2;
                        endPattern = "$$".toCharArray();
                    } else {
                        start = partitionOffset + 1;
                        endPattern = "$".toCharArray();
                    }
                } else if (c0 == '\\') {
                    if (c1 == '[') {
                        start = partitionOffset + 2;
                        endPattern = "\\]".toCharArray();
                    } else if (c1 == '(') {
                        start = partitionOffset + 2;
                        endPattern = "\\)".toCharArray();
                    }
                }
                if (start >= 0) {
                    textViewer.setSelectedRange(start, this.getEndOffset(document, partitionEnd, endPattern) - start);
                }
            }
            if (type == "Ltx.Default" || type == "Ltx.Math") {
                region = this.pairMatcher.match(document, offset);
                if (region != null && region.getLength() >= 2) {
                    textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
                    return;
                }
                this.scanner.configure(document);
                region = this.scanner.findCommonWord(offset);
                if (region != null) {
                    textViewer.setSelectedRange(region.getOffset(), region.getLength());
                } else {
                    textViewer.setSelectedRange(offset, 0);
                }
                return;
            }
            if (type == "Ltx.Verbatim") {
                partitionOffset = partition.getOffset();
                partitionEnd = partitionOffset + partition.getLength();
                int start = partitionOffset + 6;
                if (partitionEnd - partitionOffset >= 7 && (offset == start - 1 || offset == start || offset == partitionEnd || offset == partitionEnd - 1)) {
                    String text = document.get(partitionOffset, 7);
                    if (text.startsWith("\\verb")) {
                        textViewer.setSelectedRange(start, this.getEndOffset(document, partitionEnd, new char[]{text.charAt(5)}) - start);
                    }
                    return;
                }
            }
            if (!(type != "Ltx.Comment" && type != "Ltx.MathComment" || offset != (partitionOffset = partition.getOffset()) && offset != partitionOffset + 1)) {
                IRegion lineInfo = document.getLineInformationOfOffset(partitionOffset);
                int end = Math.min(partitionOffset + partition.getLength(), lineInfo.getOffset() + lineInfo.getLength());
                textViewer.setSelectedRange(partitionOffset, end - partitionOffset);
                return;
            }
            super.doubleClicked(textViewer);
            return;
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        textViewer.setSelectedRange(offset, 0);
    }

    private int getEndOffset(IDocument document, int end, char[] endPattern) throws BadLocationException {
        int i = endPattern.length - 1;
        while (--end >= 0 && i >= 0) {
            if (document.getChar(end) != endPattern[i--]) break;
        }
        return end + 1;
    }
}

