/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.docmlet.tex.core.source.ITexDocumentConstants;
import org.eclipse.statet.docmlet.tex.core.source.LtxChunkHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.IPartitionConstraint;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;

public class LtxHeuristicTokenScanner
extends BasicHeuristicTokenScanner {
    public static final int CURLY_BRACKET_TYPE = 0;
    public static final int SQUARE_BRACKET_TYPE = 1;
    public static final int PARATHESIS_TYPE = 2;

    public static int getBracketType(char c) {
        switch (c) {
            case '{': 
            case '}': {
                return 0;
            }
            case '[': 
            case ']': {
                return 1;
            }
            case '(': 
            case ')': {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isEscaped(IDocument document, int offset) throws BadLocationException {
        boolean escaped = false;
        while (offset > 0 && document.getChar(--offset) == '\\') {
            boolean bl = escaped = !escaped;
        }
        return escaped;
    }

    public static int getSafeMathPartitionOffset(IDocumentPartitioner partitioner, int offset) throws BadLocationException, BadPartitioningException {
        int startOffset = offset;
        while (offset > 0) {
            ITypedRegion partition = partitioner.getPartition(offset - 1);
            String partitionType = partition.getType();
            if (partitionType == "Ltx.Default" || partitionType == "Ltx.Comment" || partitionType == "Ltx.Verbatim") {
                return startOffset;
            }
            offset = partitionType == "Ltx.Math" ? (startOffset = partition.getOffset()) : partition.getOffset();
        }
        return startOffset;
    }

    public static LtxHeuristicTokenScanner create(IDocContentSections documentContentInfo) {
        return documentContentInfo.getPrimaryType() == "org.eclipse.statet.Ltx" ? new LtxHeuristicTokenScanner(documentContentInfo) : new LtxChunkHeuristicTokenScanner(documentContentInfo);
    }

    protected LtxHeuristicTokenScanner(IDocContentSections documentContentInfo) {
        super(documentContentInfo, ITexDocumentConstants.LTX_DEFAULT_CONTENT_CONSTRAINT);
    }

    public void configure(IDocument document, String partitionType) {
        if (partitionType == "Ltx.Math") {
            super.configure(document, new IPartitionConstraint(){
                private boolean never;

                public boolean matches(String partitionType) {
                    if (this.never) {
                        return false;
                    }
                    if (partitionType == "Ltx.Math") {
                        return true;
                    }
                    if (LtxHeuristicTokenScanner.this.getDefaultPartitionConstraint().matches(partitionType)) {
                        this.never = true;
                    }
                    return false;
                }
            });
            return;
        }
        super.configure(document, partitionType);
    }

    public int[] computeBracketBalance(int backwardOffset, int forwardOffset, int[] initial, int searchType) {
        int[] balance = new int[3];
        BracketBalanceCondition condition = new BracketBalanceCondition();
        int breakType = -1;
        while (--backwardOffset >= 0) {
            if ((backwardOffset = this.scanBackward(backwardOffset, -1, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                balance[n] = balance[n] + 1;
                if (condition.type == searchType || balance[condition.type] <= 0) continue;
                breakType = condition.type;
                break;
            }
            int n = condition.type;
            balance[n] = balance[n] - 1;
        }
        int bound = this.getDocument().getLength();
        int i = 0;
        while (i < balance.length) {
            if (balance[i] < 0) {
                balance[i] = 0;
            }
            int n = i;
            balance[n] = balance[n] + initial[i];
            ++i;
        }
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                balance[n] = balance[n] + 1;
            } else {
                int n = condition.type;
                balance[n] = balance[n] - 1;
            }
            if (breakType >= 0 && balance[breakType] == 0) break;
            ++forwardOffset;
        }
        return balance;
    }

    private class BracketBalanceCondition
    extends BasicHeuristicTokenScanner.PartitionBasedCondition {
        private int type;
        private boolean open;

        private BracketBalanceCondition() {
            super((BasicHeuristicTokenScanner)LtxHeuristicTokenScanner.this);
        }

        protected boolean matchesChar() {
            switch (LtxHeuristicTokenScanner.this.ch) {
                case '{': {
                    this.type = 0;
                    this.open = true;
                    return true;
                }
                case '}': {
                    this.type = 0;
                    this.open = false;
                    return true;
                }
                case '[': {
                    this.type = 1;
                    this.open = true;
                    return true;
                }
                case ']': {
                    this.type = 1;
                    this.open = false;
                    return true;
                }
                case '(': {
                    this.type = 2;
                    this.open = true;
                    return true;
                }
                case ')': {
                    this.type = 2;
                    this.open = false;
                    this.open = false;
                    return true;
                }
            }
            return false;
        }
    }
}

