/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.util;

import java.net.MalformedURLException;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.ui.util.ExtendedURIEditorInput;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EcoreUIUtil {
    private EcoreUIUtil() {
    }

    public static void openWizardDialog(IWizard wizard) throws OperationCanceledException, ExecutionException {
        EcoreUIUtil.openWizardDialog(wizard, null);
    }

    public static void openWizardDialog(final IWizard wizard, TransactionalEditingDomain editingDomain) throws OperationCanceledException, ExecutionException {
        Assert.isNotNull((Object)wizard);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int result = new WizardDialog(ExtendedPlatformUI.getDisplay().getActiveShell(), wizard).open();
                if (result == 1) {
                    throw new OperationCanceledException(wizard.getWindowTitle());
                }
            }
        };
        if (editingDomain != null) {
            WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)runnable, (String)wizard.getWindowTitle());
        } else {
            runnable.run();
        }
    }

    public static URIEditorInput createURIEditorInput(Object object) {
        URI uri = null;
        if (object instanceof URI) {
            uri = (URI)object;
        } else if (object instanceof Resource) {
            uri = ((Resource)object).getURI();
        } else if (object instanceof EObject) {
            if (!((EObject)object).eIsProxy()) {
                uri = EcoreUtil.getURI((EObject)((EObject)object));
            }
        } else {
            if (object instanceof IWrapperItemProvider) {
                Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
                return EcoreUIUtil.createURIEditorInput(unwrapped);
            }
            if (object instanceof FeatureMap.Entry) {
                Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
                return EcoreUIUtil.createURIEditorInput(unwrapped);
            }
        }
        if (uri != null) {
            return new ExtendedURIEditorInput(uri);
        }
        return null;
    }

    public static IEditorDescriptor getDefaultEditor(Object object) {
        if (object instanceof EObject) {
            return EcoreUIUtil.getDefaultEditor(((EObject)object).eClass());
        }
        if (object instanceof IWrapperItemProvider) {
            Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
            return EcoreUIUtil.getDefaultEditor(unwrapped);
        }
        if (object instanceof FeatureMap.Entry) {
            Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
            return EcoreUIUtil.getDefaultEditor(unwrapped);
        }
        if (object instanceof Resource) {
            String fileName = ((Resource)object).getURI().lastSegment();
            return PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileName);
        }
        return null;
    }

    public static IEditorDescriptor[] getEditors(Object object) {
        if (object instanceof EObject) {
            return EcoreUIUtil.getEditors(((EObject)object).eClass());
        }
        if (object instanceof IWrapperItemProvider) {
            Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
            return EcoreUIUtil.getEditors(unwrapped);
        }
        if (object instanceof FeatureMap.Entry) {
            Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
            return EcoreUIUtil.getEditors(unwrapped);
        }
        if (object instanceof Resource) {
            String fileName = ((Resource)object).getURI().lastSegment();
            return PlatformUI.getWorkbench().getEditorRegistry().getEditors(fileName);
        }
        return null;
    }

    public static IEditorDescriptor[] getEditors(EClass eClass) {
        return EcoreUIUtil.findEditorsForType(eClass);
    }

    @Deprecated
    public static String getDummyFileName(Class<?> objectType) {
        String dummyFileName = "*." + objectType.getName();
        return dummyFileName;
    }

    public static String getDummyFileName(EClass eClass) {
        String dummyFileName = "*." + eClass.getInstanceClassName();
        return dummyFileName;
    }

    @Deprecated
    public static IEditorDescriptor getDefaultEditor(Class<?> type) {
        IEditorDescriptor descriptor = EcoreUIUtil.findDefaultEditorForType(type);
        if (descriptor == null) {
            descriptor = EcoreUIUtil.findDefaultEditorForSuperType(type);
        }
        return descriptor;
    }

    public static IEditorDescriptor getDefaultEditor(EClass eClass) {
        IEditorDescriptor descriptor = EcoreUIUtil.findDefaultEditorForType(eClass);
        if (descriptor == null) {
            descriptor = EcoreUIUtil.findDefaultEditorForSuperType(eClass);
        }
        return descriptor;
    }

    public static URI getURIFromEditorInput(IEditorInput editorInput) {
        IFile file;
        IURIEditorInput uriEditorInput;
        java.net.URI uri;
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            return URI.createPlatformResourceURI((String)fileEditorInput.getFile().getFullPath().toString(), (boolean)true);
        }
        if (editorInput instanceof URIEditorInput) {
            return ((URIEditorInput)editorInput).getURI();
        }
        if (editorInput instanceof IURIEditorInput && (uri = (uriEditorInput = (IURIEditorInput)editorInput).getURI()) != null) {
            try {
                return URI.createFileURI((String)uri.toURL().getFile());
            }
            catch (MalformedURLException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        if (editorInput != null && (file = (IFile)editorInput.getAdapter(IFile.class)) != null) {
            return EcorePlatformUtil.createURI((IPath)file.getFullPath());
        }
        return null;
    }

    public static IFile getFileFromEditorInput(IEditorInput editorInput) {
        if (editorInput instanceof URIEditorInput) {
            return EcorePlatformUtil.getFile((URI)((URIEditorInput)editorInput).getURI());
        }
        if (editorInput != null) {
            return (IFile)editorInput.getAdapter(IFile.class);
        }
        return null;
    }

    private static IEditorDescriptor[] findEditorsForType(EClass eClass) {
        HashSet<IEditorDescriptor> result = new HashSet<IEditorDescriptor>();
        if (eClass != null) {
            IEditorDescriptor[] iEditorDescriptorArray = PlatformUI.getWorkbench().getEditorRegistry().getEditors(EcoreUIUtil.getDummyFileName(eClass));
            int n = iEditorDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorDescriptor descriptor = iEditorDescriptorArray[n2];
                if (!EcoreUIUtil.isInapplicableTextBasedEditor(descriptor)) {
                    result.add(descriptor);
                }
                ++n2;
            }
            for (EClass superType : eClass.getEAllSuperTypes()) {
                IEditorDescriptor[] iEditorDescriptorArray2 = PlatformUI.getWorkbench().getEditorRegistry().getEditors(EcoreUIUtil.getDummyFileName(superType));
                int n3 = iEditorDescriptorArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorDescriptor descriptor = iEditorDescriptorArray2[n4];
                    if (!EcoreUIUtil.isInapplicableTextBasedEditor(descriptor)) {
                        result.add(descriptor);
                    }
                    ++n4;
                }
            }
        }
        return result.toArray(new IEditorDescriptor[result.size()]);
    }

    private static IEditorDescriptor findDefaultEditorForSuperType(Class<?> objectType) {
        if (objectType != null) {
            Class<?>[] interfaces;
            Class<?> superClass;
            HashSet superTypes = new HashSet();
            if (!objectType.isInterface() && (superClass = objectType.getSuperclass()) != null) {
                superTypes.add(superClass);
                IEditorDescriptor iEditorDescriptor = EcoreUIUtil.findDefaultEditorForType(superClass);
                if (iEditorDescriptor != null) {
                    return iEditorDescriptor;
                }
            }
            Class<?>[] classArray = interfaces = objectType.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                superTypes.add(clazz);
                IEditorDescriptor descriptor = EcoreUIUtil.findDefaultEditorForType(clazz);
                if (descriptor != null) {
                    return descriptor;
                }
                ++n2;
            }
            for (Class clazz : superTypes) {
                IEditorDescriptor descriptor = EcoreUIUtil.findDefaultEditorForSuperType(clazz);
                if (descriptor == null) continue;
                return descriptor;
            }
        }
        return null;
    }

    private static IEditorDescriptor findDefaultEditorForSuperType(EClass eClass) {
        if (eClass != null) {
            for (EClass superType : eClass.getEAllSuperTypes()) {
                IEditorDescriptor defaultEditor = EcoreUIUtil.findDefaultEditorForType(superType);
                if (defaultEditor == null) continue;
                return defaultEditor;
            }
        }
        return null;
    }

    private static IEditorDescriptor findDefaultEditorForType(Class<?> objectType) {
        if (objectType != null) {
            String dummyFileName = "*." + objectType.getName();
            IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(dummyFileName);
            if (descriptor != null) {
                if (!EcoreUIUtil.isInapplicableTextBasedEditor(descriptor)) {
                    return descriptor;
                }
                IEditorDescriptor[] iEditorDescriptorArray = PlatformUI.getWorkbench().getEditorRegistry().getEditors(dummyFileName);
                int n = iEditorDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorDescriptor alternativeDescriptor = iEditorDescriptorArray[n2];
                    if (alternativeDescriptor != descriptor && !EcoreUIUtil.isInapplicableTextBasedEditor(alternativeDescriptor)) {
                        return alternativeDescriptor;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private static IEditorDescriptor findDefaultEditorForType(EClass eClass) {
        IEditorDescriptor descriptor;
        if (eClass != null && (descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(EcoreUIUtil.getDummyFileName(eClass))) != null) {
            if (!EcoreUIUtil.isInapplicableTextBasedEditor(descriptor)) {
                return descriptor;
            }
            IEditorDescriptor[] iEditorDescriptorArray = PlatformUI.getWorkbench().getEditorRegistry().getEditors(EcoreUIUtil.getDummyFileName(eClass));
            int n = iEditorDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorDescriptor alternativeDescriptor = iEditorDescriptorArray[n2];
                if (alternativeDescriptor != descriptor && !EcoreUIUtil.isInapplicableTextBasedEditor(alternativeDescriptor)) {
                    return alternativeDescriptor;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean isInapplicableTextBasedEditor(IEditorDescriptor editorDescriptor) {
        return editorDescriptor.getId().startsWith("org.eclipse.ui") || editorDescriptor.getId().startsWith("org.eclipse.wst");
    }
}

