/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Nahbedienung;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMW Gsp Lage</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Nahbedienung.NahbedienungPackage#getENUMWGspLage()
 * @model extendedMetaData="name='ENUMW_Gsp_Lage'"
 * @generated
 */
public enum ENUMWGspLage implements Enumerator {
	/**
	 * The '<em><b>ENUMW Gsp Lage abgelegt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_ABGELEGT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_GSP_LAGE_ABGELEGT(0, "ENUMW_Gsp_Lage_abgelegt", "abgelegt"),

	/**
	 * The '<em><b>ENUMW Gsp Lage aufgelegt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_AUFGELEGT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_GSP_LAGE_AUFGELEGT(1, "ENUMW_Gsp_Lage_aufgelegt", "aufgelegt"),

	/**
	 * The '<em><b>ENUMW Gsp Lage links</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_LINKS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_GSP_LAGE_LINKS(2, "ENUMW_Gsp_Lage_links", "links"),

	/**
	 * The '<em><b>ENUMW Gsp Lage rechts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_RECHTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_GSP_LAGE_RECHTS(3, "ENUMW_Gsp_Lage_rechts", "rechts"),

	/**
	 * The '<em><b>ENUMW Gsp Lage sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_GSP_LAGE_SONSTIGE(4, "ENUMW_Gsp_Lage_sonstige", "sonstige");

	/**
	 * The '<em><b>ENUMW Gsp Lage abgelegt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_ABGELEGT
	 * @model name="ENUMW_Gsp_Lage_abgelegt" literal="abgelegt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_GSP_LAGE_ABGELEGT_VALUE = 0;

	/**
	 * The '<em><b>ENUMW Gsp Lage aufgelegt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_AUFGELEGT
	 * @model name="ENUMW_Gsp_Lage_aufgelegt" literal="aufgelegt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_GSP_LAGE_AUFGELEGT_VALUE = 1;

	/**
	 * The '<em><b>ENUMW Gsp Lage links</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_LINKS
	 * @model name="ENUMW_Gsp_Lage_links" literal="links"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_GSP_LAGE_LINKS_VALUE = 2;

	/**
	 * The '<em><b>ENUMW Gsp Lage rechts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_RECHTS
	 * @model name="ENUMW_Gsp_Lage_rechts" literal="rechts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_GSP_LAGE_RECHTS_VALUE = 3;

	/**
	 * The '<em><b>ENUMW Gsp Lage sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_GSP_LAGE_SONSTIGE
	 * @model name="ENUMW_Gsp_Lage_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_GSP_LAGE_SONSTIGE_VALUE = 4;

	/**
	 * An array of all the '<em><b>ENUMW Gsp Lage</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMWGspLage[] VALUES_ARRAY =
		new ENUMWGspLage[] {
			ENUMW_GSP_LAGE_ABGELEGT,
			ENUMW_GSP_LAGE_AUFGELEGT,
			ENUMW_GSP_LAGE_LINKS,
			ENUMW_GSP_LAGE_RECHTS,
			ENUMW_GSP_LAGE_SONSTIGE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMW Gsp Lage</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMWGspLage> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMW Gsp Lage</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMWGspLage get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMWGspLage result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMW Gsp Lage</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMWGspLage getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMWGspLage result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMW Gsp Lage</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMWGspLage get(int value) {
		switch (value) {
			case ENUMW_GSP_LAGE_ABGELEGT_VALUE: return ENUMW_GSP_LAGE_ABGELEGT;
			case ENUMW_GSP_LAGE_AUFGELEGT_VALUE: return ENUMW_GSP_LAGE_AUFGELEGT;
			case ENUMW_GSP_LAGE_LINKS_VALUE: return ENUMW_GSP_LAGE_LINKS;
			case ENUMW_GSP_LAGE_RECHTS_VALUE: return ENUMW_GSP_LAGE_RECHTS;
			case ENUMW_GSP_LAGE_SONSTIGE_VALUE: return ENUMW_GSP_LAGE_SONSTIGE;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMWGspLage(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMWGspLage
