/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Predicate;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class SourceFolderContentProvider
extends AbstractContentProviderAdapter {
    private final Predicate<IJavaElement> m_projectFilter;

    public SourceFolderContentProvider(Predicate<IJavaElement> projectFilter) {
        this.m_projectFilter = projectFilter;
    }

    @Override
    protected Collection<?> loadProposals(IProgressMonitor monitor) {
        try {
            IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            ArrayList result = new ArrayList();
            for (IJavaProject jp : javaProjects) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (this.m_projectFilter != null) {
                    if (!this.m_projectFilter.test((IJavaElement)jp)) continue;
                }
                S2eUtils.sourceFoldersOrdered((IJavaProject)jp).filter(root -> {
                    String srcFolderName = root.getPath().removeFirstSegments(1).toString().toLowerCase(Locale.US);
                    return "src/generated/java".equals(srcFolderName) || !srcFolderName.contains("generated");
                }).forEach(result::add);
            }
            return result;
        }
        catch (JavaModelException | SdkException e) {
            SdkLog.error((CharSequence)"Error while calculating possible source folders", (Object[])new Object[]{e});
            return Collections.emptySet();
        }
    }

    public String getText(Object element) {
        IJavaElement root = (IJavaElement)element;
        return root.getJavaProject().getElementName() + "/" + root.getPath().removeFirstSegments(1);
    }
}

