/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;

public final class TranslationInputValidator {
    private TranslationInputValidator() {
    }

    public static IStatus validateDefaultTranslation(CharSequence defaultTranslation) {
        return TranslationInputValidator.toStatus(TranslationValidator.validateDefaultText((CharSequence)defaultTranslation, null));
    }

    public static IStatus validateNlsKey(TranslationManager manager, ITranslationStore target, String key) {
        return TranslationInputValidator.validateNlsKey(manager, target, key, null);
    }

    public static IStatus validateNlsKey(TranslationManager manager, ITranslationStore target, String key, Collection<String> acceptedKeys) {
        return TranslationInputValidator.toStatus(TranslationValidator.validateKey((TranslationManager)manager, (ITranslationStore)target, (String)key, acceptedKeys));
    }

    public static IStatus validateTranslationStore(ITranslationStore store) {
        if (store == null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "Please choose a service.", null);
        }
        if (!store.isEditable()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "The selected service is read-only.", null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus toStatus(int validationResult) {
        if (validationResult == 0) {
            return Status.OK_STATUS;
        }
        int severity = 4;
        if (!TranslationValidator.isForbidden((int)validationResult)) {
            severity = 2;
        }
        return new Status(severity, "org.eclipse.scout.sdk.s2e.ui", validationResult, TranslationInputValidator.getValidationText(validationResult), null);
    }

    private static String getValidationText(int validationResult) {
        return switch (validationResult) {
            case 0 -> "";
            case 50000 -> "The default text must be set.";
            case 70000 -> "Please specify a key.";
            case 40000 -> "This key already exists!";
            case 100 -> "The key overrides an inherited entry.";
            case 200 -> "The key is overridden by another entry.";
            case 300 -> "The key overrides an inherited entry and is itself overridden by another entry.";
            case 400 -> "This text will be removed and the inherited text becomes active.";
            default -> "The key is not valid.";
        };
    }
}

