/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.project;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.operation.project.ScoutProjectNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.project.ScoutProjectNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.ui.wizard.WizardFinishTask;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ScoutProjectNewWizard
extends AbstractWizard
implements INewWizard {
    private ScoutProjectNewWizardPage m_page1;
    private WizardFinishTask<ScoutProjectNewOperation> m_finishTask;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Scout Project");
        this.setHelpAvailable(true);
        this.setDefaultPageImageDescriptor(S2ESdkUiActivator.getImageDescriptor("newscoutprj_wiz.png"));
        this.m_page1 = new ScoutProjectNewWizardPage();
        this.addPage((IWizardPage)this.m_page1);
        this.m_finishTask = new WizardFinishTask(workbench.getDisplay());
        this.m_finishTask.withOperation(ScoutProjectNewOperation::new).withMapper(this::mapPageToOperation).withUiAction((op, d) -> {
            List createdProjects = op.getCreatedProjects();
            if (createdProjects != null && !createdProjects.isEmpty()) {
                new P_MappingDiscoveryJob(createdProjects).schedule();
            }
        });
    }

    public WizardFinishTask<ScoutProjectNewOperation> getFinishTask() {
        return this.m_finishTask;
    }

    @Override
    public boolean performFinish() {
        if (!this.allPagesCanFinish()) {
            return false;
        }
        EclipseEnvironment.runInEclipseEnvironment(this.getFinishTask(), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        return true;
    }

    protected void mapPageToOperation(WizardFinishTask.PageToOperationMappingInput input, ScoutProjectNewOperation op) {
        op.setDisplayName(this.m_page1.getDisplayName());
        op.setGroupId(this.m_page1.getGroupId());
        op.setArtifactId(this.m_page1.getArtifactId());
        op.setUseJsClient(this.m_page1.isUseJsClient());
        op.setScoutVersion(this.m_page1.getScoutVersion());
        if (this.m_page1.isUseWorkspaceLocation()) {
            op.setTargetDirectory(ScoutProjectNewWizardPage.getWorkspaceLocation());
        } else {
            op.setTargetDirectory(this.m_page1.getTargetDirectory());
        }
        String path = null;
        if (this.m_page1.getTargetDirectory() != null) {
            path = this.m_page1.getTargetDirectory().toAbsolutePath().toString();
        }
        this.getDialogSettings().put("targetDirSetting", path);
    }

    protected static final class P_MappingDiscoveryJob
    extends MappingDiscoveryJob {
        public P_MappingDiscoveryJob(Collection<IProject> projects) {
            super(projects);
        }

        protected void discoverProposals(LifecycleMappingDiscoveryRequest discoveryRequest, IProgressMonitor monitor) throws CoreException {
            super.discoverProposals(discoveryRequest, monitor);
            for (Map.Entry entry : discoveryRequest.getAllProposals().entrySet()) {
                List proposals;
                MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement req;
                if (!(entry.getKey() instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement) || !"default-compile".equals((req = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)entry.getKey()).getExecutionId()) && !"default-testCompile".equals(req.getExecutionId()) || (proposals = (List)entry.getValue()) == null || proposals.size() <= 1) continue;
                proposals.removeIf(proposal -> proposal == null || !proposal.toString().endsWith("Eclipse JDT Compiler"));
            }
        }
    }
}

