/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal.AbstractTranslationProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TranslationProposal
extends AbstractTranslationProposal {
    private final ITranslation m_translation;
    private final Image m_image;

    public TranslationProposal(ITranslation nlsEntry, String prefix, int initialOffset) {
        super(prefix, initialOffset);
        this.m_translation = nlsEntry;
        this.m_image = S2ESdkUiActivator.getImage("comment.png");
    }

    @Override
    public int getRelevance() {
        return 1;
    }

    @Override
    public String getAdditionalProposalInfo() {
        Map allTranslations = this.m_translation.texts();
        if (allTranslations.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry e : allTranslations.entrySet()) {
            CharSequence text = Strings.replaceEach((CharSequence)Strings.escapeHtml((CharSequence)((CharSequence)e.getValue())), (CharSequence[])new String[]{"\n", "\r"}, (CharSequence[])new String[]{"<br>", ""});
            b.append("<b>").append(text).append("</b> [").append(Strings.escapeHtml((CharSequence)((Language)e.getKey()).displayName())).append("]<br>");
        }
        return b.toString();
    }

    public String getDisplayString() {
        return this.m_translation.key();
    }

    public Image getImage() {
        return this.m_image;
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        try {
            this.replaceWith(document, offset, this.m_translation.key());
        }
        catch (BadLocationException e) {
            SdkLog.error((Object[])new Object[]{e});
        }
    }

    @Override
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (super.validate(document, offset, event)) {
            try {
                Point keyRange = TranslationProposal.findKeyRange(document, offset);
                if (keyRange == null) {
                    return false;
                }
                String prefix = document.get(keyRange.x, offset - keyRange.x);
                return Strings.startsWith((String)this.m_translation.key(), (String)prefix, (boolean)false);
            }
            catch (BadLocationException e) {
                SdkLog.warning((Object[])new Object[]{e});
                return false;
            }
        }
        return false;
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.m_translation.key();
    }

    @Override
    public boolean isAutoInsertable() {
        return true;
    }
}

