/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.scout.sdk.core.model.api.internal.JavaEnvironmentImplementor;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.PropertySupport;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.environment.model.ClasspathWithJdt;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class S2eUtils {
    private S2eUtils() {
    }

    public static void waitForJdt() {
        AbstractJob.waitForJobFamily("org.eclipse.jdt.ui");
    }

    public static PropertySupport propertyMap(IJavaProject p, Path targetPath) {
        PropertySupport context = new PropertySupport(2);
        context.setProperty("JavaProject", (Object)p);
        context.setProperty("TargetPath", (Object)targetPath);
        return context;
    }

    public static IStatus makeCommittable(Collection<IResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return Status.OK_STATUS;
        }
        HashSet<IFile> existingReadOnlyFiles = new HashSet<IFile>(resources.size());
        for (IResource r : resources) {
            if (r == null || !r.exists() || r.getType() != 1 || !S2eUtils.isReadOnly(r)) continue;
            existingReadOnlyFiles.add((IFile)r);
        }
        if (existingReadOnlyFiles.isEmpty()) {
            return Status.OK_STATUS;
        }
        Map<IFile, Long> oldTimeStamps = S2eUtils.createModificationStampMap(existingReadOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(existingReadOnlyFiles.toArray(new IFile[0]), IWorkspace.VALIDATE_PROMPT);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        for (IFile f : existingReadOnlyFiles) {
            if (!S2eUtils.isReadOnly((IResource)f)) continue;
            String message = "File '" + f.getFullPath() + "' is read only.";
            modified = S2eUtils.addStatus(modified, message);
        }
        Map<IFile, Long> newTimeStamps = S2eUtils.createModificationStampMap(existingReadOnlyFiles);
        for (Map.Entry<IFile, Long> e : oldTimeStamps.entrySet()) {
            IFile file = e.getKey();
            if (e.getValue().equals(newTimeStamps.get(file))) continue;
            String message = "File '" + file.getFullPath() + "' has been modified since the beginning of the operation.";
            modified = S2eUtils.addStatus(modified, message);
        }
        if (modified != null) {
            return modified;
        }
        return Status.OK_STATUS;
    }

    private static IStatus addStatus(IStatus status, String msg) {
        Status entry = new Status(4, "org.eclipse.scout.sdk.s2e", msg);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.scout.sdk.s2e", 0, msg, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    private static Map<IFile, Long> createModificationStampMap(Collection<IFile> files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>(files.size());
        for (IFile f : files) {
            map.put(f, f.getModificationStamp());
        }
        return map;
    }

    private static boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        return resourceAttributes != null && resourceAttributes.isReadOnly();
    }

    public static IPackageFragmentRoot getTestSourceFolder(IJavaProject orig, String fqnOfRequiredType) {
        IPackageFragmentRoot sourceFolder = S2eUtils.getTestSourceFolderInProject(orig, fqnOfRequiredType);
        if (JdtUtils.exists((IJavaElement)sourceFolder)) {
            return sourceFolder;
        }
        String[] testProjectSuffixes = new String[]{".test", ".tests", ".testing"};
        IJavaModel javaModel = orig.getJavaModel();
        String[] stringArray = testProjectSuffixes;
        int n = testProjectSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            IJavaProject testProject = javaModel.getJavaProject(String.valueOf(orig.getElementName()) + suffix);
            sourceFolder = S2eUtils.getTestSourceFolderInProject(testProject, fqnOfRequiredType);
            if (JdtUtils.exists((IJavaElement)sourceFolder)) {
                return sourceFolder;
            }
            ++n2;
        }
        return null;
    }

    private static IPackageFragmentRoot getTestSourceFolderInProject(IJavaProject project, String fqnOfRequiredType) {
        if (!JdtUtils.exists((IJavaElement)project)) {
            return null;
        }
        try {
            if (Strings.hasText((CharSequence)fqnOfRequiredType) && !JdtUtils.exists((IJavaElement)project.findType(fqnOfRequiredType))) {
                return null;
            }
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
        return S2eUtils.sourceFoldersOrdered(project).filter(element -> element.getPath().removeFirstSegments(1).toString().toLowerCase(Locale.ENGLISH).contains("test")).findAny().orElse(null);
    }

    public static Optional<IFile> findFileInWorkspace(URI uri) {
        if (uri == null) {
            return Optional.empty();
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(uri);
        if (files.length < 1) {
            return Optional.empty();
        }
        return Optional.of(files[0]);
    }

    public static Optional<IPackageFragmentRoot> primarySourceFolder(IJavaProject project) {
        return S2eUtils.sourceFoldersOrdered(project).findAny();
    }

    public static Stream<IPackageFragmentRoot> sourceFoldersOrdered(IJavaProject project) {
        if (!JdtUtils.exists((IJavaElement)project)) {
            return Stream.empty();
        }
        try {
            return Arrays.stream(project.getPackageFragmentRoots()).filter(ClasspathWithJdt::isJavaSourceFolder).sorted(Comparator.comparingInt(root -> JavaEnvironmentImplementor.priorityOfSourceFolder((Path)root.getResource().getLocation().toFile().toPath())));
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static IPackageFragmentRoot getDtoSourceFolder(IPackageFragmentRoot selectedSourceFolder) {
        if (!JdtUtils.exists((IJavaElement)selectedSourceFolder)) {
            return selectedSourceFolder;
        }
        IJavaProject targetProject = selectedSourceFolder.getJavaProject();
        if (!JdtUtils.exists((IJavaElement)targetProject)) {
            return selectedSourceFolder;
        }
        IFolder generatedFolder = targetProject.getProject().getFolder("src/generated/java");
        if (generatedFolder == null || !generatedFolder.exists()) {
            return selectedSourceFolder;
        }
        IPackageFragmentRoot generatedSourceFolder = targetProject.getPackageFragmentRoot((IResource)generatedFolder);
        if (!JdtUtils.exists((IJavaElement)generatedSourceFolder)) {
            return selectedSourceFolder;
        }
        return generatedSourceFolder;
    }

    public static Optional<IType> getSession(IJavaProject project, ScoutTier tier, IProgressMonitor monitor) {
        String sessionToFind;
        if (!JdtUtils.exists((IJavaElement)project)) {
            return Optional.empty();
        }
        JdtUtils.PublicPrimaryTypeFilter filter = new JdtUtils.PublicPrimaryTypeFilter(){

            @Override
            public boolean test(IType candidate) {
                if (!super.test(candidate)) {
                    return false;
                }
                try {
                    return candidate.isClass();
                }
                catch (JavaModelException e) {
                    throw new SdkException("Unable to check for flags in type '" + candidate.getFullyQualifiedName() + "'.", new Object[]{e});
                }
            }
        };
        switch (tier) {
            case Server: {
                sessionToFind = "org.eclipse.scout.rt.server.IServerSession";
                break;
            }
            case Client: 
            case HtmlUi: {
                sessionToFind = "org.eclipse.scout.rt.client.IClientSession";
                break;
            }
            default: {
                sessionToFind = "org.eclipse.scout.rt.shared.ISession";
            }
        }
        Set<IType> sessions = JdtUtils.findClassesInStrictHierarchy(project, sessionToFind, monitor, (Predicate<IType>)filter);
        if (sessions.isEmpty()) {
            return Optional.empty();
        }
        if (sessions.size() == 1) {
            return Optional.of(sessions.iterator().next());
        }
        return Optional.ofNullable(S2eUtils.findMostSpecific(sessions));
    }

    private static IType findMostSpecific(Iterable<IType> candidates) {
        ITypeHierarchy superHierarchy = null;
        for (IType t : candidates) {
            if (superHierarchy != null && superHierarchy.contains(t)) continue;
            try {
                superHierarchy = t.newSupertypeHierarchy(null);
            }
            catch (JavaModelException e) {
                throw new SdkException("Cannot calculate supertype hierarchy for type {}.", new Object[]{t, e});
            }
        }
        if (superHierarchy == null) {
            return null;
        }
        return superHierarchy.getType();
    }

    public static Document getPomDocument(IProject p) {
        IFile pom = p.getFile("pom.xml");
        return S2eUtils.readXmlDocument(pom);
    }

    public static Document readXmlDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        try {
            DocumentBuilder docBuilder = Xml.createDocumentBuilder();
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = file.getContents();){
                return docBuilder.parse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            throw new SdkException(e);
        }
    }

    public static Map<String, IStatus> mavenUpdate(Set<IProject> projects, boolean updateSnapshots, boolean updateConfig, boolean cleanProject, boolean refreshFromDisk, IProgressMonitor monitor) {
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyMap();
        }
        MavenPluginActivator mavenPlugin = MavenPluginActivator.getDefault();
        if (mavenPlugin == null) {
            return Collections.emptyMap();
        }
        ProjectConfigurationManager configurationManager = (ProjectConfigurationManager)mavenPlugin.getProjectConfigurationManager();
        if (configurationManager == null) {
            return Collections.emptyMap();
        }
        MavenUpdateRequest request = new MavenUpdateRequest(projects.toArray(new IProject[0]), false, updateSnapshots);
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyMap();
        }
        return configurationManager.updateProjectConfiguration(request, updateConfig, cleanProject, refreshFromDisk, monitor);
    }
}

