/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.jaxws;

import java.util.Map;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.jaxws.AbstractWebServiceNewOperation;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WebServiceMessageDialog
extends MessageDialogWithToggle {
    public static final String HIDE_CONSUMER_MSG = "hideWebServiceConsumerInfoMessage";
    public static final String HIDE_PROVIDER_MSG = "hideWebServiceProviderInfoMessage";
    private boolean m_isCopyToClipboard;

    protected WebServiceMessageDialog(Shell parentShell, String dialogTitle, Image image, String msg, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        super(parentShell, dialogTitle, image, msg, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
    }

    protected static String getScoutJaxWsDocumentationUrl() {
        String base = "http://eclipsescout.github.io/";
        String version = "10.0.6";
        int firstDotPos = version.indexOf(46);
        if (firstDotPos < 0) {
            SdkLog.warning((String)"Cannot parse current Scout version", (Object[])new Object[0]);
            return base;
        }
        int secondDotPos = version.indexOf(46, firstDotPos + 1);
        if (secondDotPos > 0) {
            version = version.substring(0, secondDotPos);
        }
        return String.valueOf(base) + version + "/technical-guide.html#webservices-with-jax-ws";
    }

    public static void open(AbstractWebServiceNewOperation op, Display d) {
        d.asyncExec(() -> {
            Shell[] shells;
            Shell shell = d.getActiveShell();
            if (shell == null && (shells = d.getShells()).length > 0) {
                shell = shells[0];
            }
            if (shell == null) {
                return;
            }
            WebServiceMessageDialog.open(op, shell);
        });
    }

    public static WebServiceMessageDialog open(AbstractWebServiceNewOperation op, Shell shell) {
        boolean showBox;
        String prefKey;
        String dialogTitle;
        String message;
        if (op.isCreateConsumer()) {
            message = WebServiceMessageDialog.getConsumerMessage(op);
            dialogTitle = "New Web Service Consumer created";
            prefKey = HIDE_CONSUMER_MSG;
        } else {
            message = WebServiceMessageDialog.getProviderMessage(op);
            dialogTitle = "New Web Service Provider created";
            prefKey = HIDE_PROVIDER_MSG;
        }
        IPreferenceStore store = S2ESdkUiActivator.getDefault().getPreferenceStore();
        String doNotShowAgainString = store.getString(prefKey);
        boolean bl = showBox = !"always".equals(doNotShowAgainString);
        if (!showBox) {
            return null;
        }
        WebServiceMessageDialog dialog = new WebServiceMessageDialog(shell, dialogTitle, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0, "Do not show this dialog again.", false);
        int style = 0x10000000;
        dialog.setShellStyle(dialog.getShellStyle() | style);
        dialog.setPrefStore(store);
        dialog.setPrefKey(prefKey);
        dialog.open();
        if (dialog.isCopyToClipboard()) {
            Clipboard clipboard = new Clipboard(shell.getDisplay());
            clipboard.setContents(new Object[]{String.valueOf(message) + "\n\nJAX-WS Documentation: " + WebServiceMessageDialog.getScoutJaxWsDocumentationUrl()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
        return dialog;
    }

    protected Control createMessageArea(Composite composite) {
        Control messageArea = super.createMessageArea(composite);
        this.createDocumentationHyperlink(composite);
        return messageArea;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(composite);
        GridDataFactory.defaultsFor((Control)composite).span(2, 0).applyTo((Control)composite);
        this.createCopyToClipboard(composite);
        return composite;
    }

    protected void createDocumentationHyperlink(Composite parent) {
        Label label = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)label);
        Hyperlink h = new Hyperlink(parent, 64);
        h.setText("See the JAX-WS Scout Documentation for details.");
        h.setForeground(parent.getDisplay().getSystemColor(9));
        h.setUnderlined(true);
        h.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                S2eUiUtils.showUrlInBrowser(WebServiceMessageDialog.getScoutJaxWsDocumentationUrl());
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)h);
    }

    protected void createCopyToClipboard(Composite parent) {
        final Button copyToClipboard = new Button(parent, 16416);
        copyToClipboard.setSelection(false);
        copyToClipboard.setText("Copy this message to the Clipboard.");
        copyToClipboard.setFont(parent.getFont());
        copyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceMessageDialog.this.m_isCopyToClipboard = copyToClipboard.getSelection();
            }
        });
        GridDataFactory.defaultsFor((Control)copyToClipboard).span(2, 0).applyTo((Control)copyToClipboard);
    }

    protected boolean isCopyToClipboard() {
        return this.m_isCopyToClipboard;
    }

    protected static String getConsumerMessage(AbstractWebServiceNewOperation op) {
        StringBuilder msgBuilder = new StringBuilder("The new Web Service consumer has been created.\n\nUsage example:\n");
        for (Map.Entry entry : op.getParsedWsdl().getServiceNames().entrySet()) {
            for (PortType pt : op.getParsedWsdl().getPortTypes((Service)entry.getKey())) {
                msgBuilder.append("- BEANS.get(").append(ParsedWsdl.WebServiceNames.getPortTypeClassName((String)pt.getQName().getLocalPart())).append(".class").append(");\n");
            }
        }
        msgBuilder.append("\nThe URL of the Web Service end point usually differs for several deployments. Therefore the following properties have been generated to configure the end point URLs:\n");
        for (String urlProperty : op.getCreatedUrlProperties()) {
            msgBuilder.append("- ").append(urlProperty).append('\n');
        }
        msgBuilder.append("Add these properties to your config.properties files.\n");
        msgBuilder.append("\nIf the Web Service requires authentication, modify the Handlers of the created Web Service Clients:\n");
        for (IType client : op.getCreatedWebServiceClients()) {
            msgBuilder.append("- ").append(client.elementName()).append('\n');
        }
        WebServiceMessageDialog.addImplementorMsg(msgBuilder);
        return msgBuilder.toString();
    }

    protected static String getProviderMessage(AbstractWebServiceNewOperation op) {
        StringBuilder msgBuilder = new StringBuilder("The new Web Service provider has been created. The business logic can be implemented in the following classes:\n");
        for (IType providerImpl : op.getCreatedProviderServiceImpls()) {
            msgBuilder.append("- ").append(providerImpl.elementName()).append('\n');
        }
        msgBuilder.append("\nBy default this Web Service is configured to use Basic Authentication against credentials stored in the config.properties file. This may be changed by modifying the corresponding Entry Point Defintions:\n");
        for (IType entryPointDef : op.getCreatedEntryPointDefinitions()) {
            msgBuilder.append("- ").append(entryPointDef.elementName()).append('\n');
        }
        WebServiceMessageDialog.addImplementorMsg(msgBuilder);
        msgBuilder.append("\nDepending on your implementor and container you may also need to add the JAX-WS servlet to your web.xml file and to register the Web Service End Points.");
        return msgBuilder.toString();
    }

    protected static void addImplementorMsg(StringBuilder builder) {
        builder.append("\nThen you have to decide which JAX-WS implementor you want to use. It is strongly recommended to use the implementor that is included in your J2EE application server if any. ");
        builder.append("As soon as the implementor is known add the 'scout.jaxws.implementor' property to your config.properties files.\n");
        builder.append("If the desired JAX-WS implementor is not included in your application server, you also have to add the necessary dependencies to your pom.xml files to include this implementor in the deployment.");
    }
}

