/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.javadoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public final class JavaDocBrowser {
    private JavaDocBrowser() {
    }

    public static String getJavaDoc(IJavaElement element) {
        if (!JdtUtils.exists((IJavaElement)element)) {
            return null;
        }
        return JavaDocBrowser.getJavaDocHtml(element);
    }

    public static Browser create(Composite parent, String javaDocHtml) {
        if (!BrowserInformationControl.isAvailable((Composite)parent)) {
            return null;
        }
        Browser browser = new Browser(parent, 0);
        browser.setJavascriptEnabled(false);
        browser.setForeground(parent.getDisplay().getSystemColor(28));
        browser.setBackground(parent.getDisplay().getSystemColor(29));
        browser.addOpenWindowListener(event -> {
            event.required = true;
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                event.doit = "about:blank".equals(event.location);
            }

            public void changed(LocationEvent event) {
            }
        });
        browser.setText(javaDocHtml);
        return browser;
    }

    static String getJavaDocHtml(IJavaElement element) {
        String javaDoc;
        block3: {
            try {
                javaDoc = JavadocContentAccess2.getHTMLContent((IJavaElement)element, (boolean)true);
                if (!Strings.isBlank((CharSequence)javaDoc)) break block3;
                return null;
            }
            catch (CoreException e) {
                SdkLog.info((String)"Unable to get javadoc for element '{}'.", (Object[])new Object[]{element.getElementName(), e});
                return null;
            }
        }
        StringBuilder buffer = new StringBuilder();
        HTMLPrinter.insertPageProlog((StringBuilder)buffer, (int)0, (String)JavaDocBrowser.getCssStyles());
        buffer.append(javaDoc);
        JavaDocBrowser.insertBaseUrl(javaDoc, element, buffer);
        HTMLPrinter.addPageEpilog((StringBuilder)buffer);
        return buffer.toString();
    }

    static void insertBaseUrl(String javaDoc, IJavaElement element, StringBuilder buffer) {
        try {
            String base = JavadocContentAccess2.extractBaseURL((String)javaDoc);
            if (base == null) {
                boolean isBinary = element instanceof IMember && ((IMember)element).isBinary();
                base = JavaDocLocations.getBaseURL((IJavaElement)element, (boolean)isBinary);
            }
            if (base != null) {
                int endHeadIdx = buffer.indexOf("</head>");
                buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
            }
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to get base URL of javadoc for element '{}'.", (Object[])new Object[]{element.getElementName(), e});
        }
    }

    static String getCssStyles() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jdt.ui");
        if (bundle == null) {
            return null;
        }
        URL url = bundle.getEntry("/JavadocHoverStyleSheet.css");
        if (url == null) {
            return null;
        }
        String style = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileLocator.toFileURL((URL)url).openStream(), StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder(256);
                String line = reader.readLine();
                while (line != null) {
                    builder.append(line);
                    builder.append('\n');
                    line = reader.readLine();
                }
                style = builder.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            SdkLog.info((String)"Unable to read CSS Style for JavaDoc", (Object[])new Object[]{ex});
        }
        if (style != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            style = HTMLPrinter.convertTopLevelFont(style, (FontData)fontData);
        }
        return style;
    }
}

