/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.AbstractTranslationDialog;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.TranslationInputValidator;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.swt.widgets.Shell;

public class TranslationModifyDialog
extends AbstractTranslationDialog {
    public TranslationModifyDialog(Shell parentShell, TranslationStoreStack project, ITranslationEntry row) {
        super(parentShell, "Modify Entry", (ITranslation)row, project, false);
        this.setSelectedStore(row.store());
    }

    @Override
    protected void postCreate() {
        this.getKeyField().setEnabled(false);
        TextField defaultField = this.getDefaultTranslationField();
        if (defaultField != null) {
            defaultField.addModifyListener(e -> this.revalidate());
        }
        this.revalidate();
    }

    @Override
    protected void revalidate() {
        TextField defaultLangField = this.getTranslationField(Language.LANGUAGE_DEFAULT);
        if (defaultLangField == null) {
            return;
        }
        IStatus status = TranslationInputValidator.validateDefaultTranslation(defaultLangField.getText());
        if (status.isOK()) {
            this.setMessage("Create a new translation entry.");
        } else {
            this.setMessage(AbstractWizardPage.getHighestSeverityStatus(status));
        }
        this.getButton(0).setEnabled(status.getSeverity() != 4);
    }
}

