/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public abstract class AbstractCompressedStream
extends ServletOutputStream {
    private final String _encoding;
    protected HttpServletRequest _request;
    protected HttpServletResponse _response;
    protected OutputStream _out;
    protected ByteArrayOutputStream2 _bOut;
    protected DeflaterOutputStream _compressedOutputStream;
    protected boolean _closed;
    protected int _bufferSize;
    protected int _minCompressSize;
    protected long _contentLength;
    protected boolean _doNotCompress;

    public AbstractCompressedStream(String encoding, HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minCompressSize) throws IOException {
        this._encoding = encoding;
        this._request = request;
        this._response = response;
        this._contentLength = contentLength;
        this._bufferSize = bufferSize;
        this._minCompressSize = minCompressSize;
        if (minCompressSize == 0) {
            this.doCompress();
        }
    }

    public void resetBuffer() {
        if (this._response.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this._closed = false;
        this._out = null;
        this._bOut = null;
        if (this._compressedOutputStream != null) {
            this._response.setHeader("Content-Encoding", null);
        }
        this._compressedOutputStream = null;
        this._doNotCompress = false;
    }

    public void setContentLength(long length) {
        this._contentLength = length;
        if (this._doNotCompress && length >= 0L) {
            if (this._contentLength < Integer.MAX_VALUE) {
                this._response.setContentLength((int)this._contentLength);
            } else {
                this._response.setHeader("Content-Length", Long.toString(this._contentLength));
            }
        }
    }

    public void flush() throws IOException {
        if (this._out == null || this._bOut != null) {
            if (this._contentLength > 0L && this._contentLength < (long)this._minCompressSize) {
                this.doNotCompress();
            } else {
                this.doCompress();
            }
        }
        this._out.flush();
    }

    public void close() throws IOException {
        if (this._closed) {
            return;
        }
        if (this._request.getAttribute("javax.servlet.include.request_uri") != null) {
            this.flush();
        } else {
            if (this._bOut != null) {
                if (this._contentLength < 0L) {
                    this._contentLength = this._bOut.getCount();
                }
                if (this._contentLength < (long)this._minCompressSize) {
                    this.doNotCompress();
                } else {
                    this.doCompress();
                }
            } else if (this._out == null) {
                this.doNotCompress();
            }
            if (this._compressedOutputStream != null) {
                this._compressedOutputStream.close();
            } else {
                this._out.close();
            }
            this._closed = true;
        }
    }

    public void finish() throws IOException {
        if (!this._closed) {
            if (this._out == null || this._bOut != null) {
                if (this._contentLength > 0L && this._contentLength < (long)this._minCompressSize) {
                    this.doNotCompress();
                } else {
                    this.doCompress();
                }
            }
            if (this._compressedOutputStream != null && !this._closed) {
                this._closed = true;
                this._compressedOutputStream.close();
            }
        }
    }

    public void write(int b) throws IOException {
        this.checkOut(1);
        this._out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.checkOut(b.length);
        this._out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkOut(len);
        this._out.write(b, off, len);
    }

    public void doCompress() throws IOException {
        if (this._compressedOutputStream == null) {
            if (this._response.isCommitted()) {
                throw new IllegalStateException();
            }
            this.setHeader("Content-Encoding", this._encoding);
            if (this._response.containsHeader("Content-Encoding")) {
                this._compressedOutputStream = this.createStream();
                this._out = this._compressedOutputStream;
                if (this._bOut != null) {
                    this._out.write(this._bOut.getBuf(), 0, this._bOut.getCount());
                    this._bOut = null;
                }
            } else {
                this.doNotCompress();
            }
        }
    }

    public void doNotCompress() throws IOException {
        if (this._compressedOutputStream != null) {
            throw new IllegalStateException();
        }
        if (this._out == null || this._bOut != null) {
            this._doNotCompress = true;
            this._out = this._response.getOutputStream();
            this.setContentLength(this._contentLength);
            if (this._bOut != null) {
                this._out.write(this._bOut.getBuf(), 0, this._bOut.getCount());
            }
            this._bOut = null;
        }
    }

    private void checkOut(int length) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._out == null) {
            if (this._response.isCommitted() || this._contentLength >= 0L && this._contentLength < (long)this._minCompressSize) {
                this.doNotCompress();
            } else if (length > this._minCompressSize) {
                this.doCompress();
            } else {
                this._bOut = new ByteArrayOutputStream2(this._bufferSize);
                this._out = this._bOut;
            }
        } else if (this._bOut != null) {
            if (this._response.isCommitted() || this._contentLength >= 0L && this._contentLength < (long)this._minCompressSize) {
                this.doNotCompress();
            } else if (length >= this._bOut.getBuf().length - this._bOut.getCount()) {
                this.doCompress();
            }
        }
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public boolean isClosed() {
        return this._closed;
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }

    protected void setHeader(String name, String value) {
        this._response.setHeader(name, value);
    }

    protected abstract DeflaterOutputStream createStream() throws IOException;
}

