/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.internal.navigator.AdaptabilityUtility;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.ExtensionSequenceNumberComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSaveablesService;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.osgi.framework.BundleEvent;

public class NavigatorSaveablesService
implements INavigatorSaveablesService,
VisibilityAssistant.VisibilityListener {
    private NavigatorContentService contentService;
    private static List instances = new ArrayList();
    private Saveable[] currentSaveables;
    private ISaveablesLifecycleListener outsideListener;
    private ISaveablesLifecycleListener saveablesLifecycleListener = new LifecycleListener();
    private ISaveablesSource saveablesSource;
    private StructuredViewer viewer;
    private SaveablesProvider[] saveablesProviders;
    private DisposeListener disposeListener = new DisposeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void widgetDisposed(DisposeEvent e) {
            List list = instances;
            synchronized (list) {
                NavigatorSaveablesService navigatorSaveablesService = NavigatorSaveablesService.this;
                synchronized (navigatorSaveablesService) {
                    if (NavigatorSaveablesService.this.saveablesProviders != null) {
                        int i = 0;
                        while (i < NavigatorSaveablesService.this.saveablesProviders.length) {
                            NavigatorSaveablesService.this.saveablesProviders[i].dispose();
                            ++i;
                        }
                    }
                    NavigatorSaveablesService.removeInstance(NavigatorSaveablesService.this);
                    NavigatorSaveablesService.this.contentService = null;
                    NavigatorSaveablesService.this.currentSaveables = null;
                    NavigatorSaveablesService.this.outsideListener = null;
                    NavigatorSaveablesService.this.saveablesLifecycleListener = null;
                    NavigatorSaveablesService.this.saveablesSource = null;
                    NavigatorSaveablesService.this.viewer = null;
                    NavigatorSaveablesService.this.saveablesProviders = null;
                    NavigatorSaveablesService.this.disposeListener = null;
                }
            }
        }
    };
    private Map inactivePluginsWithSaveablesProviders;
    private Map saveablesProviderMap;
    static /* synthetic */ Class class$0;

    public NavigatorSaveablesService(NavigatorContentService contentService) {
        this.contentService = contentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInstance(NavigatorSaveablesService saveablesService) {
        List list = instances;
        synchronized (list) {
            instances.add(saveablesService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(NavigatorSaveablesService saveablesService) {
        List list = instances;
        synchronized (list) {
            instances.remove(saveablesService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void bundleChanged(BundleEvent event) {
        List list = instances;
        synchronized (list) {
            if (event.getType() == 2) {
                Iterator it = instances.iterator();
                while (it.hasNext()) {
                    NavigatorSaveablesService instance = (NavigatorSaveablesService)it.next();
                    instance.handleBundleStarted(event.getBundle().getSymbolicName());
                }
            } else if (event.getType() == 4) {
                Iterator it = instances.iterator();
                while (it.hasNext()) {
                    NavigatorSaveablesService instance = (NavigatorSaveablesService)it.next();
                    instance.handleBundleStopped(event.getBundle().getSymbolicName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ISaveablesSource saveablesSource, StructuredViewer viewer, ISaveablesLifecycleListener outsideListener) {
        List list = instances;
        synchronized (list) {
            NavigatorSaveablesService navigatorSaveablesService = this;
            synchronized (navigatorSaveablesService) {
                this.saveablesSource = saveablesSource;
                this.viewer = viewer;
                this.outsideListener = outsideListener;
                this.currentSaveables = this.computeSaveables();
                NavigatorSaveablesService.addInstance(this);
            }
        }
        viewer.getControl().addDisposeListener(this.disposeListener);
    }

    private boolean isDisposed() {
        return this.contentService == null;
    }

    /*
     * Unable to fully structure code
     */
    private Saveable[] computeSaveables() {
        contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        isTreepathContentProvider = contentProvider instanceof ITreePathContentProvider;
        viewerInput = this.viewer.getInput();
        result = new ArrayList<Saveable>();
        roots = new HashSet<Object>(Arrays.asList(contentProvider.getElements(viewerInput)));
        saveablesProviders = this.getSaveablesProviders();
        i = 0;
        while (i < saveablesProviders.length) {
            saveablesProvider = saveablesProviders[i];
            saveables = saveablesProvider.getSaveables();
            j = 0;
            while (j < saveables.length) {
                saveable = saveables[j];
                elements = saveablesProvider.getElements(saveable);
                foundRoot = false;
                k = 0;
                while (!foundRoot && k < elements.length) {
                    block9: {
                        block8: {
                            element = elements[k];
                            if (!roots.contains(element)) break block8;
                            result.add(saveable);
                            foundRoot = true;
                            break block9;
                        }
                        if (!isTreepathContentProvider) ** GOTO lbl48
                        treePathContentProvider = (ITreePathContentProvider)contentProvider;
                        parentPaths = treePathContentProvider.getParents(element);
                        l = 0;
                        while (!foundRoot && l < parentPaths.length) {
                            parentPath = parentPaths[l];
                            m = 0;
                            while (!foundRoot && m < parentPath.getSegmentCount()) {
                                if (roots.contains(parentPath.getSegment(m))) {
                                    result.add(saveable);
                                    foundRoot = true;
                                }
                                ++m;
                            }
                            ++l;
                        }
                        break block9;
lbl-1000:
                        // 1 sources

                        {
                            if (roots.contains(element)) {
                                result.add(saveable);
                                foundRoot = true;
                                continue;
                            }
                            element = contentProvider.getParent(element);
lbl48:
                            // 3 sources

                            ** while (!foundRoot && element != null)
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new Saveable[result.size()]);
    }

    public synchronized Saveable[] getActiveSaveables() {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection instanceof ITreeSelection) {
            return this.getActiveSaveablesFromTreeSelection((ITreeSelection)selection);
        }
        if (contentProvider instanceof ITreePathContentProvider) {
            return this.getActiveSaveablesFromTreePathProvider(selection, (ITreePathContentProvider)contentProvider);
        }
        return this.getActiveSaveablesFromTreeProvider(selection, contentProvider);
    }

    private Saveable[] getActiveSaveablesFromTreeSelection(ITreeSelection selection) {
        HashSet<Saveable> result = new HashSet<Saveable>();
        TreePath[] paths = selection.getPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            Saveable saveable = this.findSaveable(path);
            if (saveable != null) {
                result.add(saveable);
            }
            ++i;
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable[] getActiveSaveablesFromTreePathProvider(IStructuredSelection selection, ITreePathContentProvider provider) {
        HashSet<Saveable> result = new HashSet<Saveable>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            Saveable saveable = this.getSaveable(element);
            if (saveable != null) {
                result.add(saveable);
                continue;
            }
            TreePath[] paths = provider.getParents(element);
            saveable = this.findSaveable(paths);
            if (saveable == null) continue;
            result.add(saveable);
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable[] getActiveSaveablesFromTreeProvider(IStructuredSelection selection, ITreeContentProvider contentProvider) {
        HashSet<Saveable> result = new HashSet<Saveable>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            Saveable saveable = this.findSaveable(element, contentProvider);
            if (saveable == null) continue;
            result.add(saveable);
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable findSaveable(Object element, ITreeContentProvider contentProvider) {
        while (element != null) {
            Saveable saveable = this.getSaveable(element);
            if (saveable != null) {
                return saveable;
            }
            element = contentProvider.getParent(element);
        }
        return null;
    }

    private Saveable findSaveable(TreePath[] paths) {
        int i = 0;
        while (i < paths.length) {
            Saveable saveable = this.findSaveable(paths[i]);
            if (saveable != null) {
                return saveable;
            }
            ++i;
        }
        return null;
    }

    private Saveable findSaveable(TreePath path) {
        int count = path.getSegmentCount();
        int j = count - 1;
        while (j >= 0) {
            Object parent = path.getSegment(j);
            Saveable saveable = this.getSaveable(parent);
            if (saveable != null) {
                return saveable;
            }
            --j;
        }
        return null;
    }

    private Saveable getSaveable(Object element) {
        if (this.saveablesProviderMap == null) {
            this.getSaveablesProviders();
        }
        Iterator sItr = this.saveablesProviderMap.keySet().iterator();
        while (sItr.hasNext()) {
            SaveablesProvider provider;
            Saveable saveable;
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)sItr.next();
            if (!descriptor.isTriggerPoint(element) && !descriptor.isPossibleChild(element) || (saveable = (provider = (SaveablesProvider)this.saveablesProviderMap.get(descriptor)).getSaveable(element)) == null) continue;
            return saveable;
        }
        return null;
    }

    public synchronized Saveable[] getSaveables() {
        return this.currentSaveables;
    }

    private SaveablesProvider[] getSaveablesProviders() {
        if (this.saveablesProviders == null) {
            this.inactivePluginsWithSaveablesProviders = new HashMap();
            this.saveablesProviderMap = new TreeMap(ExtensionSequenceNumberComparator.INSTANCE);
            INavigatorContentDescriptor[] descriptors = this.contentService.getActiveDescriptorsWithSaveables();
            ArrayList<SaveablesProvider> result = new ArrayList<SaveablesProvider>();
            int i = 0;
            while (i < descriptors.length) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)descriptors[i];
                String pluginId = descriptor.getContribution().getPluginId();
                if (Platform.getBundle((String)pluginId).getState() != 32) {
                    ArrayList<NavigatorContentDescriptor> inactiveDescriptors = (ArrayList<NavigatorContentDescriptor>)this.inactivePluginsWithSaveablesProviders.get(pluginId);
                    if (inactiveDescriptors == null) {
                        inactiveDescriptors = new ArrayList<NavigatorContentDescriptor>();
                        this.inactivePluginsWithSaveablesProviders.put(pluginId, inactiveDescriptors);
                    }
                    inactiveDescriptors.add(descriptor);
                } else {
                    SaveablesProvider saveablesProvider = this.createSaveablesProvider(descriptor);
                    if (saveablesProvider != null) {
                        saveablesProvider.init(this.saveablesLifecycleListener);
                        result.add(saveablesProvider);
                        this.saveablesProviderMap.put(descriptor, saveablesProvider);
                    }
                }
                ++i;
            }
            this.saveablesProviders = result.toArray(new SaveablesProvider[result.size()]);
        }
        return this.saveablesProviders;
    }

    private SaveablesProvider createSaveablesProvider(NavigatorContentDescriptor descriptor) {
        NavigatorContentExtension extension = this.contentService.getExtension(descriptor, true);
        ITreeContentProvider contentProvider = extension.getContentProvider();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.navigator.SaveablesProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (SaveablesProvider)AdaptabilityUtility.getAdapter(contentProvider, clazz);
    }

    private void recomputeSaveablesAndNotify(boolean recomputeProviders, String startedBundleIdOrNull) {
        if (recomputeProviders && startedBundleIdOrNull == null && this.saveablesProviders != null) {
            int i = 0;
            while (i < this.saveablesProviders.length) {
                this.saveablesProviders[i].dispose();
                ++i;
            }
            this.saveablesProviders = null;
        } else if (startedBundleIdOrNull != null && this.inactivePluginsWithSaveablesProviders.containsKey(startedBundleIdOrNull)) {
            this.updateSaveablesProviders(startedBundleIdOrNull);
        }
        HashSet<Saveable> oldSaveables = new HashSet<Saveable>(Arrays.asList(this.currentSaveables));
        this.currentSaveables = this.computeSaveables();
        HashSet<Saveable> newSaveables = new HashSet<Saveable>(Arrays.asList(this.currentSaveables));
        final HashSet<Saveable> removedSaveables = new HashSet<Saveable>(oldSaveables);
        removedSaveables.removeAll(newSaveables);
        final HashSet<Saveable> addedSaveables = new HashSet<Saveable>(newSaveables);
        addedSaveables.removeAll(oldSaveables);
        if (addedSaveables.size() > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (NavigatorSaveablesService.this.isDisposed()) {
                        return;
                    }
                    NavigatorSaveablesService.this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)NavigatorSaveablesService.this.saveablesSource, 1, addedSaveables.toArray(new Saveable[addedSaveables.size()]), false));
                }
            });
        }
        if (removedSaveables.size() > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (NavigatorSaveablesService.this.isDisposed()) {
                        return;
                    }
                    NavigatorSaveablesService.this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)NavigatorSaveablesService.this.saveablesSource, 2, removedSaveables.toArray(new Saveable[removedSaveables.size()]), true));
                    NavigatorSaveablesService.this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)NavigatorSaveablesService.this.saveablesSource, 3, removedSaveables.toArray(new Saveable[removedSaveables.size()]), false));
                }
            });
        }
    }

    private void updateSaveablesProviders(String startedBundleId) {
        ArrayList<SaveablesProvider> result = new ArrayList<SaveablesProvider>(Arrays.asList(this.saveablesProviders));
        List descriptors = (List)this.inactivePluginsWithSaveablesProviders.get(startedBundleId);
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)it.next();
            SaveablesProvider saveablesProvider = this.createSaveablesProvider(descriptor);
            if (saveablesProvider == null) continue;
            saveablesProvider.init(this.saveablesLifecycleListener);
            result.add(saveablesProvider);
            this.saveablesProviderMap.put(descriptor, saveablesProvider);
        }
        this.saveablesProviders = result.toArray(new SaveablesProvider[result.size()]);
    }

    private synchronized void handleBundleStarted(String symbolicName) {
        if (!this.isDisposed() && this.inactivePluginsWithSaveablesProviders.containsKey(symbolicName)) {
            this.recomputeSaveablesAndNotify(true, symbolicName);
        }
    }

    private synchronized void handleBundleStopped(String symbolicName) {
        if (!this.isDisposed()) {
            this.recomputeSaveablesAndNotify(true, null);
        }
    }

    public synchronized void onVisibilityOrActivationChange() {
        if (!this.isDisposed()) {
            this.recomputeSaveablesAndNotify(true, null);
        }
    }

    private class LifecycleListener
    implements ISaveablesLifecycleListener {
        private LifecycleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
            Saveable[] saveables = event.getSaveables();
            Saveable[] shownSaveables = null;
            List list = instances;
            synchronized (list) {
                NavigatorSaveablesService navigatorSaveablesService = NavigatorSaveablesService.this;
                synchronized (navigatorSaveablesService) {
                    if (NavigatorSaveablesService.this.isDisposed()) {
                        return;
                    }
                    switch (event.getEventType()) {
                        case 1: {
                            NavigatorSaveablesService.this.recomputeSaveablesAndNotify(false, null);
                            break;
                        }
                        case 3: {
                            NavigatorSaveablesService.this.recomputeSaveablesAndNotify(false, null);
                            break;
                        }
                        case 4: {
                            HashSet<Saveable> result = new HashSet<Saveable>(Arrays.asList(NavigatorSaveablesService.this.currentSaveables));
                            result.retainAll(Arrays.asList(saveables));
                            shownSaveables = result.toArray(new Saveable[result.size()]);
                        }
                    }
                }
            }
            if (shownSaveables != null && shownSaveables.length > 0) {
                NavigatorSaveablesService.this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)NavigatorSaveablesService.this.saveablesSource, 4, shownSaveables, false));
            }
        }
    }
}

