/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javax.management.ObjectName;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class WebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    private static boolean first = true;
    private WebappClassLoader classLoader = null;
    private Container container = null;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    private String loaderClass = "org.apache.catalina.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;
    private ArrayList<String> loaderRepositories = null;
    private boolean searchExternalFirst = false;
    private static final Log log = LogFactory.getLog(WebappLoader.class);

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    public boolean getSearchExternalFirst() {
        return this.searchExternalFirst;
    }

    public void setSearchExternalFirst(boolean searchExternalFirst) {
        this.searchExternalFirst = searchExternalFirst;
        if (this.classLoader != null) {
            this.classLoader.setSearchExternalFirst(searchExternalFirst);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addRepository(String repository) {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("webappLoader.addRepository", repository));
        }
        int i = 0;
        while (i < this.repositories.length) {
            if (repository.equals(this.repositories[i])) {
                return;
            }
            ++i;
        }
        String[] results = new String[this.repositories.length + 1];
        int i2 = 0;
        while (i2 < this.repositories.length) {
            results[i2] = this.repositories[i2];
            ++i2;
        }
        results[this.repositories.length] = repository;
        this.repositories = results;
        if (this.getState().isAvailable() && this.classLoader != null) {
            this.classLoader.addRepository(repository);
            if (this.loaderRepositories != null) {
                this.loaderRepositories.add(repository);
            }
            this.setClassPath();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(WebappLoader.class.getClassLoader());
                if (!(this.container instanceof StandardContext)) return;
                ((StandardContext)this.container).reload();
                return;
            }
            finally {
                if (this.container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.container.getLoader().getClassLoader());
                }
            }
        } else {
            this.closeJARs(false);
        }
    }

    @Override
    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public String[] getRepositories() {
        return (String[])this.repositories.clone();
    }

    public String getRepositoriesString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.repositories.length) {
            sb.append(this.repositories[i]).append(":");
            ++i;
        }
        return sb.toString();
    }

    public String[] getLoaderRepositories() {
        if (this.loaderRepositories == null) {
            return null;
        }
        String[] res = new String[this.loaderRepositories.size()];
        this.loaderRepositories.toArray(res);
        return res;
    }

    public String getLoaderRepositoriesString() {
        String[] repositories = this.getLoaderRepositories();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < repositories.length) {
            sb.append(repositories[i]).append(":");
            ++i;
        }
        return sb.toString();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader != null ? this.classLoader.modified() : false;
    }

    public void closeJARs(boolean force) {
        if (this.classLoader != null) {
            this.classLoader.closeJARs(force);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappLoader[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("webappLoader.starting"));
        }
        if (this.container.getResources() == null) {
            log.info("No resources for " + this.container);
            this.setState(LifecycleState.STARTING);
            return;
        }
        DirContextURLStreamHandlerFactory streamHandlerFactory = DirContextURLStreamHandlerFactory.getInstance();
        if (first) {
            first = false;
            try {
                URL.setURLStreamHandlerFactory(streamHandlerFactory);
            }
            catch (Exception e) {
                log.error("Error registering jndi stream handler", e);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.info("Dual registration of jndi stream handler: " + t.getMessage());
            }
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setResources(this.container.getResources());
            this.classLoader.setDelegate(this.delegate);
            this.classLoader.setSearchExternalFirst(this.searchExternalFirst);
            if (this.container instanceof StandardContext) {
                this.classLoader.setAntiJARLocking(((StandardContext)this.container).getAntiJARLocking());
                this.classLoader.setClearReferencesStatic(((StandardContext)this.container).getClearReferencesStatic());
                this.classLoader.setClearReferencesStopThreads(((StandardContext)this.container).getClearReferencesStopThreads());
                this.classLoader.setClearReferencesStopTimerThreads(((StandardContext)this.container).getClearReferencesStopTimerThreads());
                this.classLoader.setClearReferencesHttpClientKeepAliveThread(((StandardContext)this.container).getClearReferencesHttpClientKeepAliveThread());
            }
            int i = 0;
            while (i < this.repositories.length) {
                this.classLoader.addRepository(this.repositories[i]);
                ++i;
            }
            this.setRepositories();
            this.setClassPath();
            this.setPermissions();
            this.classLoader.start();
            DirContextURLStreamHandler.bind(this.classLoader, this.container.getResources());
            StandardContext ctx = (StandardContext)this.container;
            String contextName = ctx.getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            ObjectName cloname = new ObjectName(String.valueOf(MBeanUtils.getDomain(ctx)) + ":type=WebappClassLoader,context=" + contextName + ",host=" + ctx.getParent().getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, cloname, null);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error("LifecycleException ", t);
            throw new LifecycleException("start: ", t);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("webappLoader.stopping"));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        this.classLoader.stop();
        DirContextURLStreamHandler.unbind(this.classLoader);
        try {
            StandardContext ctx = (StandardContext)this.container;
            String contextName = ctx.getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            ObjectName cloname = new ObjectName(String.valueOf(MBeanUtils.getDomain(ctx)) + ":type=WebappClassLoader,context=" + contextName + ",host=" + ctx.getParent().getName());
            Registry.getRegistry(null, null).unregisterComponent(cloname);
        }
        catch (Exception e) {
            log.error("LifecycleException ", e);
        }
        this.classLoader = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                log.error(sm.getString("webappLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    private WebappClassLoader createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoader classLoader = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.container.getParentClassLoader();
        }
        Class[] argTypes = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{this.parentClassLoader};
        Constructor<?> constr = clazz.getConstructor(argTypes);
        classLoader = (WebappClassLoader)constr.newInstance(args);
        return classLoader;
    }

    private void setPermissions() {
        block20: {
            if (!Globals.IS_SECURITY_ENABLED) {
                return;
            }
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir != null) {
                try {
                    String workDirPath = workDir.getCanonicalPath();
                    this.classLoader.addPermission(new FilePermission(workDirPath, "read,write"));
                    this.classLoader.addPermission(new FilePermission(String.valueOf(workDirPath) + File.separator + "-", "read,write,delete"));
                }
                catch (IOException iOException) {}
            }
            try {
                String path;
                URL rootURL = servletContext.getResource("/");
                this.classLoader.addPermission(rootURL);
                String contextRoot = servletContext.getRealPath("/");
                if (contextRoot != null) {
                    try {
                        contextRoot = new File(contextRoot).getCanonicalPath();
                        this.classLoader.addPermission(contextRoot);
                    }
                    catch (IOException iOException) {}
                }
                URL classesURL = servletContext.getResource("/WEB-INF/classes/");
                this.classLoader.addPermission(classesURL);
                URL libURL = servletContext.getResource("/WEB-INF/lib/");
                this.classLoader.addPermission(libURL);
                if (contextRoot != null) {
                    if (libURL != null) {
                        File rootDir = new File(contextRoot);
                        File libDir = new File(rootDir, "WEB-INF/lib/");
                        try {
                            String path2 = libDir.getCanonicalPath();
                            this.classLoader.addPermission(path2);
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
                if (workDir == null) break block20;
                if (libURL != null) {
                    File libDir = new File(workDir, "WEB-INF/lib/");
                    try {
                        path = libDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException iOException) {}
                }
                if (classesURL != null) {
                    File classesDir = new File(workDir, "WEB-INF/classes/");
                    try {
                        path = classesDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setRepositories() throws IOException {
        block28: {
            if (!(this.container instanceof Context)) {
                return;
            }
            servletContext = ((Context)this.container).getServletContext();
            if (servletContext == null) {
                return;
            }
            this.loaderRepositories = new ArrayList<E>();
            workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir == null) {
                WebappLoader.log.info("No work dir for " + servletContext);
            }
            if (WebappLoader.log.isDebugEnabled() && workDir != null) {
                WebappLoader.log.debug(WebappLoader.sm.getString("webappLoader.deploy", new Object[]{workDir.getAbsolutePath()}));
            }
            this.classLoader.setWorkDir(workDir);
            resources = this.container.getResources();
            classesPath = "/WEB-INF/classes";
            classes = null;
            try {
                object = resources.lookup(classesPath);
                if (object instanceof DirContext) {
                    classes = (DirContext)object;
                }
            }
            catch (NamingException v0) {}
            if (classes != null) {
                classRepository = null;
                absoluteClassesPath = servletContext.getRealPath(classesPath);
                if (absoluteClassesPath != null) {
                    classRepository = new File(absoluteClassesPath);
                } else {
                    classRepository = new File(workDir, classesPath);
                    if (!classRepository.isDirectory() && !classRepository.mkdirs()) {
                        throw new IOException(WebappLoader.sm.getString("webappLoader.mkdirFailure"));
                    }
                    if (!this.copyDir(classes, classRepository)) {
                        throw new IOException(WebappLoader.sm.getString("webappLoader.copyFailure"));
                    }
                }
                if (WebappLoader.log.isDebugEnabled()) {
                    WebappLoader.log.debug(WebappLoader.sm.getString("webappLoader.classDeploy", new Object[]{classesPath, classRepository.getAbsolutePath()}));
                }
                this.classLoader.addRepository(String.valueOf(classesPath) + "/", classRepository);
                this.loaderRepositories.add(String.valueOf(classesPath) + "/");
            }
            libPath = "/WEB-INF/lib";
            this.classLoader.setJarPath(libPath);
            libDir = null;
            try {
                object = resources.lookup(libPath);
                if (object instanceof DirContext) {
                    libDir = (DirContext)object;
                }
            }
            catch (NamingException v1) {}
            if (libDir == null) break block28;
            copyJars = false;
            absoluteLibPath = servletContext.getRealPath(libPath);
            destDir = null;
            if (absoluteLibPath != null) {
                destDir = new File(absoluteLibPath);
            } else {
                copyJars = true;
                destDir = new File(workDir, libPath);
                if (!destDir.isDirectory() && !destDir.mkdirs()) {
                    throw new IOException(WebappLoader.sm.getString("webappLoader.mkdirFailure"));
                }
            }
            enumeration = null;
            try {
                enumeration = libDir.list("");
                if (true) ** GOTO lbl94
            }
            catch (NamingException e) {
                ioe = new IOException(WebappLoader.sm.getString("webappLoader.namingFailure", new Object[]{libPath}));
                ioe.initCause(e);
                throw ioe;
            }
            do {
                ncPair = (NameClassPair)enumeration.nextElement();
                filename = String.valueOf(libPath) + "/" + ncPair.getName();
                if (!filename.endsWith(".jar")) continue;
                destFile = new File(destDir, ncPair.getName());
                if (WebappLoader.log.isDebugEnabled()) {
                    WebappLoader.log.debug(WebappLoader.sm.getString("webappLoader.jarDeploy", new Object[]{filename, destFile.getAbsolutePath()}));
                }
                obj = null;
                try {
                    obj = libDir.lookup(ncPair.getName());
                }
                catch (NamingException e) {
                    ioe = new IOException(WebappLoader.sm.getString("webappLoader.namingFailure", new Object[]{filename}));
                    ioe.initCause(e);
                    throw ioe;
                }
                if (!(obj instanceof Resource)) continue;
                jarResource = (Resource)obj;
                if (copyJars && !this.copy(jarResource.streamContent(), new FileOutputStream(destFile))) {
                    throw new IOException(WebappLoader.sm.getString("webappLoader.copyFailure"));
                }
                try {
                    jarFile = new JarFile(destFile);
                    this.classLoader.addJar(filename, jarFile, destFile);
                }
                catch (Exception v2) {}
                this.loaderRepositories.add(filename);
lbl94:
                // 4 sources

            } while (enumeration.hasMoreElements());
        }
    }

    private void setClassPath() {
        String baseClasspath;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        if (this.container instanceof StandardContext && (baseClasspath = ((StandardContext)this.container).getCompilerClasspath()) != null) {
            servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)baseClasspath);
            return;
        }
        StringBuilder classpath = new StringBuilder();
        ClassLoader loader = this.getClassLoader();
        int n = 0;
        while (loader != null) {
            if (!(loader instanceof URLClassLoader)) {
                String cp = this.getClasspath(loader);
                if (cp == null) {
                    log.info("Unknown loader " + loader + " " + loader.getClass());
                    break;
                }
                if (n > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(cp);
                ++n;
                break;
            }
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            int i = 0;
            while (i < repositories.length) {
                block16: {
                    String repository;
                    block14: {
                        block15: {
                            block13: {
                                repository = repositories[i].toString();
                                if (!repository.startsWith("file://")) break block13;
                                repository = repository.substring(7);
                                break block14;
                            }
                            if (!repository.startsWith("file:")) break block15;
                            repository = repository.substring(5);
                            break block14;
                        }
                        if (!repository.startsWith("jndi:")) break block16;
                        repository = servletContext.getRealPath(repository.substring(5));
                    }
                    if (repository != null) {
                        if (n > 0) {
                            classpath.append(File.pathSeparator);
                        }
                        classpath.append(repository);
                        ++n;
                    }
                }
                ++i;
            }
            loader = loader.getParent();
        }
        this.classpath = classpath.toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath.toString());
    }

    private String getClasspath(ClassLoader loader) {
        Method m;
        block7: {
            try {
                m = loader.getClass().getMethod("getClasspath", new Class[0]);
                if (log.isTraceEnabled()) {
                    log.trace("getClasspath " + m);
                }
                if (m != null) break block7;
                return null;
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug("getClasspath ", ex);
                }
                return null;
            }
        }
        Object o = m.invoke((Object)loader, new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("gotClasspath " + o);
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyDir(DirContext srcDir, File destDir) {
        try {
            NamingEnumeration<NameClassPair> enumeration = srcDir.list("");
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return true;
                }
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String name = ncPair.getName();
                Object object = srcDir.lookup(name);
                File currentFile = new File(destDir, name);
                if (object instanceof Resource) {
                    FileOutputStream os;
                    InputStream is = ((Resource)object).streamContent();
                    if (this.copy(is, os = new FileOutputStream(currentFile))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    FileOutputStream os = new FileOutputStream(currentFile);
                    if (this.copy((InputStream)object, os)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                if (!currentFile.isDirectory() && !currentFile.mkdir()) {
                    return false;
                }
                if (!this.copyDir((DirContext)object, currentFile)) break;
            }
            return false;
        }
        catch (NamingException namingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean copy(InputStream is, OutputStream os) {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Loader");
        if (this.container instanceof Context) {
            name.append(",context=");
            Context context = (Context)this.container;
            String contextName = context.getName();
            if (!contextName.startsWith("/")) {
                name.append("/");
            }
            name.append(contextName);
            name.append(",host=");
            name.append(context.getParent().getName());
        } else {
            name.append(",container=");
            name.append(this.container.getName());
        }
        return name.toString();
    }
}

