/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.EOFException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.io.Content;

public abstract class ContentSourceCompletableFuture<X>
extends CompletableFuture<X> {
    private final Content.Source _content;

    public ContentSourceCompletableFuture(Content.Source content) {
        this._content = content;
    }

    public void parse() {
        while (true) {
            Content.Chunk chunk;
            if ((chunk = this._content.read()) == null) {
                this._content.demand(this::parse);
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                if (!chunk.isLast() && this.onTransientFailure(chunk.getFailure())) continue;
                this.completeExceptionally(chunk.getFailure());
                return;
            }
            try {
                X x = this.parse(chunk);
                if (x != null) {
                    this.complete(x);
                    return;
                }
            }
            catch (Throwable failure) {
                this.completeExceptionally(failure);
                return;
            }
            finally {
                chunk.release();
            }
            if (chunk.isLast()) break;
        }
        this.completeExceptionally(new EOFException());
    }

    protected abstract X parse(Content.Chunk var1) throws Throwable;

    protected boolean onTransientFailure(Throwable cause) {
        return false;
    }
}

