/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ConsumerContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.HostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IConsumerContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IHostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteReferenceNotFoundException;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IExtendedRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.IOSGiRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.remoteserviceadmin.EndpointPermission;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceAdmin
implements org.osgi.service.remoteserviceadmin.RemoteServiceAdmin {
    public static final String SERVICE_PROP = "org.eclipse.ecf.rsa";
    private Bundle clientBundle;
    private boolean hostAutoCreateContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.hostAutoCreateContainer", "true"));
    private String[] hostDefaultConfigTypes = new String[]{System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.hostDefaultConfigType", "ecf.generic.server")};
    private boolean consumerAutoCreateContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.consumerAutoCreateContainer", "true"));
    private Object eventAdminTrackerLock = new Object();
    private ServiceTracker eventAdminTracker;
    private Object remoteServiceAdminListenerTrackerLock = new Object();
    private ServiceTracker remoteServiceAdminListenerTracker;
    private HostContainerSelector defaultHostContainerSelector;
    private ServiceRegistration defaultHostContainerSelectorRegistration;
    private ConsumerContainerSelector defaultConsumerContainerSelector;
    private ServiceRegistration defaultConsumerContainerSelectorRegistration;
    private Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> exportedRegistrations;
    private Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> importedRegistrations;
    private Collection<ExportRegistration> localExportedRegistrations = new ArrayList<ExportRegistration>();
    private Collection<ImportRegistration> localImportedRegistrations = new ArrayList<ImportRegistration>();
    private ServiceRegistration eventListenerHookRegistration;
    private Object consumerContainerSelectorTrackerLock = new Object();
    private ServiceTracker consumerContainerSelectorTracker;
    private Object hostContainerSelectorTrackerLock = new Object();
    private ServiceTracker hostContainerSelectorTracker;
    private Map<Bundle, ProxyClassLoader> proxyClassLoaders = new HashMap<Bundle, ProxyClassLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExportRegistration> getExportedRegistrations() {
        Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            return new ArrayList<org.osgi.service.remoteserviceadmin.ExportRegistration>(this.exportedRegistrations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImportRegistration> getImportedRegistrations() {
        Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            return new ArrayList<org.osgi.service.remoteserviceadmin.ImportRegistration>(this.importedRegistrations);
        }
    }

    public RemoteServiceAdmin(Bundle clientBundle) {
        this(clientBundle, new ArrayList<org.osgi.service.remoteserviceadmin.ExportRegistration>(), new ArrayList<org.osgi.service.remoteserviceadmin.ImportRegistration>());
    }

    public RemoteServiceAdmin(Bundle clientBundle, Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> exportedRegistrations, Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> importedRegistrations) {
        this.clientBundle = clientBundle;
        Assert.isNotNull((Object)this.clientBundle);
        this.exportedRegistrations = exportedRegistrations;
        this.importedRegistrations = importedRegistrations;
        Properties props = new Properties();
        props.put("service.ranking", new Integer(Integer.MIN_VALUE));
        ServiceReference[] hostContainerSelectorRefs = null;
        BundleContext rsaBundleContext = this.getRSABundleContext();
        try {
            hostContainerSelectorRefs = rsaBundleContext.getServiceReferences(IHostContainerSelector.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (hostContainerSelectorRefs == null || hostContainerSelectorRefs.length == 0) {
            this.defaultHostContainerSelector = new HostContainerSelector(this.hostDefaultConfigTypes, this.hostAutoCreateContainer);
            this.defaultHostContainerSelectorRegistration = rsaBundleContext.registerService(IHostContainerSelector.class.getName(), (Object)this.defaultHostContainerSelector, (Dictionary)props);
        }
        ServiceReference[] consumerContainerSelectorRefs = null;
        try {
            consumerContainerSelectorRefs = rsaBundleContext.getServiceReferences(IConsumerContainerSelector.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (consumerContainerSelectorRefs == null || consumerContainerSelectorRefs.length == 0) {
            this.defaultConsumerContainerSelector = new ConsumerContainerSelector(this.consumerAutoCreateContainer);
            this.defaultConsumerContainerSelectorRegistration = rsaBundleContext.registerService(IConsumerContainerSelector.class.getName(), (Object)this.defaultConsumerContainerSelector, (Dictionary)props);
        }
        this.eventListenerHookRegistration = rsaBundleContext.registerService(EventListenerHook.class.getName(), (Object)new RSAEventListenerHook(), null);
    }

    private void handleServiceUnregistering(ServiceReference serviceReference) {
        List<ExportRegistration> ers = this.getExportedRegistrations();
        for (ExportRegistration exportedRegistration : ers) {
            if (!exportedRegistration.match(serviceReference)) continue;
            this.trace("handleServiceUnregistering", "closing exportRegistration for serviceReference=" + serviceReference);
            exportedRegistration.close();
        }
    }

    private boolean validExportedInterfaces(ServiceReference serviceReference, String[] exportedInterfaces) {
        if (exportedInterfaces == null || exportedInterfaces.length == 0) {
            return false;
        }
        List<String> objectClassList = Arrays.asList((String[])serviceReference.getProperty("objectClass"));
        int i = 0;
        while (i < exportedInterfaces.length) {
            if (!objectClassList.contains(exportedInterfaces[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> exportService(final ServiceReference<?> serviceReference, Map<String, ?> op) {
        this.trace("exportService", "serviceReference=" + serviceReference + ",properties=" + op);
        final Map overridingProperties = PropertiesUtil.mergeProperties(serviceReference, op == null ? Collections.EMPTY_MAP : op);
        final String[] exportedInterfaces = PropertiesUtil.getExportedInterfaces(serviceReference, overridingProperties);
        if (exportedInterfaces == null) {
            throw new IllegalArgumentException("service.exported.interfaces not set");
        }
        if (!this.validExportedInterfaces(serviceReference, exportedInterfaces)) {
            return Collections.EMPTY_LIST;
        }
        String[] ecs = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.exported.configs"));
        if (ecs == null) {
            ecs = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.configs"));
        }
        final String[] exportedConfigs = ecs;
        final String[] serviceIntents = PropertiesUtil.getServiceIntents(serviceReference, overridingProperties);
        ArrayList<ExportRegistration> resultRegistrations = new ArrayList<ExportRegistration>();
        Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            ExportEndpoint exportEndpoint = this.findExistingExportEndpoint(serviceReference, null);
            if (exportEndpoint != null) {
                this.trace("exportService", "serviceReference=" + serviceReference + " export endpoint already exists=" + exportEndpoint + ".  Returning new ExportRegistration for existing endpoint");
                ExportRegistration reg = new ExportRegistration(exportEndpoint);
                this.addExportRegistration(reg);
                resultRegistrations.add(reg);
            }
        }
        if (resultRegistrations.size() == 0) {
            final IHostContainerSelector hostContainerSelector = this.getHostContainerSelector();
            IRemoteServiceContainer[] rsContainers = null;
            try {
                rsContainers = (IRemoteServiceContainer[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SelectContainerException {
                        return hostContainerSelector.selectHostContainers(serviceReference, overridingProperties, exportedInterfaces, exportedConfigs, serviceIntents);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new IllegalArgumentException("Failed to select, create, or configure ECF host container", e.getException());
            }
            if (resultRegistrations.size() == 0) {
                if (rsContainers == null || rsContainers.length == 0) {
                    String errorMessage = "No containers found for serviceReference=" + serviceReference + " properties=" + overridingProperties + ". Remote service NOT EXPORTED";
                    this.logWarning("exportService", errorMessage);
                    return Collections.EMPTY_LIST;
                }
                Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> collection2 = this.exportedRegistrations;
                synchronized (collection2) {
                    int i = 0;
                    while (i < rsContainers.length) {
                        Map<String, Object> endpointDescriptionProperties = this.createExportEndpointDescriptionProperties(serviceReference, overridingProperties, exportedInterfaces, serviceIntents, rsContainers[i]);
                        EndpointDescription endpointDescription = new EndpointDescription(serviceReference, endpointDescriptionProperties);
                        this.checkEndpointPermission(endpointDescription, "export");
                        ExportRegistration exportRegistration = null;
                        try {
                            exportRegistration = this.exportService(serviceReference, overridingProperties, exportedInterfaces, rsContainers[i], endpointDescriptionProperties);
                        }
                        catch (Exception e) {
                            exportRegistration = new ExportRegistration(e, endpointDescription);
                        }
                        this.addExportRegistration(exportRegistration);
                        resultRegistrations.add(exportRegistration);
                        ++i;
                    }
                }
            }
        }
        for (ExportRegistration exportReg : resultRegistrations) {
            this.publishExportEvent(exportReg);
        }
        return new ArrayList<org.osgi.service.remoteserviceadmin.ExportRegistration>(resultRegistrations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.osgi.service.remoteserviceadmin.ImportRegistration importService(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.trace("importService", "endpointDescription=" + endpointDescription);
        this.checkEndpointPermission(endpointDescription, "import");
        final EndpointDescription ed = endpointDescription instanceof EndpointDescription ? (EndpointDescription)endpointDescription : new EndpointDescription(endpointDescription.getProperties());
        final IConsumerContainerSelector consumerContainerSelector = this.getConsumerContainerSelector();
        if (consumerContainerSelector == null) {
            String errorMessage = "No consumerContainerSelector available";
            this.logError("importService", errorMessage, new SelectContainerException(errorMessage, null, null));
            return null;
        }
        IRemoteServiceContainer rsContainer = null;
        try {
            rsContainer = AccessController.doPrivileged(new PrivilegedExceptionAction<IRemoteServiceContainer>(){

                @Override
                public IRemoteServiceContainer run() throws SelectContainerException {
                    return consumerContainerSelector.selectConsumerContainer(ed);
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.logError("importService", "Unexpected exception in selectConsumerContainer", e.getException());
            return null;
        }
        if (rsContainer == null) {
            String errorMessage = "No remote service container selected for endpoint=" + endpointDescription + ". Remote service NOT IMPORTED";
            this.logError("importService", errorMessage, new SelectContainerException(errorMessage, null, null));
            return null;
        }
        ImportRegistration importRegistration = null;
        Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            ImportEndpoint importEndpoint = this.findImportEndpoint(ed);
            importRegistration = importEndpoint != null ? new ImportRegistration(importEndpoint) : this.importService(ed, rsContainer);
            this.addImportRegistration(importRegistration);
        }
        this.publishImportEvent(importRegistration);
        return importRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.osgi.service.remoteserviceadmin.ExportReference> getExportedServices() {
        ArrayList<org.osgi.service.remoteserviceadmin.ExportReference> results = new ArrayList<org.osgi.service.remoteserviceadmin.ExportReference>();
        Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            if (this.exportedRegistrations.isEmpty()) {
                this.checkRSAReadAccess();
            }
            for (org.osgi.service.remoteserviceadmin.ExportRegistration reg : this.exportedRegistrations) {
                org.osgi.service.remoteserviceadmin.ExportReference eRef = reg.getExportReference();
                if (eRef == null || !this.checkEndpointPermissionRead("getExportedServices", eRef.getExportedEndpoint())) continue;
                results.add(eRef);
            }
        }
        return results;
    }

    private void checkRSAReadAccess() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("endpoint.id", UUID.randomUUID().toString());
        props.put("objectClass", new String[]{UUID.randomUUID().toString()});
        props.put("service.imported.configs", UUID.randomUUID().toString());
        this.checkEndpointPermission(new org.osgi.service.remoteserviceadmin.EndpointDescription(props), "read");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.osgi.service.remoteserviceadmin.ImportReference> getImportedEndpoints() {
        ArrayList<org.osgi.service.remoteserviceadmin.ImportReference> results = new ArrayList<org.osgi.service.remoteserviceadmin.ImportReference>();
        Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            if (this.importedRegistrations.isEmpty()) {
                this.checkRSAReadAccess();
            }
            for (org.osgi.service.remoteserviceadmin.ImportRegistration reg : this.importedRegistrations) {
                org.osgi.service.remoteserviceadmin.ImportReference iRef = reg.getImportReference();
                if (iRef == null || !this.checkEndpointPermissionRead("getImportedEndpoints", iRef.getImportedEndpoint())) continue;
                results.add(iRef);
            }
        }
        return results;
    }

    private boolean checkEndpointPermissionRead(String methodName, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        try {
            this.checkEndpointPermission(endpointDescription, "read");
            return true;
        }
        catch (SecurityException e) {
            this.logError(methodName, "permission check failed for read access to endpointDescription=" + endpointDescription, e);
            return false;
        }
    }

    private BundleContext getClientBundleContext() {
        return this.clientBundle.getBundleContext();
    }

    private BundleContext getRSABundleContext() {
        return Activator.getContext();
    }

    private Bundle getRSABundle() {
        BundleContext bc = Activator.getContext();
        if (bc == null) {
            return null;
        }
        return bc.getBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImportRegistration(ImportRegistration importRegistration) {
        Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            this.importedRegistrations.add(importRegistration);
            this.localImportedRegistrations.add(importRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExportRegistration(ExportRegistration exportRegistration) {
        Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            this.exportedRegistrations.add(exportRegistration);
            this.localExportedRegistrations.add(exportRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeExportRegistration(ExportRegistration exportRegistration) {
        Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            this.localExportedRegistrations.remove(exportRegistration);
            return this.exportedRegistrations.remove(exportRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeImportRegistration(ImportRegistration importRegistration) {
        Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            this.localExportedRegistrations.remove(importRegistration);
            return this.importedRegistrations.remove(importRegistration);
        }
    }

    private void checkEndpointPermission(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String permissionType) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission((Permission)new EndpointPermission(endpointDescription, Activator.getDefault().getFrameworkUUID(), permissionType));
    }

    private void publishEvent(RemoteServiceAdminEvent event, EndpointDescription endpointDescription) {
        EndpointPermission perm = new EndpointPermission((org.osgi.service.remoteserviceadmin.EndpointDescription)endpointDescription, Activator.getDefault().getFrameworkUUID(), "read");
        RemoteServiceAdminListener[] listeners = this.getListeners(perm);
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].remoteAdminEvent((org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent)event);
                ++i;
            }
        }
        this.postEvent(event, endpointDescription);
    }

    private void postEvent(RemoteServiceAdminEvent event, EndpointDescription endpointDescription) {
        EventAdmin eventAdmin;
        List importedConfigs;
        List interfaces;
        String endpointId;
        String frameworkUUID;
        long serviceId;
        Throwable t;
        int eventType = event.getType();
        String eventTypeName = null;
        String registrationTypeName = null;
        switch (eventType) {
            case 2: {
                eventTypeName = "EXPORT_REGISTRATION";
                registrationTypeName = "export.registration";
                break;
            }
            case 6: {
                eventTypeName = "EXPORT_ERROR";
                registrationTypeName = "export.registration";
                break;
            }
            case 3: {
                eventTypeName = "EXPORT_UNREGISTRATION";
                registrationTypeName = "export.registration";
                break;
            }
            case 7: {
                eventTypeName = "EXPORT_WARNING";
                registrationTypeName = "export.registration";
                break;
            }
            case 10: {
                eventTypeName = "EXPORT_UPDATE";
                registrationTypeName = "export.registration";
                break;
            }
            case 1: {
                eventTypeName = "IMPORT_REGISTRATION";
                registrationTypeName = "import.registration";
                break;
            }
            case 5: {
                eventTypeName = "IMPORT_ERROR";
                registrationTypeName = "import.registration";
                break;
            }
            case 4: {
                eventTypeName = "IMPORT_UNREGISTRATION";
                registrationTypeName = "import.registration";
                break;
            }
            case 8: {
                eventTypeName = "IMPORT_WARNING";
                registrationTypeName = "import.registration";
                break;
            }
            case 9: {
                eventTypeName = "IMPORT_UPDATE";
                registrationTypeName = "import.registration";
            }
        }
        if (eventTypeName == null) {
            this.logError("postEvent", "Event type=" + eventType + " not understood for event=" + (Object)((Object)event) + ".  Not posting");
            return;
        }
        final String topic = "org/osgi/service/remoteserviceadmin/" + eventTypeName;
        Bundle rsaBundle = this.getRSABundle();
        if (rsaBundle == null) {
            this.logError("postEvent", "RSA Bundle is null.  Not posting remote service admin event=" + (Object)((Object)event));
            return;
        }
        final Properties eventProperties = new Properties();
        ((Dictionary)eventProperties).put("bundle", rsaBundle);
        ((Dictionary)eventProperties).put("bundle.id", new Long(rsaBundle.getBundleId()));
        ((Dictionary)eventProperties).put("bundle.symbolicname", rsaBundle.getSymbolicName());
        ((Dictionary)eventProperties).put("bundle.version", rsaBundle.getVersion());
        ArrayList<String> result = new ArrayList<String>();
        Map signers1 = this.clientBundle.getSignerCertificates(1);
        Iterator i = signers1.keySet().iterator();
        while (i.hasNext()) {
            result.add(i.next().toString());
        }
        String[] signers = result.toArray(new String[result.size()]);
        if (signers != null && signers.length > 0) {
            ((Dictionary)eventProperties).put("bundle.signer", signers);
        }
        if ((t = event.getException()) != null) {
            ((Dictionary)eventProperties).put("cause", t);
            ((Dictionary)eventProperties).put("exception", t);
            ((Dictionary)eventProperties).put("exception.class", t.getClass().getName());
            String exceptionMessage = t.getMessage();
            if (exceptionMessage != null) {
                ((Dictionary)eventProperties).put("exception.message", exceptionMessage);
            }
        }
        if ((serviceId = endpointDescription.getServiceId()) != 0L) {
            ((Dictionary)eventProperties).put("endpoint.service.id", new Long(serviceId));
        }
        if ((frameworkUUID = endpointDescription.getFrameworkUUID()) != null) {
            ((Dictionary)eventProperties).put("endpoint.framework.uuid", frameworkUUID);
        }
        if ((endpointId = endpointDescription.getId()) != null) {
            ((Dictionary)eventProperties).put("endpoint.id", endpointId);
        }
        if ((interfaces = endpointDescription.getInterfaces()) != null && interfaces.size() > 0) {
            ((Dictionary)eventProperties).put("objectClass", interfaces.toArray(new String[interfaces.size()]));
        }
        if ((importedConfigs = endpointDescription.getConfigurationTypes()) != null && importedConfigs.size() > 0) {
            ((Dictionary)eventProperties).put("service.imported.configs", importedConfigs.toArray(new String[importedConfigs.size()]));
        }
        ((Dictionary)eventProperties).put("timestamp", new Long(new Date().getTime()));
        ((Dictionary)eventProperties).put("event", event);
        if (registrationTypeName != null) {
            ((Dictionary)eventProperties).put(registrationTypeName, endpointDescription);
        }
        if ((eventAdmin = AccessController.doPrivileged(new PrivilegedAction<EventAdmin>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EventAdmin run() {
                Object object = RemoteServiceAdmin.this.eventAdminTrackerLock;
                synchronized (object) {
                    RemoteServiceAdmin.this.eventAdminTracker = new ServiceTracker(RemoteServiceAdmin.this.getRSABundleContext(), EventAdmin.class.getName(), null);
                    RemoteServiceAdmin.this.eventAdminTracker.open();
                }
                return (EventAdmin)RemoteServiceAdmin.this.eventAdminTracker.getService();
            }
        })) == null) {
            this.logError("postEvent", "No EventAdmin service available to send eventTopic=" + topic + " eventProperties=" + eventProperties);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                eventAdmin.postEvent(new Event(topic, eventProperties));
                return null;
            }
        });
    }

    private void publishExportEvent(ExportRegistration exportRegistration) {
        Throwable exception = exportRegistration.getException();
        org.osgi.service.remoteserviceadmin.ExportReference exportReference = exception == null ? exportRegistration.getExportReference() : null;
        EndpointDescription endpointDescription = exportRegistration.getEndpointDescription();
        RemoteServiceAdminEvent rsaEvent = new RemoteServiceAdminEvent(exportRegistration.getContainerID(), exception == null ? 2 : 6, this.getRSABundle(), exportReference, exception, endpointDescription);
        this.publishEvent(rsaEvent, endpointDescription);
    }

    private void publishImportEvent(ImportRegistration importRegistration) {
        Throwable exception = importRegistration.getException();
        org.osgi.service.remoteserviceadmin.ImportReference importReference = exception == null ? importRegistration.getImportReference() : null;
        EndpointDescription endpointDescription = importRegistration.getEndpointDescription();
        RemoteServiceAdminEvent rsaEvent = new RemoteServiceAdminEvent(importRegistration.getContainerID(), exception == null ? 1 : 5, this.getRSABundle(), importReference, exception, endpointDescription);
        this.publishEvent(rsaEvent, endpointDescription);
    }

    private RemoteServiceAdminListener[] getListeners(EndpointPermission perm) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                Object object = RemoteServiceAdmin.this.remoteServiceAdminListenerTrackerLock;
                synchronized (object) {
                    if (RemoteServiceAdmin.this.remoteServiceAdminListenerTracker == null) {
                        RemoteServiceAdmin.this.remoteServiceAdminListenerTracker = new ServiceTracker(RemoteServiceAdmin.this.getRSABundleContext(), RemoteServiceAdminListener.class.getName(), null);
                        RemoteServiceAdmin.this.remoteServiceAdminListenerTracker.open();
                    }
                    return null;
                }
            }
        });
        ServiceReference[] unfilteredRefs = this.remoteServiceAdminListenerTracker.getServiceReferences();
        if (unfilteredRefs == null) {
            return null;
        }
        ArrayList<ServiceReference> filteredRefs = new ArrayList<ServiceReference>();
        ServiceReference[] serviceReferenceArray = unfilteredRefs;
        int n = unfilteredRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            if (perm == null || ref.getBundle().hasPermission((Object)perm)) {
                filteredRefs.add(ref);
            }
            ++n2;
        }
        ArrayList<RemoteServiceAdminListener> results = new ArrayList<RemoteServiceAdminListener>();
        for (final ServiceReference ref : filteredRefs) {
            RemoteServiceAdminListener l = AccessController.doPrivileged(new PrivilegedAction<RemoteServiceAdminListener>(){

                @Override
                public RemoteServiceAdminListener run() {
                    return (RemoteServiceAdminListener)RemoteServiceAdmin.this.remoteServiceAdminListenerTracker.getService(ref);
                }
            });
            if (l == null) continue;
            results.add(l);
        }
        return results.toArray(new RemoteServiceAdminListener[results.size()]);
    }

    private ExportEndpoint findExistingExportEndpoint(ServiceReference serviceReference, ID containerID) {
        for (org.osgi.service.remoteserviceadmin.ExportRegistration eReg : this.exportedRegistrations) {
            ExportEndpoint exportEndpoint;
            if (!(eReg instanceof ExportRegistration) || (exportEndpoint = ((ExportRegistration)eReg).getExportEndpoint(serviceReference, containerID)) == null) continue;
            return exportEndpoint;
        }
        return null;
    }

    protected IHostContainerSelector getHostContainerSelector() {
        return AccessController.doPrivileged(new PrivilegedAction<IHostContainerSelector>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IHostContainerSelector run() {
                Object object = RemoteServiceAdmin.this.hostContainerSelectorTrackerLock;
                synchronized (object) {
                    if (RemoteServiceAdmin.this.hostContainerSelectorTracker == null) {
                        RemoteServiceAdmin.this.hostContainerSelectorTracker = new ServiceTracker(RemoteServiceAdmin.this.getRSABundleContext(), IHostContainerSelector.class.getName(), null);
                        RemoteServiceAdmin.this.hostContainerSelectorTracker.open();
                    }
                }
                return (IHostContainerSelector)RemoteServiceAdmin.this.hostContainerSelectorTracker.getService();
            }
        });
    }

    protected IConsumerContainerSelector getConsumerContainerSelector() {
        return AccessController.doPrivileged(new PrivilegedAction<IConsumerContainerSelector>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IConsumerContainerSelector run() {
                Object object = RemoteServiceAdmin.this.consumerContainerSelectorTrackerLock;
                synchronized (object) {
                    if (RemoteServiceAdmin.this.consumerContainerSelectorTracker == null) {
                        RemoteServiceAdmin.this.consumerContainerSelectorTracker = new ServiceTracker(RemoteServiceAdmin.this.getRSABundleContext(), IConsumerContainerSelector.class.getName(), null);
                        RemoteServiceAdmin.this.consumerContainerSelectorTracker.open();
                    }
                }
                return (IConsumerContainerSelector)RemoteServiceAdmin.this.consumerContainerSelectorTracker.getService();
            }
        });
    }

    private ContainerTypeDescription getContainerTypeDescription(ID containerID) {
        return Activator.getDefault().getContainerManager().getContainerTypeDescription(containerID);
    }

    private boolean isClient(IContainer container) {
        ContainerTypeDescription ctd = this.getContainerTypeDescription(container.getID());
        if (ctd == null) {
            return false;
        }
        return !ctd.isServer();
    }

    private Version getPackageVersion(final ServiceReference serviceReference, String serviceInterface, String packageName) {
        Object service = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return RemoteServiceAdmin.this.getRSABundleContext().getService(serviceReference);
            }
        });
        if (service == null) {
            return null;
        }
        Class<?>[] interfaceClasses = service.getClass().getInterfaces();
        if (interfaceClasses == null) {
            return null;
        }
        Class<?> interfaceClass = null;
        int i = 0;
        while (i < interfaceClasses.length) {
            if (interfaceClasses[i].getName().equals(serviceInterface)) {
                interfaceClass = interfaceClasses[i];
            }
            ++i;
        }
        if (interfaceClass == null) {
            return null;
        }
        Bundle providingBundle = FrameworkUtil.getBundle(interfaceClass);
        if (providingBundle == null) {
            return null;
        }
        return this.getVersionForPackage(providingBundle, packageName);
    }

    private Map<String, Object> createExportEndpointDescriptionProperties(ServiceReference serviceReference, Map<String, Object> overridingProperties, String[] exportedInterfaces, String[] serviceIntents, IRemoteServiceContainer rsContainer) {
        String rsFilter;
        String[] idFilter;
        ID connectedID;
        String[] remoteIntentsSupported;
        IContainer container = rsContainer.getContainer();
        ID containerID = container.getID();
        TreeMap<String, Object> endpointDescriptionProperties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        endpointDescriptionProperties.put("objectClass", exportedInterfaces);
        int i = 0;
        while (i < exportedInterfaces.length) {
            Version version;
            String packageName = this.getPackageName(exportedInterfaces[i]);
            String packageVersionKey = "endpoint.package.version." + packageName;
            String packageVersion = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, packageVersionKey);
            if (packageVersion == null && (version = this.getPackageVersion(serviceReference, exportedInterfaces[i], packageName)) != null && !version.equals((Object)Version.emptyVersion)) {
                packageVersion = version.toString();
            }
            if (packageVersion != null) {
                endpointDescriptionProperties.put(packageVersionKey, packageVersion);
            }
            ++i;
        }
        String endpointId = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "endpoint.id");
        if (endpointId == null) {
            endpointId = UUID.randomUUID().toString();
        }
        endpointDescriptionProperties.put("endpoint.id", endpointId);
        String ecfEndpointId = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "ecf.endpoint.id");
        if (ecfEndpointId == null) {
            ecfEndpointId = containerID.getName();
        }
        endpointDescriptionProperties.put("ecf.endpoint.id", ecfEndpointId);
        Long serviceId = (Long)serviceReference.getProperty("service.id");
        endpointDescriptionProperties.put("endpoint.service.id", serviceId);
        String frameworkId = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "endpoint.framework.uuid");
        if (frameworkId == null) {
            frameworkId = Activator.getDefault().getFrameworkUUID();
        }
        endpointDescriptionProperties.put("endpoint.framework.uuid", frameworkId);
        String[] remoteConfigsSupported = this.getSupportedConfigs(container.getID());
        if (remoteConfigsSupported != null) {
            endpointDescriptionProperties.put("remote.configs.supported", remoteConfigsSupported);
        }
        endpointDescriptionProperties.put("service.imported.configs", remoteConfigsSupported);
        String[] intents = PropertiesUtil.getPropertyValue(null, overridingProperties, "service.intents");
        if (intents == null) {
            intents = serviceIntents;
        }
        if (intents != null) {
            endpointDescriptionProperties.put("service.intents", intents);
        }
        if ((remoteIntentsSupported = this.getSupportedIntents(container.getID())) != null) {
            endpointDescriptionProperties.put("remote.intents.supported", remoteIntentsSupported);
        }
        String idNamespace = containerID.getNamespace().getName();
        endpointDescriptionProperties.put("ecf.endpoint.id.ns", idNamespace);
        endpointDescriptionProperties.put("ecf.endpoint.ts", System.currentTimeMillis());
        String connectTarget = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "ecf.endpoint.connecttarget.id");
        if (connectTarget == null && this.isClient(container) && (connectedID = container.getConnectedID()) != null && !connectedID.equals((Object)containerID)) {
            connectTarget = connectedID.getName();
        }
        if (connectTarget != null) {
            endpointDescriptionProperties.put("ecf.endpoint.connecttarget.id", connectTarget);
        }
        if ((idFilter = (String[])PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "ecf.endpoint.idfilter.ids")) != null && idFilter.length > 0) {
            endpointDescriptionProperties.put("ecf.endpoint.idfilter.ids", idFilter);
        }
        if ((rsFilter = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "ecf.endpoint.rsfilter")) != null) {
            endpointDescriptionProperties.put("ecf.endpoint.rsfilter", rsFilter);
        }
        return PropertiesUtil.copyNonReservedProperties(overridingProperties, endpointDescriptionProperties);
    }

    private Map<String, Object> copyNonReservedProperties(ServiceReference serviceReference, Map<String, Object> overridingProperties, Map<String, Object> target) {
        PropertiesUtil.copyNonReservedProperties(serviceReference, target);
        PropertiesUtil.copyNonReservedProperties(overridingProperties, target);
        return target;
    }

    private String[] getSupportedConfigs(ID containerID) {
        ContainerTypeDescription ctd = this.getContainerTypeDescription(containerID);
        return ctd == null ? null : ctd.getSupportedConfigs();
    }

    private String[] getImportedConfigs(ID containerID, String[] exporterSupportedConfigs) {
        ContainerTypeDescription ctd = this.getContainerTypeDescription(containerID);
        return ctd == null ? null : ctd.getImportedConfigs(exporterSupportedConfigs);
    }

    private String[] getSupportedIntents(ID containerID) {
        ContainerTypeDescription ctd = this.getContainerTypeDescription(containerID);
        return ctd == null ? null : ctd.getSupportedIntents();
    }

    private ID[] getIDFilter(EndpointDescription endpointDescription, ID endpointID) {
        ID[] iDArray;
        ID[] idFilter = endpointDescription.getIDFilter();
        if (idFilter == null) {
            ID[] iDArray2 = new ID[1];
            iDArray = iDArray2;
            iDArray2[0] = endpointID;
        } else {
            iDArray = idFilter;
        }
        return iDArray;
    }

    private String getRemoteServiceFilter(EndpointDescription endpointDescription) {
        long rsId = 0L;
        Long l = endpointDescription.getRemoteServiceId();
        if (l != null) {
            rsId = l;
        }
        if (rsId == 0L) {
            rsId = endpointDescription.getServiceId();
        }
        if (rsId == 0L) {
            return endpointDescription.getRemoteServiceFilter();
        }
        String edRsFilter = endpointDescription.getRemoteServiceFilter();
        StringBuffer result = new StringBuffer("(&(").append("ecf.rsvc.id").append("=").append(rsId).append(")");
        if (edRsFilter != null) {
            result.append(edRsFilter);
        }
        result.append(")");
        return result.toString();
    }

    private ImportEndpoint createAndRegisterProxy(final EndpointDescription endpointDescription, IRemoteServiceContainer rsContainer, final IRemoteServiceReference selectedRsReference) throws Exception {
        final BundleContext proxyServiceFactoryContext = this.getProxyServiceFactoryContext(endpointDescription);
        if (proxyServiceFactoryContext == null) {
            throw new NullPointerException("getProxyServiceFactoryContext returned null.  Cannot register proxy service factory");
        }
        final IRemoteServiceContainerAdapter containerAdapter = rsContainer.getContainerAdapter();
        ID rsContainerID = rsContainer.getContainer().getID();
        final IRemoteService rs = containerAdapter.getRemoteService(selectedRsReference);
        if (rs == null) {
            throw new NullPointerException("getRemoteService returned null for selectedRsReference=" + selectedRsReference + ",rsContainerID=" + rsContainerID);
        }
        final Map proxyProperties = this.createProxyProperties(rsContainerID, endpointDescription, selectedRsReference, rs);
        endpointDescription.setPropertiesOverrides(proxyProperties);
        List originalTypes = endpointDescription.getInterfaces();
        List<String> asyncServiceTypes = endpointDescription.getAsyncInterfaces();
        final ArrayList<String> serviceTypes = new ArrayList<String>(originalTypes);
        if (asyncServiceTypes != null) {
            for (String ast : asyncServiceTypes) {
                if (ast == null || serviceTypes.contains(ast)) continue;
                serviceTypes.add(ast);
            }
        }
        ServiceRegistration proxyRegistration = AccessController.doPrivileged(new PrivilegedAction<ServiceRegistration>(){

            @Override
            public ServiceRegistration run() {
                return proxyServiceFactoryContext.registerService(serviceTypes.toArray(new String[serviceTypes.size()]), (Object)RemoteServiceAdmin.this.createProxyServiceFactory(endpointDescription, containerAdapter, selectedRsReference, rs), PropertiesUtil.createDictionaryFromMap(proxyProperties));
            }
        });
        return new ImportEndpoint(rsContainerID, containerAdapter, selectedRsReference, rs, new RemoteServiceListener(), proxyRegistration, endpointDescription);
    }

    private BundleContext getProxyServiceFactoryContext(EndpointDescription endpointDescription) throws Exception {
        Activator a = Activator.getDefault();
        if (a == null) {
            throw new NullPointerException("ECF RemoteServiceAdmin Activator cannot be null.");
        }
        if (a.isOldEquinox()) {
            BundleContext rsaContext = Activator.getContext();
            if (rsaContext == null) {
                throw new NullPointerException("RSA BundleContext cannot be null");
            }
            List interfaces = endpointDescription.getInterfaces();
            Collection<Class> serviceInterfaceClasses = this.loadServiceInterfacesViaBundle(rsaContext.getBundle(), interfaces.toArray(new String[interfaces.size()]));
            if (serviceInterfaceClasses.size() == 0) {
                throw new NullPointerException("No interface classes loadable for endpointDescription=" + (Object)((Object)endpointDescription));
            }
            Class serviceInterfaceClass = serviceInterfaceClasses.iterator().next();
            Bundle bundle = FrameworkUtil.getBundle((Class)serviceInterfaceClass);
            if (bundle == null) {
                throw new BundleException("Bundle for service interface class=" + serviceInterfaceClass.getName() + " cannot be found");
            }
            int bundleState = bundle.getState();
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                throw new BundleException("Bundle=" + bundle.getSymbolicName() + " in wrong state (" + bundleState + ") for using BundleContext proxy service factory");
            }
            return bundleContext;
        }
        return a.getProxyServiceFactoryBundleContext();
    }

    private ServiceFactory createProxyServiceFactory(EndpointDescription endpointDescription, IRemoteServiceContainerAdapter containerAdapter, IRemoteServiceReference selectedRsReference, IRemoteService remoteService) {
        return new ProxyServiceFactory(endpointDescription.getInterfaceVersions(), containerAdapter, selectedRsReference, remoteService);
    }

    private Collection<Class> loadServiceInterfacesViaBundle(Bundle bundle, String[] interfaces) {
        ArrayList<Class> result = new ArrayList<Class>();
        int i = 0;
        while (i < interfaces.length) {
            try {
                result.add(bundle.loadClass(interfaces[i]));
            }
            catch (ClassNotFoundException e) {
                this.logError("loadInterfacesViaBundle", "interface=" + interfaces[i] + " cannot be loaded by clientBundle=" + bundle.getSymbolicName(), e);
            }
            catch (IllegalStateException e) {
                this.logError("loadInterfacesViaBundle", "interface=" + interfaces[i] + " cannot be loaded since clientBundle is in illegal state", e);
            }
            ++i;
        }
        return result;
    }

    private Object createProxy(Bundle requestingBundle, ServiceReference serviceReference, IRemoteService remoteService, Map<String, Version> interfaceVersions) {
        String bundleSymbolicName = requestingBundle.getSymbolicName();
        String[] serviceClassnames = (String[])serviceReference.getProperty("objectClass");
        Collection<Class> serviceInterfaceClasses = this.loadServiceInterfacesViaBundle(requestingBundle, serviceClassnames);
        if (serviceInterfaceClasses.size() < 1) {
            throw new RuntimeException("ProxyServiceFactory cannot load any serviceInterfaces=" + serviceInterfaceClasses + " for serviceReference=" + serviceReference + " via clientBundle=" + bundleSymbolicName);
        }
        if (!this.verifyServiceInterfaceVersionsForProxy(requestingBundle, serviceInterfaceClasses, interfaceVersions)) {
            return null;
        }
        ClassLoader cl = this.getProxyClassLoader(requestingBundle);
        try {
            return remoteService.getProxy(cl, serviceInterfaceClasses.toArray(new Class[serviceInterfaceClasses.size()]));
        }
        catch (ECFException e) {
            throw new ServiceException("ProxyServiceFactory cannot create proxy for clientBundle=" + bundleSymbolicName + " from serviceReference=" + serviceReference, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getProxyClassLoader(Bundle bundle) {
        ProxyClassLoader proxyClassLoaderForBundle = null;
        Map<Bundle, ProxyClassLoader> map = this.proxyClassLoaders;
        synchronized (map) {
            proxyClassLoaderForBundle = this.proxyClassLoaders.get(bundle);
            if (proxyClassLoaderForBundle == null) {
                proxyClassLoaderForBundle = new ProxyClassLoader(bundle);
                this.proxyClassLoaders.put(bundle, proxyClassLoaderForBundle);
            } else {
                proxyClassLoaderForBundle.addServiceUseCount();
            }
        }
        return proxyClassLoaderForBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetProxyClassLoader(Bundle bundle) {
        Map<Bundle, ProxyClassLoader> map = this.proxyClassLoaders;
        synchronized (map) {
            ProxyClassLoader proxyClassLoaderForBundle = this.proxyClassLoaders.get(bundle);
            if (proxyClassLoaderForBundle != null) {
                int useCount = proxyClassLoaderForBundle.getServiceUseCount();
                if (useCount == 0) {
                    this.proxyClassLoaders.remove(bundle);
                } else {
                    proxyClassLoaderForBundle.removeServiceUseCount();
                }
            }
        }
    }

    private String getPackageName(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return className.substring(0, lastDotIndex);
    }

    private boolean comparePackageVersions(String packageName, Version remoteVersion, Version localVersion) throws RuntimeException {
        int compareResult;
        LogUtility.trace("comparePackageVersions", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/packageversioncomparator", this.getClass(), "packageName=" + packageName + ",remoteVersion=" + remoteVersion + ",localVersion=" + localVersion);
        if (remoteVersion == null) {
            remoteVersion = Version.emptyVersion;
        }
        if (localVersion == null) {
            localVersion = Version.emptyVersion;
        }
        return (compareResult = localVersion.compareTo(remoteVersion)) != 0;
    }

    private boolean verifyServiceInterfaceVersionsForProxy(Bundle bundle, Collection<Class> classes, Map<String, Version> interfaceVersions) {
        boolean result = true;
        for (Class clazz : classes) {
            Version localVersion;
            Version remoteVersion;
            String className = clazz.getName();
            String packageName = this.getPackageName(className);
            if (!this.comparePackageVersions(packageName, remoteVersion = interfaceVersions.get(className), localVersion = this.getPackageVersionViaRequestingBundle(packageName, bundle, remoteVersion))) continue;
            this.logError("verifyServiceInterfaceVersionsForProxy", "Failed version check for proxy creation.  clientBundle=" + this.clientBundle + " interfaceType=" + className + " remoteVersion=" + remoteVersion + " localVersion=" + localVersion);
            result = false;
        }
        return result;
    }

    private Version getVersionForMatchingCapability(String packageName, BundleCapability capability) {
        Map attributes = capability.getAttributes();
        String p = (String)attributes.get("osgi.wiring.package");
        if (p != null && packageName.equals(p)) {
            return (Version)attributes.get("version");
        }
        return null;
    }

    private Version getPackageVersionForMatchingWire(String packageName, List<BundleWire> bundleWires, String namespace) {
        Version result = null;
        for (BundleWire wire : bundleWires) {
            if (namespace.equals("osgi.wiring.package")) {
                result = this.getVersionForMatchingCapability(packageName, wire.getCapability());
            } else if (namespace.equals("osgi.wiring.bundle")) {
                result = this.getVersionForPackage(wire.getProvider().getBundle(), packageName);
            }
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private Version getVersionForPackage(final Bundle providingBundle, String packageName) {
        Version result = null;
        BundleRevision providingBundleRevision = AccessController.doPrivileged(new PrivilegedAction<BundleRevision>(){

            @Override
            public BundleRevision run() {
                return (BundleRevision)providingBundle.adapt(BundleRevision.class);
            }
        });
        if (providingBundleRevision == null) {
            return null;
        }
        List providerCapabilities = providingBundleRevision.getDeclaredCapabilities("osgi.wiring.package");
        for (BundleCapability c : providerCapabilities) {
            result = this.getVersionForMatchingCapability(packageName, c);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private Version getPackageVersionViaRequestingBundle(String packageName, final Bundle requestingBundle, Version remoteVersion) {
        BundleWiring requestingBundleWiring;
        Version result = null;
        BundleRevision requestingBundleRevision = AccessController.doPrivileged(new PrivilegedAction<BundleRevision>(){

            @Override
            public BundleRevision run() {
                return (BundleRevision)requestingBundle.adapt(BundleRevision.class);
            }
        });
        if (requestingBundleRevision != null) {
            List requestingBundleCapabilities = requestingBundleRevision.getDeclaredCapabilities("osgi.wiring.package");
            for (BundleCapability requestingBundleCapability : requestingBundleCapabilities) {
                Version candidate = this.getVersionForMatchingCapability(packageName, requestingBundleCapability);
                if (candidate == null) continue;
                if (remoteVersion != null && candidate.equals((Object)remoteVersion)) {
                    return candidate;
                }
                result = candidate;
            }
        }
        if (result == null && (requestingBundleWiring = (BundleWiring)requestingBundle.adapt(BundleWiring.class)) != null && (result = this.getPackageVersionForMatchingWire(packageName, requestingBundleWiring.getRequiredWires("osgi.wiring.package"), "osgi.wiring.package")) == null) {
            result = this.getPackageVersionForMatchingWire(packageName, requestingBundleWiring.getRequiredWires("osgi.wiring.bundle"), "osgi.wiring.bundle");
        }
        return result;
    }

    private IRemoteServiceReference selectRemoteServiceReference(Collection<IRemoteServiceReference> rsRefs, ID targetID, ID[] idFilter, Collection<String> interfaces, String rsFilter, IRemoteServiceContainer rsContainer) {
        if (rsRefs.size() == 0) {
            return null;
        }
        if (rsRefs.size() > 1) {
            this.logWarning("selectRemoteServiceReference", "rsRefs=" + rsRefs + ",targetID=" + targetID + ",idFilter=" + idFilter + ",interfaces=" + interfaces + ",rsFilter=" + rsFilter + ",rsContainer=" + rsContainer.getContainer().getID() + " has " + rsRefs.size() + " values.  Selecting the first element");
        }
        return rsRefs.iterator().next();
    }

    private Map createProxyProperties(ID importContainerID, EndpointDescription endpointDescription, IRemoteServiceReference rsReference, IRemoteService remoteService) {
        String serviceImportedType;
        TreeMap<String, Object> resultProperties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        PropertiesUtil.copyNonReservedProperties(rsReference, resultProperties);
        PropertiesUtil.copyNonReservedProperties(endpointDescription.getProperties(), resultProperties);
        resultProperties.remove("ecf.robjectClass");
        resultProperties.remove("ecf.rsvc.id");
        Object intentsValue = PropertiesUtil.convertToStringPlusValue(endpointDescription.getIntents());
        if (intentsValue != null) {
            resultProperties.put("service.intents", intentsValue);
        }
        if ((serviceImportedType = (String)endpointDescription.getProperties().get("ecf.service.imported.valuetype")) == null || serviceImportedType.equals(IRemoteService.class.getName())) {
            resultProperties.put("service.imported", remoteService);
        } else {
            resultProperties.put("service.imported", new Boolean(true));
        }
        String[] exporterSupportedConfigs = (String[])endpointDescription.getProperties().get("remote.configs.supported");
        String[] importedConfigs = this.getImportedConfigs(importContainerID, exporterSupportedConfigs);
        resultProperties.put("service.imported.configs", importedConfigs);
        String endpointId = endpointDescription.getId();
        resultProperties.put("endpoint.id", endpointId);
        return resultProperties;
    }

    private ExportRegistration exportService(final ServiceReference serviceReference, Map<String, ?> overridingProperties, String[] exportedInterfaces, IRemoteServiceContainer rsContainer, Map<String, Object> endpointDescriptionProperties) throws Exception {
        IExtendedRemoteServiceRegistration iersr;
        Map extraProperties;
        Map<String, Object> remoteServiceProperties = this.copyNonReservedProperties(serviceReference, overridingProperties, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
        IRemoteServiceContainerAdapter containerAdapter = rsContainer.getContainerAdapter();
        IRemoteServiceRegistration remoteRegistration = null;
        if (containerAdapter instanceof IOSGiRemoteServiceContainerAdapter) {
            IOSGiRemoteServiceContainerAdapter osgiContainerAdapter = (IOSGiRemoteServiceContainerAdapter)containerAdapter;
            remoteRegistration = osgiContainerAdapter.registerRemoteService(exportedInterfaces, serviceReference, PropertiesUtil.createDictionaryFromMap(remoteServiceProperties));
        } else {
            Object service = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return RemoteServiceAdmin.this.getClientBundleContext().getService(serviceReference);
                }
            });
            remoteRegistration = containerAdapter.registerRemoteService(exportedInterfaces, service, PropertiesUtil.createDictionaryFromMap(remoteServiceProperties));
        }
        endpointDescriptionProperties.put((String)"ecf.rsvc.id", remoteRegistration.getID().getContainerRelativeID());
        if (remoteRegistration instanceof IExtendedRemoteServiceRegistration && (extraProperties = (iersr = (IExtendedRemoteServiceRegistration)remoteRegistration).getExtraProperties()) != null) {
            endpointDescriptionProperties = PropertiesUtil.mergeProperties(endpointDescriptionProperties, (Map<String, Object>)extraProperties);
        }
        return new ExportRegistration(new ExportEndpoint(serviceReference, new EndpointDescription(serviceReference, endpointDescriptionProperties), remoteRegistration, endpointDescriptionProperties));
    }

    private ImportRegistration importService(EndpointDescription endpointDescription, IRemoteServiceContainer rsContainer) {
        this.trace("doImportService", "endpointDescription=" + (Object)((Object)endpointDescription) + ",rsContainerID=" + rsContainer.getContainer().getID());
        List interfaces = endpointDescription.getInterfaces();
        Assert.isNotNull((Object)interfaces);
        Assert.isTrue((interfaces.size() > 0 ? 1 : 0) != 0);
        ID endpointContainerID = endpointDescription.getContainerID();
        Assert.isNotNull((Object)endpointContainerID);
        ID tID = endpointDescription.getConnectTargetID();
        if (tID == null) {
            tID = endpointContainerID;
        }
        final ID targetID = tID;
        final ID[] idFilter = this.getIDFilter(endpointDescription, endpointContainerID);
        final String rsFilter = this.getRemoteServiceFilter(endpointDescription);
        ArrayList<IRemoteServiceReference> rsRefs = new ArrayList<IRemoteServiceReference>();
        final IRemoteServiceContainerAdapter containerAdapter = rsContainer.getContainerAdapter();
        ID rsContainerID = rsContainer.getContainer().getID();
        try {
            final String intf = (String)interfaces.iterator().next();
            IRemoteServiceReference[] refs = AccessController.doPrivileged(new PrivilegedExceptionAction<IRemoteServiceReference[]>(){

                @Override
                public IRemoteServiceReference[] run() throws ContainerConnectException, InvalidSyntaxException {
                    return containerAdapter.getRemoteServiceReferences(targetID, idFilter, intf, rsFilter);
                }
            });
            if (refs == null) {
                this.logWarning("doImportService", "getRemoteServiceReferences return null for targetID=" + targetID + ",idFilter=" + idFilter + ",intf=" + intf + ",rsFilter=" + rsFilter + " on rsContainerID=" + rsContainerID);
            } else {
                int i = 0;
                while (i < refs.length) {
                    rsRefs.add(refs[i]);
                    ++i;
                }
            }
            IRemoteServiceReference selectedRsReference = this.selectRemoteServiceReference(rsRefs, targetID, idFilter, interfaces, rsFilter, rsContainer);
            if (selectedRsReference == null) {
                throw new RemoteReferenceNotFoundException(targetID, idFilter, interfaces, rsFilter);
            }
            return new ImportRegistration(this.createAndRegisterProxy(endpointDescription, rsContainer, selectedRsReference));
        }
        catch (PrivilegedActionException e) {
            this.logError("importService", "selectRemoteServiceReference returned null for rsRefs=" + rsRefs + ",targetID=" + targetID + ",idFilter=" + idFilter + ",interfaces=" + interfaces + ",rsFilter=" + rsFilter + ",rsContainerID=" + rsContainerID, e.getException());
            return new ImportRegistration(endpointDescription, e.getException());
        }
        catch (Exception e) {
            this.logError("importService", "selectRemoteServiceReference returned null for rsRefs=" + rsRefs + ",targetID=" + targetID + ",idFilter=" + idFilter + ",interfaces=" + interfaces + ",rsFilter=" + rsFilter + ",rsContainerID=" + rsContainerID, e);
            return new ImportRegistration(endpointDescription, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<ExportRegistration> arrayList;
        this.trace("close", "closing importedRegistrations=" + this.importedRegistrations + " exportedRegistrations=" + this.exportedRegistrations);
        ArrayList<ImportRegistration> toClose = null;
        Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            toClose = new ArrayList<ImportRegistration>(this.localImportedRegistrations);
        }
        for (org.osgi.service.remoteserviceadmin.ImportRegistration importRegistration : toClose) {
            importRegistration.close();
        }
        Object var2_5 = null;
        Collection<ExportRegistration> collection2 = this.localExportedRegistrations;
        synchronized (collection2) {
            arrayList = new ArrayList<ExportRegistration>(this.localExportedRegistrations);
        }
        for (org.osgi.service.remoteserviceadmin.ExportRegistration exportRegistration : arrayList) {
            exportRegistration.close();
        }
        this.localExportedRegistrations.clear();
        this.localImportedRegistrations.clear();
        Object object = this.remoteServiceAdminListenerTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminListenerTracker != null) {
                this.remoteServiceAdminListenerTracker.close();
                this.remoteServiceAdminListenerTracker = null;
            }
        }
        Object object2 = this.eventAdminTrackerLock;
        synchronized (object2) {
            if (this.eventAdminTracker != null) {
                this.eventAdminTracker.close();
                this.eventAdminTracker = null;
            }
        }
        Map<Bundle, ProxyClassLoader> map = this.proxyClassLoaders;
        synchronized (map) {
            this.proxyClassLoaders.clear();
        }
        Object object3 = this.consumerContainerSelectorTrackerLock;
        synchronized (object3) {
            if (this.consumerContainerSelectorTracker != null) {
                this.consumerContainerSelectorTracker.close();
                this.consumerContainerSelectorTracker = null;
            }
        }
        if (this.defaultConsumerContainerSelector != null) {
            this.defaultConsumerContainerSelector.close();
            this.defaultConsumerContainerSelector = null;
        }
        Object object4 = this.hostContainerSelectorTrackerLock;
        synchronized (object4) {
            if (this.hostContainerSelectorTracker != null) {
                this.hostContainerSelectorTracker.close();
                this.hostContainerSelectorTracker = null;
            }
        }
        if (this.defaultHostContainerSelector != null) {
            this.defaultHostContainerSelector.close();
            this.defaultHostContainerSelector = null;
        }
        if (this.defaultHostContainerSelectorRegistration != null) {
            this.defaultHostContainerSelectorRegistration.unregister();
            this.defaultHostContainerSelectorRegistration = null;
        }
        if (this.defaultHostContainerSelector != null) {
            this.defaultHostContainerSelector.close();
            this.defaultHostContainerSelector = null;
        }
        if (this.defaultConsumerContainerSelectorRegistration != null) {
            this.defaultConsumerContainerSelectorRegistration.unregister();
            this.defaultConsumerContainerSelectorRegistration = null;
        }
        if (this.defaultConsumerContainerSelector != null) {
            this.defaultConsumerContainerSelector.close();
            this.defaultConsumerContainerSelector = null;
        }
        if (this.eventListenerHookRegistration != null) {
            this.eventListenerHookRegistration.unregister();
            this.eventListenerHookRegistration = null;
        }
    }

    private ImportEndpoint findImportEndpoint(EndpointDescription ed) {
        for (org.osgi.service.remoteserviceadmin.ImportRegistration reg : this.importedRegistrations) {
            ImportEndpoint endpoint;
            if (!(reg instanceof ImportRegistration) || (endpoint = ((ImportRegistration)reg).getImportEndpoint(ed)) == null) continue;
            return endpoint;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unimportService(IRemoteServiceID remoteServiceID) {
        ArrayList<ImportRegistration> removedRegistrations = new ArrayList<ImportRegistration>();
        Collection<org.osgi.service.remoteserviceadmin.ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            for (org.osgi.service.remoteserviceadmin.ImportRegistration iReg : this.importedRegistrations) {
                ImportRegistration importRegistration;
                if (!(iReg instanceof ImportRegistration) || !(importRegistration = (ImportRegistration)iReg).match(remoteServiceID)) continue;
                removedRegistrations.add(importRegistration);
            }
        }
        for (ImportRegistration removedReg : removedRegistrations) {
            this.trace("unimportService", "closing importRegistration=" + removedReg);
            removedReg.close();
        }
    }

    private void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", this.getClass(), message);
    }

    private void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", this.getClass(), message);
    }

    private void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", this.getClass(), message, t);
    }

    private void logError(String methodName, String message) {
        this.logError(methodName, message, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExportEndpoint {
        private ServiceReference serviceReference;
        private EndpointDescription endpointDescription;
        private IRemoteServiceRegistration rsRegistration;
        private Set<ExportRegistration> activeExportRegistrations = new HashSet<ExportRegistration>();
        private Map<String, Object> originalProperties;

        ExportEndpoint(ServiceReference serviceReference, EndpointDescription endpointDescription, IRemoteServiceRegistration reg, Map<String, Object> originalProperties) {
            Assert.isNotNull((Object)serviceReference);
            this.serviceReference = serviceReference;
            Assert.isNotNull((Object)((Object)endpointDescription));
            this.endpointDescription = endpointDescription;
            Assert.isNotNull((Object)reg);
            this.rsRegistration = reg;
            Assert.isNotNull(originalProperties);
            this.originalProperties = originalProperties;
        }

        synchronized ID getContainerID() {
            return this.endpointDescription.getContainerID();
        }

        synchronized ServiceReference getServiceReference() {
            return this.serviceReference;
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.endpointDescription;
        }

        synchronized IRemoteServiceRegistration getRemoteServiceRegistration() {
            return this.rsRegistration;
        }

        synchronized boolean addExportRegistration(ExportRegistration exportRegistration) {
            return this.activeExportRegistrations.add(exportRegistration);
        }

        synchronized boolean close(ExportRegistration exportRegistration) {
            boolean removed = this.activeExportRegistrations.remove(exportRegistration);
            if (removed && this.activeExportRegistrations.size() == 0) {
                if (this.rsRegistration != null) {
                    this.rsRegistration.unregister();
                    this.rsRegistration = null;
                }
                this.serviceReference = null;
                this.endpointDescription = null;
                this.originalProperties = null;
            }
            return removed;
        }

        synchronized EndpointDescription update(Map properties) {
            Map<String, Object> serviceReferenceProperties = PropertiesUtil.copyProperties(this.serviceReference, new HashMap<String, Object>());
            Map<String, Object> rsProperties = PropertiesUtil.copyProperties(this.originalProperties, new HashMap<String, Object>());
            Map<String, Object> updateProperties = properties == null ? rsProperties : PropertiesUtil.copyProperties(properties, rsProperties);
            Map updatedEDProperties = PropertiesUtil.mergeProperties(updateProperties, serviceReferenceProperties);
            updatedEDProperties.put("ecf.endpoint.ts", System.currentTimeMillis());
            this.endpointDescription = new EndpointDescription(updatedEDProperties);
            return this.endpointDescription;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExportReference
    implements org.osgi.service.remoteserviceadmin.ExportReference {
        private ExportEndpoint exportEndpoint;
        private Throwable exception;
        private EndpointDescription errorEndpointDescription;

        ExportReference(ExportEndpoint exportEndpoint) {
            Assert.isNotNull((Object)exportEndpoint);
            this.exportEndpoint = exportEndpoint;
        }

        synchronized EndpointDescription update(Map<String, ?> properties) {
            if (this.exportEndpoint == null) {
                return null;
            }
            return this.exportEndpoint.update(properties);
        }

        ExportReference(Throwable exception, EndpointDescription errorEndpointDescription) {
            Assert.isNotNull((Object)exception);
            this.exception = exception;
            Assert.isNotNull((Object)exception);
            this.errorEndpointDescription = errorEndpointDescription;
        }

        synchronized Throwable getException() {
            return this.exception;
        }

        synchronized boolean close(ExportRegistration exportRegistration) {
            if (this.exportEndpoint == null) {
                return false;
            }
            boolean result = this.exportEndpoint.close(exportRegistration);
            this.exportEndpoint = null;
            return result;
        }

        synchronized ExportEndpoint getExportEndpoint() {
            return this.exportEndpoint;
        }

        synchronized IRemoteServiceRegistration getRemoteServiceRegistration() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getRemoteServiceRegistration();
        }

        public synchronized ID getContainerID() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getContainerID();
        }

        public synchronized long getRemoteServiceId() {
            IRemoteServiceRegistration r = this.getRemoteServiceRegistration();
            return r == null ? 0L : r.getID().getContainerRelativeID();
        }

        public synchronized ServiceReference getExportedService() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getServiceReference();
        }

        public synchronized org.osgi.service.remoteserviceadmin.EndpointDescription getExportedEndpoint() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getEndpointDescription();
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.exportEndpoint == null ? this.errorEndpointDescription : this.exportEndpoint.getEndpointDescription();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExportRegistration
    implements org.osgi.service.remoteserviceadmin.ExportRegistration {
        private ExportReference exportReference;
        private boolean closed = false;
        private Throwable updateException;

        ExportRegistration(ExportEndpoint exportEndpoint) {
            Assert.isNotNull((Object)exportEndpoint);
            exportEndpoint.addExportRegistration(this);
            this.exportReference = new ExportReference(exportEndpoint);
        }

        ExportRegistration(Throwable exception, EndpointDescription errorEndpointDescription) {
            Assert.isNotNull((Object)exception);
            this.exportReference = new ExportReference(exception, errorEndpointDescription);
        }

        public ID getContainerID() {
            return this.closed ? null : this.exportReference.getContainerID();
        }

        ServiceReference getServiceReference() {
            return this.closed ? null : this.exportReference.getExportedService();
        }

        public long getRemoteServiceId() {
            return this.closed ? 0L : this.exportReference.getRemoteServiceId();
        }

        public org.osgi.service.remoteserviceadmin.ExportReference getExportReference() {
            Throwable t = this.getException();
            if (t != null) {
                return null;
            }
            return this.closed ? null : this.exportReference;
        }

        boolean match(ServiceReference serviceReference) {
            return this.match(serviceReference, null);
        }

        boolean match(ServiceReference serviceReference, ID containerID) {
            ServiceReference ourServiceReference = this.getServiceReference();
            if (ourServiceReference == null) {
                return false;
            }
            boolean serviceReferenceCompare = ourServiceReference.equals(serviceReference);
            if (containerID == null) {
                return serviceReferenceCompare;
            }
            ID ourContainerID = this.getContainerID();
            if (ourContainerID == null) {
                return false;
            }
            return serviceReferenceCompare && ourContainerID.equals((Object)containerID);
        }

        synchronized ExportEndpoint getExportEndpoint(ServiceReference serviceReference, ID containerID) {
            return this.closed ? null : (this.match(serviceReference, containerID) ? this.exportReference.getExportEndpoint() : null);
        }

        IRemoteServiceRegistration getRemoteServiceRegistration() {
            return this.closed ? null : this.exportReference.getRemoteServiceRegistration();
        }

        EndpointDescription getEndpointDescription() {
            return this.closed ? null : this.exportReference.getEndpointDescription();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            boolean publish = false;
            ID containerID = null;
            Throwable exception = null;
            EndpointDescription endpointDescription = null;
            ExportReference exRef = null;
            ExportRegistration exportRegistration = this;
            synchronized (exportRegistration) {
                if (!this.closed) {
                    containerID = this.getContainerID();
                    exception = this.getException();
                    endpointDescription = this.getEndpointDescription();
                    exRef = this.exportReference;
                    publish = this.exportReference.close(this);
                    this.exportReference = null;
                    this.closed = true;
                }
            }
            RemoteServiceAdmin.this.removeExportRegistration(this);
            Bundle rsaBundle = RemoteServiceAdmin.this.getRSABundle();
            if (publish && rsaBundle != null && exRef != null) {
                RemoteServiceAdmin.this.publishEvent(new RemoteServiceAdminEvent(containerID, 3, rsaBundle, exRef, exception, endpointDescription), endpointDescription);
            }
        }

        public Throwable getException() {
            return this.closed ? this.updateException : this.exportReference.getException();
        }

        public org.osgi.service.remoteserviceadmin.EndpointDescription update(Map<String, ?> properties) {
            if (this.closed) {
                this.updateException = new IllegalStateException("Update failed since ExportRegistration already closed");
                return null;
            }
            EndpointDescription updatedED = null;
            try {
                updatedED = this.exportReference.update(properties);
            }
            catch (RuntimeException e) {
                this.updateException = e;
                return null;
            }
            if (updatedED == null) {
                this.updateException = new IllegalStateException("Update failed because ExportEndpoint was null");
                return null;
            }
            this.updateException = null;
            Bundle rsaBundle = RemoteServiceAdmin.this.getRSABundle();
            if (rsaBundle != null) {
                RemoteServiceAdmin.this.publishEvent(new RemoteServiceAdminEvent(this.getContainerID(), 10, rsaBundle, this.exportReference, null, updatedED), updatedED);
            }
            return updatedED;
        }
    }

    class ImportEndpoint {
        private ID importContainerID;
        private IRemoteService rs;
        private IRemoteServiceContainerAdapter rsContainerAdapter;
        private EndpointDescription endpointDescription;
        private IRemoteServiceListener rsListener;
        private IRemoteServiceReference rsReference;
        private ServiceRegistration proxyRegistration;
        private Set<ImportRegistration> activeImportRegistrations = new HashSet<ImportRegistration>();

        ImportEndpoint(ID importContainerID, IRemoteServiceContainerAdapter rsContainerAdapter, IRemoteServiceReference rsReference, IRemoteService rs, IRemoteServiceListener rsListener, ServiceRegistration proxyRegistration, EndpointDescription endpointDescription) {
            this.importContainerID = importContainerID;
            this.rsContainerAdapter = rsContainerAdapter;
            this.endpointDescription = endpointDescription;
            this.rsReference = rsReference;
            this.rs = rs;
            this.rsListener = rsListener;
            this.proxyRegistration = proxyRegistration;
            this.rsContainerAdapter.addRemoteServiceListener(this.rsListener);
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.endpointDescription;
        }

        synchronized ServiceRegistration getProxyRegistration() {
            return this.proxyRegistration;
        }

        synchronized ID getContainerID() {
            return this.rsReference == null ? null : this.rsReference.getContainerID();
        }

        synchronized boolean addImportRegistration(ImportRegistration importRegistration) {
            return this.activeImportRegistrations.add(importRegistration);
        }

        synchronized boolean close(ImportRegistration importRegistration) {
            boolean removed = this.activeImportRegistrations.remove(importRegistration);
            if (removed && this.activeImportRegistrations.size() == 0) {
                if (this.proxyRegistration != null) {
                    this.proxyRegistration.unregister();
                    this.proxyRegistration = null;
                }
                if (this.rsContainerAdapter != null) {
                    if (this.rsReference != null) {
                        this.rsContainerAdapter.ungetRemoteService(this.rsReference);
                        this.rsReference = null;
                    }
                    if (this.rsListener != null) {
                        this.rsContainerAdapter.removeRemoteServiceListener(this.rsListener);
                        this.rsListener = null;
                    }
                    this.rs = null;
                    this.rsContainerAdapter = null;
                }
                this.endpointDescription = null;
            }
            return removed;
        }

        synchronized boolean match(IRemoteServiceID remoteServiceID) {
            if (remoteServiceID == null || this.rsReference == null) {
                return false;
            }
            return this.rsReference.getID().equals((Object)remoteServiceID);
        }

        synchronized boolean match(EndpointDescription ed) {
            if (this.activeImportRegistrations.size() == 0) {
                return false;
            }
            return this.endpointDescription.isSameService(ed);
        }

        synchronized void update(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint) {
            if (this.proxyRegistration == null) {
                return;
            }
            EndpointDescription updatedEndpoint = endpoint instanceof EndpointDescription ? (EndpointDescription)endpoint : new EndpointDescription(endpoint.getProperties());
            Map newProxyProperties = RemoteServiceAdmin.this.createProxyProperties(this.importContainerID, updatedEndpoint, this.rsReference, this.rs);
            updatedEndpoint.setPropertiesOverrides(newProxyProperties);
            this.endpointDescription = updatedEndpoint;
            this.proxyRegistration.setProperties(PropertiesUtil.createDictionaryFromMap(newProxyProperties));
        }
    }

    public class ImportReference
    implements org.osgi.service.remoteserviceadmin.ImportReference {
        private ImportEndpoint importEndpoint;
        private Throwable exception;
        private EndpointDescription errorEndpointDescription;

        ImportReference(ImportEndpoint importEndpoint) {
            Assert.isNotNull((Object)importEndpoint);
            this.importEndpoint = importEndpoint;
        }

        synchronized void update(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint) {
            if (this.importEndpoint != null) {
                this.importEndpoint.update(endpoint);
            }
        }

        ImportReference(EndpointDescription endpointDescription, Throwable exception) {
            Assert.isNotNull((Object)exception);
            this.exception = exception;
            Assert.isNotNull((Object)((Object)endpointDescription));
            this.errorEndpointDescription = endpointDescription;
        }

        synchronized Throwable getException() {
            return this.exception;
        }

        synchronized boolean match(IRemoteServiceID remoteServiceID) {
            return this.importEndpoint == null ? false : this.importEndpoint.match(remoteServiceID);
        }

        synchronized ImportEndpoint match(EndpointDescription ed) {
            if (this.importEndpoint != null && this.importEndpoint.match(ed)) {
                return this.importEndpoint;
            }
            return null;
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.importEndpoint == null ? this.errorEndpointDescription : this.importEndpoint.getEndpointDescription();
        }

        public synchronized ID getContainerID() {
            return this.importEndpoint == null ? null : this.importEndpoint.getContainerID();
        }

        public synchronized long getRemoteServiceId() {
            EndpointDescription ed = this.getEndpointDescription();
            return ed == null ? 0L : ed.getRemoteServiceId();
        }

        public synchronized ServiceReference getImportedService() {
            return this.importEndpoint == null ? null : this.importEndpoint.getProxyRegistration().getReference();
        }

        public synchronized org.osgi.service.remoteserviceadmin.EndpointDescription getImportedEndpoint() {
            return this.importEndpoint == null ? null : this.importEndpoint.getEndpointDescription();
        }

        synchronized boolean close(ImportRegistration importRegistration) {
            if (this.importEndpoint == null) {
                return false;
            }
            boolean result = this.importEndpoint.close(importRegistration);
            this.importEndpoint = null;
            return result;
        }
    }

    public class ImportRegistration
    implements org.osgi.service.remoteserviceadmin.ImportRegistration {
        private ImportReference importReference;
        private boolean closed = false;
        private Throwable updateException;

        ImportRegistration(ImportEndpoint importEndpoint) {
            Assert.isNotNull((Object)importEndpoint);
            importEndpoint.addImportRegistration(this);
            this.importReference = new ImportReference(importEndpoint);
        }

        ImportRegistration(EndpointDescription errorEndpointDescription, Throwable exception) {
            this.importReference = new ImportReference(errorEndpointDescription, exception);
        }

        public ID getContainerID() {
            return this.closed ? null : this.importReference.getContainerID();
        }

        public long getRemoteServiceId() {
            return this.closed ? 0L : this.importReference.getRemoteServiceId();
        }

        EndpointDescription getEndpointDescription() {
            return this.closed ? null : this.importReference.getEndpointDescription();
        }

        boolean match(IRemoteServiceID remoteServiceID) {
            return this.closed ? null : Boolean.valueOf(this.importReference.match(remoteServiceID));
        }

        boolean match(EndpointDescription ed) {
            return this.getImportEndpoint(ed) != null;
        }

        ImportEndpoint getImportEndpoint(EndpointDescription ed) {
            return this.closed ? null : this.importReference.match(ed);
        }

        public org.osgi.service.remoteserviceadmin.ImportReference getImportReference() {
            Throwable t = this.getException();
            if (t != null) {
                return null;
            }
            return this.closed ? null : this.importReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            boolean publish = false;
            ID containerID = null;
            Throwable exception = null;
            EndpointDescription endpointDescription = null;
            ImportReference imRef = null;
            ImportRegistration importRegistration = this;
            synchronized (importRegistration) {
                if (!this.closed) {
                    containerID = this.getContainerID();
                    exception = this.getException();
                    endpointDescription = this.getEndpointDescription();
                    imRef = this.importReference;
                    publish = this.importReference.close(this);
                    this.importReference = null;
                    this.closed = true;
                }
            }
            RemoteServiceAdmin.this.removeImportRegistration(this);
            Bundle rsaBundle = RemoteServiceAdmin.this.getRSABundle();
            if (publish && rsaBundle != null && imRef != null) {
                RemoteServiceAdmin.this.publishEvent(new RemoteServiceAdminEvent(containerID, 4, rsaBundle, imRef, exception, endpointDescription), endpointDescription);
            }
        }

        public Throwable getException() {
            return this.closed ? this.updateException : this.importReference.getException();
        }

        public boolean update(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint) {
            if (this.closed) {
                this.updateException = new IllegalStateException("Update failed since ImportRegistration already closed");
                return false;
            }
            try {
                this.importReference.update(endpoint);
            }
            catch (Exception e) {
                this.updateException = e;
                return false;
            }
            Bundle rsaBundle = RemoteServiceAdmin.this.getRSABundle();
            EndpointDescription ed = this.getEndpointDescription();
            if (rsaBundle != null) {
                RemoteServiceAdmin.this.publishEvent(new RemoteServiceAdminEvent(this.getContainerID(), 9, rsaBundle, this.importReference, null, ed), ed);
            }
            return true;
        }
    }

    protected class ProxyClassLoader
    extends ClassLoader {
        private Bundle loadingBundle;
        private int serviceUseCount = 0;

        public ProxyClassLoader(Bundle loadingBundle) {
            this.loadingBundle = loadingBundle;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadingBundle.loadClass(name);
        }

        public int getServiceUseCount() {
            return this.serviceUseCount;
        }

        public void addServiceUseCount() {
            ++this.serviceUseCount;
        }

        public void removeServiceUseCount() {
            --this.serviceUseCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyServiceFactory
    implements ServiceFactory {
        private final IRemoteServiceContainerAdapter containerAdapter;
        private final IRemoteServiceReference rsReference;
        private IRemoteService remoteService;
        private Map<String, Version> interfaceVersions;
        private long remoteProxyCount = 0L;

        public ProxyServiceFactory(Map<String, Version> interfaceVersions, IRemoteServiceContainerAdapter containerAdapter, IRemoteServiceReference rsReference, IRemoteService remoteService) {
            this.containerAdapter = containerAdapter;
            this.rsReference = rsReference;
            this.interfaceVersions = interfaceVersions;
            this.remoteService = remoteService;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            Object proxy = RemoteServiceAdmin.this.createProxy(bundle, registration.getReference(), this.remoteService, this.interfaceVersions);
            ++this.remoteProxyCount;
            return proxy;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            if (this.remoteProxyCount == 1L) {
                this.containerAdapter.ungetRemoteService(this.rsReference);
            }
            --this.remoteProxyCount;
            RemoteServiceAdmin.this.ungetProxyClassLoader(bundle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RSAEventListenerHook
    implements EventListenerHook {
        RSAEventListenerHook() {
        }

        public void event(ServiceEvent event, Map<BundleContext, Collection<ListenerHook.ListenerInfo>> listeners) {
            switch (event.getType()) {
                case 4: {
                    RemoteServiceAdmin.this.handleServiceUnregistering(event.getServiceReference());
                    break;
                }
            }
        }
    }

    public class RemoteServiceAdminEvent
    extends org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent {
        private ID containerID;
        private EndpointDescription endpointDescription;

        public RemoteServiceAdminEvent(ID containerID, int type, Bundle source, org.osgi.service.remoteserviceadmin.ExportReference exportReference, Throwable exception, EndpointDescription endpointDescription) {
            super(type, source, exportReference, exception);
            this.containerID = containerID;
            this.endpointDescription = endpointDescription;
        }

        public RemoteServiceAdminEvent(ID containerID, int type, Bundle source, org.osgi.service.remoteserviceadmin.ImportReference importReference, Throwable exception, EndpointDescription endpointDescription) {
            super(type, source, importReference, exception);
            this.containerID = containerID;
            this.endpointDescription = endpointDescription;
        }

        public EndpointDescription getEndpointDescription() {
            return this.endpointDescription;
        }

        public ID getContainerID() {
            return this.containerID;
        }

        public String toString() {
            return "RemoteServiceAdminEvent[containerID=" + this.containerID + ", getType()=" + this.getType() + ", getSource()=" + this.getSource() + ", getException()=" + this.getException() + ", getImportReference()=" + this.getImportReference() + ", getExportReference()=" + this.getExportReference() + "]";
        }
    }

    class RemoteServiceListener
    implements IRemoteServiceListener {
        RemoteServiceListener() {
        }

        public void handleServiceEvent(IRemoteServiceEvent event) {
            if (event instanceof IRemoteServiceUnregisteredEvent) {
                RemoteServiceAdmin.this.unimportService(event.getReference().getID());
            }
        }
    }
}

