/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc001.tc4000;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc4000.TC4000ModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC4000Tests
extends AbstractTestCase {
    static final String TEST_CASE_ID = "TC4000";
    static final String REFERENCE_DATA_FILENAME = TC4000Tests.getWorkingFileName(TC4000Tests.getReferenceDataFileName("TC4000", false));
    static final String EXPORT_DATA_FILENAME = TC4000Tests.getWorkingFileName(TC4000Tests.getFirstExportFileName("TC4000", false));
    static ReqIF originalReqIF = null;
    static ReqIF loadedReqIF = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        originalReqIF = new TC4000ModelBuilder(10000).getReqIF();
        TC4000Tests.saveReqIFFile((EObject)originalReqIF, REFERENCE_DATA_FILENAME);
        loadedReqIF = TC4000Tests.loadReqIFFile(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testSchemaCompliance() throws Exception {
        this.validateAgainstSchema(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testReqIFNotNull() {
        Assert.assertNotNull((String)"The loaded ReqIF model shall not be Null", (Object)loadedReqIF);
    }

    @Test
    public void testNoProxies() throws IOException {
        EcoreUtil.resolveAll((EObject)loadedReqIF);
        Map map = EcoreUtil.ProxyCrossReferencer.find((EObject)loadedReqIF);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testResave() throws IOException {
        try {
            TC4000Tests.saveReqIFFile(EcoreUtil.copy((EObject)loadedReqIF), EXPORT_DATA_FILENAME);
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertFalse((String)("We shall be able to save without exception. However the following exception occurred: " + ioe.toString()), (boolean)true);
        }
    }

    @Test
    public void testNoXMLAnyType() {
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)loadedReqIF, (boolean)true);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Assert.assertFalse((boolean)(eObject instanceof AnyType));
        }
    }
}

