/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.propertiesview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertyControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProrPropertySheetPage
extends Page
implements IPropertySheetPage {
    protected EditingDomain editingDomain;
    protected TabFolder tabFolder;
    protected ProrPropertyControl allProperties;
    protected ProrPropertyControl standardProperties;
    protected IAction locateValueAction = new LocateValueAction();
    protected AdapterFactory adapterFactory;
    private List<AttributeValue> objectsToSelect = new ArrayList<AttributeValue>();
    private CommandStackListener commandStackListener;
    protected TabItem tabStandard;
    protected TabItem tabAll;

    public ProrPropertySheetPage(EditingDomain editingDomain, AdapterFactory adapterFactory) {
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.registerCommandStackListener();
    }

    protected void registerCommandStackListener() {
        if (this.editingDomain != null) {
            this.editingDomain.getCommandStack().addCommandStackListener(this.getCommandStackListener());
        }
    }

    protected void unRegisterCommandStackListener() {
        if (this.editingDomain != null) {
            this.editingDomain.getCommandStack().removeCommandStackListener(this.getCommandStackListener());
        }
    }

    protected CommandStackListener getCommandStackListener() {
        if (this.commandStackListener == null) {
            this.commandStackListener = new CommandStackListener(){

                public void commandStackChanged(final EventObject event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Object firstItem;
                            Collection affectedObjects;
                            Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                            if (mostRecentCommand != null && !(affectedObjects = mostRecentCommand.getAffectedObjects()).isEmpty() && ((firstItem = affectedObjects.toArray()[0]) instanceof Identifiable || firstItem instanceof AttributeValue)) {
                                ProrPropertySheetPage.this.update();
                            }
                        }
                    });
                }
            };
        }
        return this.commandStackListener;
    }

    public void createControl(Composite parent) {
        if (this.tabFolder == null) {
            this.tabFolder = new TabFolder(parent, 1024);
            this.standardProperties = new ProrPropertyControl((Composite)this.tabFolder, this.adapterFactory, false);
            this.tabStandard = new TabItem(this.tabFolder, 0);
            this.tabStandard.setText(Reqif10EditorPlugin.getPlugin().getString("_UI_Standard_Properties"));
            this.tabStandard.setControl((Control)this.standardProperties);
            this.allProperties = new ProrPropertyControl((Composite)this.tabFolder, this.adapterFactory, true);
            this.tabAll = new TabItem(this.tabFolder, 0);
            this.tabAll.setText(Reqif10EditorPlugin.getPlugin().getString("_UI_All_Properties"));
            this.tabAll.setControl((Control)this.allProperties);
        }
    }

    private void handleEntrySelection(ISelection selection) {
        this.objectsToSelect.clear();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                AttributeValue atrVal = (AttributeValue)structuredSelection.getFirstElement();
                this.objectsToSelect.add(atrVal);
            } else {
                Object[] atrVals;
                Object[] objectArray = atrVals = structuredSelection.toArray();
                int n = atrVals.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    this.objectsToSelect.add((AttributeValue)obj);
                    ++n2;
                }
            }
        }
        this.locateValueAction.setEnabled(!selection.isEmpty());
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public void setFocus() {
        if (!this.getControl().isDisposed()) {
            this.getControl().setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        EditingDomain newEditingDomain = null;
        if (part instanceof IEditingDomainProvider) {
            newEditingDomain = ((IEditingDomainProvider)part).getEditingDomain();
        } else if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            newEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)structuredSelection.getFirstElement());
        }
        this.updateEditingDomain(newEditingDomain);
        if (this.allProperties != null && !this.allProperties.isDisposed()) {
            this.allProperties.setSelection(selection);
        }
        if (this.standardProperties != null && !this.standardProperties.isDisposed()) {
            this.standardProperties.setSelection(selection);
        }
    }

    protected void updateEditingDomain(EditingDomain newEditingDomain) {
        if (this.editingDomain != newEditingDomain) {
            this.unRegisterCommandStackListener();
            this.editingDomain = newEditingDomain;
            this.registerCommandStackListener();
        }
    }

    private void update() {
        if (this.allProperties != null && !this.allProperties.isDisposed()) {
            this.allProperties.update();
            this.standardProperties.update();
        }
    }

    private void setSelectionToViewer(List<?> selection) {
        this.handleEntrySelection((ISelection)new StructuredSelection(selection));
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        toolBarManager.add(this.locateValueAction);
    }

    public void dispose() {
        if (this.commandStackListener != null) {
            if (this.editingDomain != null) {
                this.editingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener);
            }
            this.commandStackListener = null;
        }
        super.dispose();
    }

    protected class LocateValueAction
    extends Action {
        public LocateValueAction() {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action"));
            this.setToolTipText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action_tool_tip"));
            this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/elcl16/LocateValue")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/dlcl16/LocateValue")));
        }

        public void run() {
            ProrPropertySheetPage.this.setSelectionToViewer(ProrPropertySheetPage.this.objectsToSelect);
        }
    }
}

