/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSelector
extends Composite {
    private ArrayList<EnumValue> itemList = new ArrayList();
    private int status = 32;
    private Collection<EnumValue> originalSelection;

    public EnumSelector(List<EnumValue> items, Collection<EnumValue> selection, Composite parent, int style) {
        super(parent, style);
        this.originalSelection = selection;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        this.setLayout((Layout)layout);
        Table table = new Table((Composite)this, 32);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32 && e.item instanceof TableItem) {
                    TableItem item = (TableItem)e.item;
                    if (item.getChecked()) {
                        EnumSelector.this.itemList.add((EnumValue)item.getData());
                    } else {
                        EnumSelector.this.itemList.remove((EnumValue)item.getData());
                    }
                }
            }
        });
        for (EnumValue enumValue : items) {
            TableItem tableItem = new TableItem(table, 0);
            String enumId = enumValue.getLongName() == null ? enumValue.getIdentifier() : enumValue.getLongName();
            tableItem.setText(enumId);
            tableItem.setData((Object)enumValue);
            if (!selection.contains(enumValue)) continue;
            tableItem.setChecked(true);
            this.itemList.add(enumValue);
        }
        Composite buttonPanel = new Composite((Composite)this, 0);
        buttonPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonPanel.setLayout((Layout)new FillLayout(256));
        Button cancel = new Button(buttonPanel, 8);
        cancel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnumSelector.this.status = 256;
                Display.getCurrent().getActiveShell().close();
            }
        });
        Button ok = new Button(buttonPanel, 8);
        ok.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT"));
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnumSelector.this.status = 32;
                Display.getCurrent().getActiveShell().close();
            }
        });
    }

    public int showEnumSelector(Shell shell) {
        shell.pack();
        while (!shell.isDisposed()) {
            if (Display.getCurrent().readAndDispatch()) continue;
            Display.getCurrent().sleep();
        }
        return this.status;
    }

    public Collection<EnumValue> getItems() {
        return this.status == 32 ? this.itemList : this.originalSelection;
    }

    public static Shell createShell(Control parent) {
        final Shell shell = new Shell(parent.getShell(), 16400);
        shell.setBackground(parent.getBackground());
        shell.setLayout((Layout)new FillLayout());
        shell.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    shell.close();
                }
            }
        });
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                shell.close();
            }
        });
        Display display = parent.getDisplay();
        Rectangle clientRect = display.map(parent, null, new Rectangle(0, 0, 0, 0));
        shell.setBounds(clientRect.x, clientRect.y + parent.getBounds().height, 0, 0);
        shell.open();
        shell.layout();
        return shell;
    }
}

