/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.actions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationFactory;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationPackage;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrToolExtension;
import org.eclipse.rmf.reqif10.pror.configuration.UnifiedColumn;
import org.eclipse.rmf.reqif10.pror.editor.ISpecificationEditor;
import org.eclipse.rmf.reqif10.pror.editor.actions.SubtreeDialog;
import org.eclipse.rmf.reqif10.pror.editor.presentation.ReqifSpecificationEditorInput;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ColumnConfigurationActionDelegate
implements IEditorActionDelegate {
    private ISpecificationEditor editor;

    public void setActiveEditor(IAction action, IEditorPart editor) {
        this.editor = editor instanceof ISpecificationEditor ? (ISpecificationEditor)editor : null;
    }

    public void run(IAction action) {
        if (this.editor == null) {
            return;
        }
        ReqIF reqif = (ReqIF)((Resource)this.editor.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0);
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof ReqifSpecificationEditorInput) {
            ProrSpecViewConfiguration config2;
            Specification spec = ((ReqifSpecificationEditorInput)input).getSpec();
            ProrToolExtension toolConfig = ConfigurationUtil.createProrToolExtension((ReqIF)reqif, (EditingDomain)this.editor.getEditingDomain());
            EList configs = toolConfig.getSpecViewConfigurations();
            for (ProrSpecViewConfiguration config2 : configs) {
                if (!spec.equals(config2.getSpecification())) continue;
                this.launchColumnDialog(config2);
                return;
            }
            config2 = ConfigurationFactory.eINSTANCE.createProrSpecViewConfiguration();
            config2.setSpecification(spec);
            toolConfig.getSpecViewConfigurations().add((Object)config2);
            this.launchColumnDialog(config2);
        }
    }

    private void launchColumnDialog(ProrSpecViewConfiguration config) {
        SubtreeDialog dialog = new SubtreeDialog(this.editor, (EObject)config, "Configure columns for " + ConfigurationUtil.getSpecElementLabel((SpecElementWithAttributes)config.getSpecification(), (AdapterFactory)this.editor.getAdapterFactory()), "org.eclipse.rmf.reqif10.pror.editor.columnConfiguration");
        dialog.setActions(new IAction[]{this.buildAddColumnAction(config), this.buildUnifiedColumnAction(config)}, false);
        dialog.open();
    }

    private IAction buildUnifiedColumnAction(final ProrSpecViewConfiguration config) {
        Action toggleUnifiedColumnAction = new Action("Unified Column"){

            public void run() {
                if (!ColumnConfigurationActionDelegate.this.containsUnifiedColumn(config)) {
                    UnifiedColumn column = ConfigurationFactory.eINSTANCE.createUnifiedColumn();
                    column.setLabel("Main");
                    Command cmd = AddCommand.create((EditingDomain)ColumnConfigurationActionDelegate.this.editor.getEditingDomain(), (Object)config, (Object)ConfigurationPackage.Literals.PROR_SPEC_VIEW_CONFIGURATION__COLUMNS, (Object)column);
                    ColumnConfigurationActionDelegate.this.editor.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        };
        config.eAdapters().add((Object)new AdapterImpl((IAction)toggleUnifiedColumnAction, config){
            private final /* synthetic */ IAction val$toggleUnifiedColumnAction;
            private final /* synthetic */ ProrSpecViewConfiguration val$config;
            {
                this.val$toggleUnifiedColumnAction = iAction;
                this.val$config = prorSpecViewConfiguration;
            }

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                this.val$toggleUnifiedColumnAction.setEnabled(!ColumnConfigurationActionDelegate.this.containsUnifiedColumn(this.val$config));
            }
        });
        toggleUnifiedColumnAction.setEnabled(!this.containsUnifiedColumn(config));
        return toggleUnifiedColumnAction;
    }

    private boolean containsUnifiedColumn(ProrSpecViewConfiguration config) {
        for (Column column : config.getColumns()) {
            if (!(column instanceof UnifiedColumn)) continue;
            return true;
        }
        return false;
    }

    private IAction buildAddColumnAction(final ProrSpecViewConfiguration config) {
        Action addColumnAction = new Action("Add Column"){

            public void run() {
                final Column newColumn = ConfigurationFactory.eINSTANCE.createColumn();
                CompoundCommand compoundCmd = new CompoundCommand("Add Column"){

                    public Collection<?> getAffectedObjects() {
                        HashSet<Column> affectedObjects = new HashSet<Column>();
                        affectedObjects.add(newColumn);
                        return affectedObjects;
                    }
                };
                int shrink = 0;
                if (config.getColumns().size() > 0) {
                    shrink = 100 / config.getColumns().size();
                }
                for (Column column : config.getColumns()) {
                    int newWidth = column.getWidth() - shrink;
                    if (newWidth < 20) {
                        newWidth = 100;
                    }
                    Command command = SetCommand.create((EditingDomain)ColumnConfigurationActionDelegate.this.editor.getEditingDomain(), (Object)column, (Object)ConfigurationPackage.Literals.COLUMN__WIDTH, (Object)newWidth);
                    compoundCmd.append(command);
                }
                Command command = AddCommand.create((EditingDomain)ColumnConfigurationActionDelegate.this.editor.getEditingDomain(), (Object)config, (Object)ConfigurationPackage.Literals.PROR_SPEC_VIEW_CONFIGURATION__COLUMNS, (Object)newColumn);
                compoundCmd.append(command);
                ColumnConfigurationActionDelegate.this.editor.getEditingDomain().getCommandStack().execute((Command)compoundCmd);
            }
        };
        ImageDescriptor imgDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rmf.reqif10.pror.editor.editor", (String)"icons/full/obj16/AddColumn.png");
        addColumnAction.setImageDescriptor(imgDescriptor);
        return addColumnAction;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

