/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.editor.ISpecificationEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class AddTestObjectsActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;
    private IEditorPart editor;
    private IWorkbenchWindow window;

    public void run(IAction action) {
        if (this.selection.size() != 1) {
            return;
        }
        if (!(this.selection.getFirstElement() instanceof SpecHierarchy)) {
            return;
        }
        SpecHierarchy specHierarchy = (SpecHierarchy)this.selection.getFirstElement();
        if (specHierarchy.getObject() == null) {
            return;
        }
        SpecObjectType type = specHierarchy.getObject().getType();
        if (type == null) {
            return;
        }
        if (!(this.editor instanceof ISpecificationEditor)) {
            return;
        }
        ISpecificationEditor specificationEditor = (ISpecificationEditor)this.editor;
        Shell shell = this.window != null ? this.window.getShell() : this.editor.getSite().getShell();
        InputDialog dialog = new InputDialog(shell, "How many objects to create?", "DEBUGGING OBJECT CREATION: This function generates dummy elements, using the currently selected one as the template and origin. NOTE: If you want to add actual value, you need to configure a Plugin to do so (i.e. IdConfiguration)", "10", null);
        int status = dialog.open();
        if (status != 0) {
            return;
        }
        int count = Integer.parseInt(dialog.getValue());
        CompoundCommand cmd = new CompoundCommand("Inserting " + count + " Test objects");
        EditingDomain ed = specificationEditor.getEditingDomain();
        int i = 0;
        while (i < count) {
            SpecHierarchy newSpecHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
            SpecObject newSpecObject = ReqIF10Factory.eINSTANCE.createSpecObject();
            cmd.append(AddCommand.create((EditingDomain)ed, (Object)ReqIF10Util.getReqIF((Object)specHierarchy).getCoreContent(), (Object)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_OBJECTS, (Object)newSpecObject));
            cmd.append(SetCommand.create((EditingDomain)ed, (Object)newSpecHierarchy, (Object)ReqIF10Package.Literals.SPEC_HIERARCHY__OBJECT, (Object)newSpecObject));
            cmd.append(SetCommand.create((EditingDomain)ed, (Object)newSpecObject, (Object)ReqIF10Package.Literals.SPEC_OBJECT__TYPE, (Object)type));
            cmd.append(AddCommand.create((EditingDomain)ed, (Object)specHierarchy, (Object)ReqIF10Package.Literals.SPEC_HIERARCHY__CHILDREN, (Object)newSpecHierarchy));
            ++i;
        }
        ed.getCommandStack().execute((Command)cmd);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
    }
}

