/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.env.xerces;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XercesSchemaValidationTests {
    public static final String DATA_BASEDIR = "resources/input/org.eclipse.rmf.tests.serialization.env/data/";
    public static final String MODEL_BASEDIR = "resources/model/";

    @Test
    public void testSchemaValidationOnLoadWithValidFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple.xml";
        try {
            MyErrorHandler errorHandler = new MyErrorHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(errorHandler);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd ../../../model/myreqif.xsd");
            reader.parse(fileName);
            Assert.assertEquals((String)this.toString(errorHandler.errors), (long)0L, (long)errorHandler.errors.size());
            Assert.assertEquals((String)this.toString(errorHandler.warnings), (long)0L, (long)errorHandler.warnings.size());
            Assert.assertEquals((String)this.toString(errorHandler.fatalErrors), (long)0L, (long)errorHandler.fatalErrors.size());
        }
        catch (SAXException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (IOException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (ParserConfigurationException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testSchemaValidationOnLoadWithInvalidFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        try {
            MyErrorHandler errorHandler = new MyErrorHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(errorHandler);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd ../../../model/myreqif.xsd");
            reader.parse(fileName);
            Assert.assertEquals((String)this.toString(errorHandler.errors), (long)1L, (long)errorHandler.errors.size());
            Assert.assertEquals((String)this.toString(errorHandler.warnings), (long)0L, (long)errorHandler.warnings.size());
            Assert.assertEquals((String)this.toString(errorHandler.fatalErrors), (long)0L, (long)errorHandler.fatalErrors.size());
        }
        catch (SAXException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (IOException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (ParserConfigurationException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testSchemaValidationWithValidFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple.xml";
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("resources/model/myreqif.xsd")};
        StreamSource instanceDocument = new StreamSource(fileName);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema s = sf.newSchema(schemaDocuments);
            Validator v = s.newValidator();
            v.validate(instanceDocument);
        }
        catch (SAXException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (IOException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testSchemaValidationWithInvalidFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("resources/model/myreqif.xsd")};
        StreamSource instanceDocument = new StreamSource(fileName);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema s = sf.newSchema(schemaDocuments);
            Validator v = s.newValidator();
            v.validate(instanceDocument);
            Assert.assertTrue((boolean)false);
        }
        catch (SAXException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("cvc-complex-type.2.4.a:"));
        }
        catch (IOException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testSchemaValidationWithValidToolExtensionsFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple_toolExtensions.xml";
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("resources/model/myreqif.xsd")};
        StreamSource instanceDocument = new StreamSource(fileName);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema s = sf.newSchema(schemaDocuments);
            Validator v = s.newValidator();
            v.validate(instanceDocument);
        }
        catch (SAXException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (IOException iOException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testSchemaValidationWithValidRedefinedToolExtensionsFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple_toolExtensions_redefinedNsPrefix.xml";
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("resources/model/myreqif.xsd")};
        StreamSource instanceDocument = new StreamSource(fileName);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema s = sf.newSchema(schemaDocuments);
            Validator v = s.newValidator();
            v.validate(instanceDocument);
        }
        catch (SAXException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (IOException iOException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testSchemaValidationQualifiedForm() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple_qualifiedForm.xml";
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("resources/model/myreqif.xsd")};
        StreamSource instanceDocument = new StreamSource(fileName);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema s = sf.newSchema(schemaDocuments);
            Validator v = s.newValidator();
            v.validate(instanceDocument);
        }
        catch (SAXException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
        catch (IOException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testSchemaValidationUnqualifiedForm() throws SAXNotRecognizedException, SAXNotSupportedException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple_unqualifiedForm.xml";
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("resources/model/myreqif.xsd")};
        StreamSource instanceDocument = new StreamSource(fileName);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setFeature("http://apache.org/xml/features/validation/schema-full-checking", Boolean.TRUE);
        try {
            Schema s = sf.newSchema(schemaDocuments);
            Validator v = s.newValidator();
            v.validate(instanceDocument);
        }
        catch (SAXException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("cvc-complex-type.2.4.a:"));
        }
        catch (IOException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testSchemaValidationWithValidToolExtensionsXsiTypeFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple_toolExtensions_xsiType.xml";
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("resources/model/myreqif.xsd")};
        StreamSource instanceDocument = new StreamSource(fileName);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema s = sf.newSchema(schemaDocuments);
            Validator v = s.newValidator();
            v.validate(instanceDocument);
        }
        catch (SAXException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("cvc-elt.4.2:"));
        }
        catch (IOException iOException) {
            Assert.assertTrue((boolean)false);
        }
    }

    private String toString(List<SAXParseException> exceptions) {
        StringBuffer buffer = new StringBuffer();
        for (SAXParseException exception : exceptions) {
            buffer.append(exception.getMessage());
            buffer.append(" ### ");
        }
        return buffer.toString();
    }

    class MyErrorHandler
    implements ErrorHandler {
        public List<SAXParseException> errors = new Vector<SAXParseException>();
        public List<SAXParseException> warnings = new Vector<SAXParseException>();
        public List<SAXParseException> fatalErrors = new Vector<SAXParseException>();

        MyErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.warnings.add(exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.fatalErrors.add(exception);
        }
    }
}

