/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.filter;

import java.io.IOException;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XhtmlUtil;
import org.eclipse.rmf.reqif10.pror.filter.ReqifFilter;

public class SimpleStringFilter
implements ReqifFilter {
    private String text;

    public SimpleStringFilter(String text) {
        this.text = text.toLowerCase();
    }

    public boolean match(SpecElementWithAttributes specElement) {
        for (AttributeValue av : specElement.getValues()) {
            String textValue;
            Object value = ReqIF10Util.getTheValue((AttributeValue)av);
            if (value == null) continue;
            if (av instanceof AttributeValueEnumeration) {
                textValue = "";
                for (EnumValue enumValue : ((AttributeValueEnumeration)av).getValues()) {
                    textValue = String.valueOf(textValue) + enumValue.getLongName().toLowerCase() + " - ";
                }
            } else if (av instanceof AttributeValueXHTML) {
                try {
                    XhtmlContent xhtmlContent = ((AttributeValueXHTML)av).getTheValue();
                    textValue = ReqIF10XhtmlUtil.getXhtmlString((XhtmlContent)xhtmlContent).toLowerCase();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    textValue = "";
                }
            } else {
                textValue = value.toString().toLowerCase();
            }
            if (!textValue.contains(this.text)) continue;
            return true;
        }
        return false;
    }
}

