/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.provider.IdentifiableTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AttributeDefinitionTest
extends IdentifiableTest {
    private ReqIF reqif;
    private SpecType specType;

    protected AttributeDefinition getFixture() {
        return (AttributeDefinition)this.fixture;
    }

    @Before
    public void setupAttributeDefinitionTest() throws URISyntaxException {
        this.reqif = this.getTestReqif("simple.reqif");
        this.specType = (SpecType)this.reqif.getCoreContent().getSpecTypes().get(0);
    }

    @After
    public void tearDownAttributeDefinitionTest() {
        this.reqif = null;
        this.specType = null;
    }

    @Test
    public void testSpecTypeNotificationOnAdd() {
        ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.specType);
        ip.addListener(this.listener);
        this.specType.getSpecAttributes().add((Object)this.getFixture());
        Assert.assertEquals((long)1L, (long)this.notifications.size());
    }

    @Test
    public void testSpecTypeNotificationOnNameChange() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        SpecType type = (SpecType)reqif.getCoreContent().getSpecTypes().get(0);
        type.getSpecAttributes().add((Object)this.getFixture());
        this.getItemProvider(type).addListener(this.listener);
        this.setViaCommand(this.getFixture(), (EStructuralFeature)ReqIF10Package.Literals.IDENTIFIABLE__LONG_NAME, "New Name");
        Assert.assertEquals((Object)"New Name", (Object)this.getFixture().getLongName());
        Assert.assertEquals((long)1L, (long)this.notifications.size());
        Assert.assertTrue((boolean)(((Notification)this.notifications.get(0)).getNotifier() instanceof SpecType));
    }

    @Test
    public void testAttributeDefinitionChanges() {
        SpecObjectType specType = ReqIF10Factory.eINSTANCE.createSpecObjectType();
        specType.getSpecAttributes().add((Object)this.getFixture());
        ItemProviderAdapter ip = this.getItemProvider(specType);
        ip.addListener(this.listener);
        this.setViaCommand(this.getFixture(), (EStructuralFeature)ReqIF10Package.Literals.IDENTIFIABLE__LONG_NAME, "New Name");
        Assert.assertEquals((long)1L, (long)this.notifications.size());
    }

    protected EStructuralFeature getParentFeature() {
        return ReqIF10Package.eINSTANCE.getSpecType_SpecAttributes();
    }

    protected EObject getParent() {
        return ReqIF10Factory.eINSTANCE.createSpecObjectType();
    }
}

