/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.editors;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.reviews.core.ReviewsUtil;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.ui.ReviewCommentTaskAttachmentSource;
import org.eclipse.mylyn.reviews.ui.editors.DelegateReviewTaskEditorPart;
import org.eclipse.mylyn.reviews.ui.editors.ReviewTaskEditorPart;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewTaskEditorPage
extends BugzillaTaskEditorPage {
    private static final String PAGE_ID = "org.eclipse.mylyn.reviews.ui.editors.ReviewTaskEditorPage";
    private Review review;
    private boolean dirty;

    public ReviewTaskEditorPage(TaskEditor editor) {
        super(editor);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set originalTaskDescriptors = super.createPartDescriptors();
        HashSet<TaskEditorPartDescriptor> taskDescriptors = new HashSet<TaskEditorPartDescriptor>();
        List<String> blockedPaths = Arrays.asList("attributes", "comments", "attachments", "planning");
        for (TaskEditorPartDescriptor descriptor : originalTaskDescriptors) {
            if (blockedPaths.contains(descriptor.getPath())) continue;
            taskDescriptors.add(descriptor);
        }
        try {
            TaskData data = TasksUi.getTaskDataManager().getTaskData(this.getTask());
            if (data != null) {
                taskDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.reviews.ui.editors.DelegateReviewTaskEditorPart"){

                    public AbstractTaskEditorPart createPart() {
                        return new DelegateReviewTaskEditorPart();
                    }
                });
                taskDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.reviews.ui.editors.ReviewTaskEditorPart"){

                    public AbstractTaskEditorPart createPart() {
                        return new ReviewTaskEditorPart();
                    }
                });
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return taskDescriptors;
    }

    public void doSubmit() {
        super.doSubmit();
        if (this.dirty) {
            TaskRepository taskRepository = this.getModel().getTaskRepository();
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)taskRepository.getConnectorKind());
            TaskDataModel model = this.getModel();
            Review review = this.getReview();
            TaskAttribute attachmentAttribute = model.getTaskData().getAttributeMapper().createTaskAttachment(model.getTaskData());
            byte[] attachmentBytes = this.createAttachment(model, review);
            ReviewCommentTaskAttachmentSource attachment = new ReviewCommentTaskAttachmentSource(attachmentBytes);
            if (connector != null) {
                TasksUiInternal.getJobFactory().createSubmitTaskAttachmentJob(connector, model.getTaskRepository(), model.getTask(), (AbstractTaskAttachmentSource)attachment, "review result", attachmentAttribute).schedule();
            }
            this.dirty = false;
        }
    }

    private byte[] createAttachment(TaskDataModel model, Review review) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createFileURI((String)""));
            resource.getContents().add((Object)review);
            resource.getContents().add((Object)((EObject)review.getScope().get(0)));
            if (review.getResult() != null) {
                resource.getContents().add((Object)review.getResult());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream outputStream = new ZipOutputStream(byteArrayOutputStream);
            outputStream.putNextEntry(new ZipEntry("reviews-data.xml"));
            resource.save((OutputStream)outputStream, null);
            outputStream.closeEntry();
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        super.fillToolBar(toolBarManager);
    }

    public Review getReview() {
        if (this.review == null) {
            try {
                TaskDataModel model = this.getModel();
                List reviews = ReviewsUtil.getReviewAttachmentFromTask((ITaskDataManager)TasksUi.getTaskDataManager(), (IRepositoryModel)TasksUi.getRepositoryModel(), (ITask)model.getTask());
                if (reviews.size() > 0) {
                    this.review = (Review)reviews.get(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.review;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }
}

