/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui;

import java.io.CharArrayReader;
import java.io.Reader;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.patch.IFilePatch2;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.patch.ReaderCreator;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.reviews.core.ITargetPathStrategy;
import org.eclipse.mylyn.reviews.core.ReviewsUtil;
import org.eclipse.mylyn.reviews.ui.CompareItem;

public class ReviewDiffModel {
    private IFilePatch2 patch;
    private PatchConfiguration configuration;
    private ICompareInput compareInput;
    private IFilePatchResult compareEditorInput = null;

    public ReviewDiffModel(IFilePatch2 currentPatch, PatchConfiguration configuration) {
        this.patch = currentPatch;
        this.configuration = configuration;
    }

    public String toString() {
        return this.getFileName();
    }

    public String getFileName() {
        String string = this.patch.getTargetPath(this.configuration).lastSegment();
        return string;
    }

    public ICompareInput getCompareInput() {
        if (this.compareInput == null) {
            IFilePatchResult patchResult = this.getCompareEditorInput();
            DiffNode ci = new DiffNode(3, null, (ITypedElement)new CompareItem(patchResult, CompareItem.Kind.ORIGINAL, this.toString()), (ITypedElement)new CompareItem(patchResult, CompareItem.Kind.PATCHED, this.toString()));
            this.compareInput = ci;
        }
        return this.compareInput;
    }

    public IFilePatchResult getCompareEditorInput() {
        if (this.compareEditorInput == null) {
            IPath targetPath = this.patch.getTargetPath(this.configuration);
            for (ITargetPathStrategy strategy : ReviewsUtil.getPathFindingStrategies()) {
                IFilePatchResult result;
                if (!strategy.matches(targetPath)) continue;
                CompareConfiguration config = new CompareConfiguration();
                config.setRightEditable(false);
                config.setLeftEditable(false);
                ReaderCreator rc = strategy.get(targetPath);
                NullProgressMonitor monitor = new NullProgressMonitor();
                this.compareEditorInput = result = this.patch.apply(rc, this.configuration, (IProgressMonitor)monitor);
                return this.compareEditorInput;
            }
            if (this.patchAddsFile()) {
                ReaderCreator rc = new ReaderCreator(){

                    public Reader createReader() throws CoreException {
                        return new CharArrayReader(new char[0]);
                    }
                };
                NullProgressMonitor monitor = new NullProgressMonitor();
                this.compareEditorInput = this.patch.apply(rc, this.configuration, (IProgressMonitor)monitor);
            }
        }
        return this.compareEditorInput;
    }

    private boolean patchAddsFile() {
        IHunk[] iHunkArray = this.patch.getHunks();
        int n = iHunkArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHunk hunk = iHunkArray[n2];
            String[] stringArray = hunk.getUnifiedLines();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String line = stringArray[n4];
                if (!line.startsWith("+")) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public boolean sourceFileExists() {
        IPath targetPath = this.patch.getTargetPath(this.configuration);
        for (ITargetPathStrategy strategy : ReviewsUtil.getPathFindingStrategies()) {
            if (!strategy.matches(targetPath)) continue;
            return true;
        }
        return false;
    }

    public boolean canReview() {
        return this.sourceFileExists() || this.patchAddsFile();
    }

    public boolean isNewFile() {
        return this.patchAddsFile();
    }
}

