/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.commands.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.reqcycle.commands.Activator;
import org.polarsys.reqcycle.commands.utils.RelationCreationDescriptor;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class RelationCommandUtils {
    @Inject
    static ITypesConfigurationProvider typeConfigProvider = (ITypesConfigurationProvider)ZigguratInject.make(ITypesConfigurationProvider.class);
    @Inject
    static ITypesManager typeManager = (ITypesManager)ZigguratInject.make(ITypesManager.class);

    public static Set<RelationCreationDescriptor> getAllRelationCommands(List<Reachable> sourceReachables, List<Reachable> targetReachables) {
        Set<Object> set = Sets.newHashSet();
        Configuration defaultConfiguration = typeConfigProvider.getContainer().getDefaultConfiguration();
        if (defaultConfiguration != null) {
            for (Reachable sourceReachable : sourceReachables) {
                for (Reachable targetReachable : targetReachables) {
                    Set<RelationCreationDescriptor> matches = RelationCommandUtils.getMatches(sourceReachable, targetReachable, defaultConfiguration);
                    set = set.isEmpty() ? matches : Sets.intersection((Set)set, matches);
                }
            }
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.reqcycle.commands", "No default Reqcycle configuration was found"));
        }
        return set;
    }

    protected static Set<RelationCreationDescriptor> getMatches(Reachable sourceReachable, Reachable targetReachable, Configuration configuration) {
        HashSet result = Sets.newHashSet();
        for (Relation relation : configuration.getRelations()) {
            result.addAll(Sets.newHashSet(RelationCommandUtils.match(relation, sourceReachable, targetReachable)));
        }
        return result;
    }

    protected static Iterable<RelationCreationDescriptor> match(Relation r, Reachable sourceReachable, Reachable targetReachable) {
        if (r.getUpstreamType() == null || r.getDownstreamType() == null) {
            return Sets.newHashSet();
        }
        boolean match = false;
        int type = 0;
        if (r.getUpstreamType().getIType().is(sourceReachable) && r.getDownstreamType().getIType().is(targetReachable)) {
            match = true;
            type = 1;
        }
        if (r.getUpstreamType().getIType().is(targetReachable) && r.getDownstreamType().getIType().is(sourceReachable)) {
            type = type == 1 ? 0 : -1;
            match = true;
        }
        if (match) {
            ArrayList<RelationCreationDescriptor> descs = new ArrayList<RelationCreationDescriptor>(2);
            if (type == 0 || type == -1) {
                descs.add(new RelationCreationDescriptor(-1, r));
            }
            if (type == 0 || type == 1) {
                descs.add(new RelationCreationDescriptor(1, r));
            }
            return descs;
        }
        return Sets.newHashSet();
    }
}

