/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.components;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.reqcycle.predicates.core.api.IEAttrPredicate;
import org.polarsys.reqcycle.predicates.core.api.ITypedPredicate;
import org.polarsys.reqcycle.predicates.core.util.PredicatesUtil;
import org.polarsys.reqcycle.ui.eattrpropseditor.EAttrPropsEditorPlugin;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;

public class PredicatePropsEditor
extends Composite {
    private final Map<EAttribute, GenericEAttrPropsEditor> editors;

    public PredicatePropsEditor(ITypedPredicate<?> predicate, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.editors = new LinkedHashMap<EAttribute, GenericEAttrPropsEditor>();
        if (!(predicate instanceof IEAttrPredicate)) {
            return;
        }
        Collection inputAttrs = PredicatesUtil.getEAllAttributesAnnotatedBy((EClass)predicate.eClass(), (String)"www.eclipse.org/reqcycle/predicates/userInput");
        for (EAttribute attr : inputAttrs) {
            String javaClassType = EAttrPropsEditorPlugin.getEditorType((EClassifier)attr.getEType());
            this.addEditor(attr, javaClassType);
        }
    }

    public Map<EAttribute, GenericEAttrPropsEditor> getEditors() {
        return this.editors;
    }

    public void addEditor(EAttribute attribute) {
        this.addEditor(attribute, null);
    }

    public void addEditor(EAttribute attribute, String javaClassTypeName) {
        GenericEAttrPropsEditor attributeEditor = new GenericEAttrPropsEditor((Composite)this, 0);
        attributeEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ArrayList possibleValues = Collections.emptyList();
        if (attribute.getEType() instanceof EEnum) {
            possibleValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)((EEnum)attribute.getEType()).getELiterals(), (Function)new Function<EEnumLiteral, Object>(){

                public Object apply(EEnumLiteral arg0) {
                    return arg0;
                }
            }));
        }
        attributeEditor.init(attribute.getName(), attribute.getEType().getInstanceClass(), possibleValues);
        this.editors.put(attribute, attributeEditor);
        this.layout();
    }

    public void removeEditor(EAttribute attribute) {
        if (attribute != null) {
            GenericEAttrPropsEditor editor = this.editors.get(attribute);
            if (editor != null) {
                editor.dispose();
            }
            this.editors.remove(attribute);
            this.layout();
        }
    }
}

