/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.rmf.transform;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.polarsys.reqcycle.export.rmf.transform.IRequirementProvider;
import org.polarsys.reqcycle.repository.connector.ui.PropertyUtils;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.types.IDataModel;

public class RequirementSourceReqProvider
implements IRequirementProvider {
    private RequirementSource source;

    public RequirementSourceReqProvider(RequirementSource source) {
        this.source = source;
    }

    @Override
    public EList<AbstractElement> getRequirements() {
        if (this.source.getContents() instanceof RequirementsContainer) {
            return this.source.getContents().getRequirements();
        }
        return null;
    }

    @Override
    public ArrayList<Section> getSections() {
        return Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.source.getContents().eAllContents(), Section.class));
    }

    @Override
    public String getLabel() {
        return this.source.getName();
    }

    @Override
    public Map<String, String> getMetadata() {
        HashMap map = Maps.newHashMap();
        map.put("DataSource URI", this.source.getDataModelURI());
        return map;
    }

    @Override
    public IDataModel getDataModel() {
        return PropertyUtils.getDataModelFromSource((RequirementSource)this.source);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RequirementSourceReqProvider) {
            RequirementSourceReqProvider scope = (RequirementSourceReqProvider)obj;
            return scope.source.equals(this.source);
        }
        return super.equals(obj);
    }

    public RequirementSource getSource() {
        return this.source;
    }

    public int hashCode() {
        return this.source.hashCode();
    }
}

