/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.components.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.polarsys.reqcycle.ui.components.dialogs.AbstractCustomDialog;

public class CheckBoxInputDialog
extends AbstractCustomDialog {
    private IContentProvider contentProvider;
    private ITableLabelProvider labelProvider;
    private CheckboxTableViewer checkboxTableViewer;
    private final List<Object> selectedItems = new ArrayList<Object>();
    private Collection<Object> initialSelection;

    public CheckBoxInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, Object initialInput, IInputValidator validator, Collection<Object> initialSelection) {
        super(parentShell, dialogTitle, dialogMessage, initialInput, validator);
        this.initialSelection = initialSelection;
    }

    @Override
    protected void createCustomDialogArea(Composite parent) {
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67586);
        Table tableOfCustomPredicates = this.checkboxTableViewer.getTable();
        tableOfCustomPredicates.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        tableOfCustomPredicates.setLayout((Layout)tableLayout);
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        column.getColumn().setResizable(true);
        if (this.contentProvider == null) {
            this.contentProvider = ArrayContentProvider.getInstance();
        }
        if (this.labelProvider == null) {
            this.labelProvider = this.getDefaultLabelProvider();
        }
        this.checkboxTableViewer.setContentProvider(this.contentProvider);
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.checkboxTableViewer.setInput(this.getInput());
        if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            this.checkboxTableViewer.setCheckedElements(this.initialSelection.toArray());
        }
    }

    private ITableLabelProvider getDefaultLabelProvider() {
        return new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                return element.toString();
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        };
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.selectedItems.addAll(Arrays.asList(this.checkboxTableViewer.getCheckedElements()));
        } else {
            this.selectedItems.removeAll(this.selectedItems);
        }
        super.buttonPressed(buttonId);
    }

    @Override
    public Collection<Object> getSelectedItems() {
        return this.selectedItems;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(ITableLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

