/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.local.ui;

import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class LocalSettingPage
extends WizardPage
implements Listener {
    private DataBindingContext m_bindingContext;
    private ComboViewer cvDataModel;
    private Combo cDataModel;
    private ComboViewer cvScope;
    private Combo cScope;
    private Label lblCopyFile;
    private Text txtFile;
    private Button btnBrowseDestinationFile;
    public Bean bean = new Bean(this);
    @Inject
    IDataModelManager dataModelManager;

    public LocalSettingPage(String pageName) {
        super(pageName);
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    public void createControl(Composite parent) {
        Composite compositeMain = new Composite(parent, 0);
        compositeMain.setLayout((Layout)new GridLayout(3, false));
        compositeMain.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)compositeMain);
        Label lblDataModel = new Label(compositeMain, 0);
        lblDataModel.setText("Data Model :");
        this.cvDataModel = new ComboViewer(compositeMain);
        this.cDataModel = this.cvDataModel.getCombo();
        this.cDataModel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cvDataModel.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvDataModel.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDataModel) {
                    return ((IDataModel)element).getName();
                }
                return super.getText(element);
            }
        });
        this.cvDataModel.setInput((Object)this.dataModelManager.getCurrentDataModels());
        Label lblScope = new Label(compositeMain, 0);
        lblScope.setText("Scope :");
        this.cvScope = new ComboViewer(compositeMain);
        this.cScope = this.cvScope.getCombo();
        this.cScope.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cScope.setEnabled(false);
        this.cvScope.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvScope.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Scope) {
                    return ((Scope)element).getName();
                }
                return super.getText(element);
            }
        });
        this.lblCopyFile = new Label(compositeMain, 0);
        this.lblCopyFile.setText("Repository Folder :");
        this.txtFile = new Text(compositeMain, 2048);
        this.txtFile.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtFile.setEnabled(false);
        this.btnBrowseDestinationFile = new Button(compositeMain, 0);
        this.btnBrowseDestinationFile.setText("Browse");
        this.hookListeners();
        this.m_bindingContext = this.initDataBindings();
    }

    protected void hookListeners() {
        this.cvDataModel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                LocalSettingPage.this.cvScope.setInput(Collections.emptyList());
                LocalSettingPage.this.cScope.setEnabled(false);
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IDataModel) {
                    LocalSettingPage.this.cScope.setEnabled(true);
                    LocalSettingPage.this.cvScope.setInput((Object)LocalSettingPage.this.dataModelManager.getScopes((IDataModel)obj));
                }
                LocalSettingPage.this.cvScope.refresh();
            }
        });
        this.btnBrowseDestinationFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(LocalSettingPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "select location for save");
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof IPath) {
                    IPath path = (IPath)result[0];
                    LocalSettingPage.this.txtFile.setText(URI.createPlatformResourceURI((String)path.append(LocalSettingPage.this.bean.getFileName()).addFileExtension("reqcycle").toString(), (boolean)true).toString());
                }
            }
        });
    }

    public Bean getBean() {
        return this.bean;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionCvDataModel = ViewerProperties.singleSelection().observe((Viewer)this.cvDataModel);
        IObservableValue dataModelBeanObserveValue = PojoProperties.value((String)"dataModel").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeSingleSelectionCvDataModel, dataModelBeanObserveValue, null, null);
        IViewerObservableValue observeSingleSelectionCvScope = ViewerProperties.singleSelection().observe((Viewer)this.cvScope);
        IObservableValue scopeBeanObserveValue = PojoProperties.value((String)"scope").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeSingleSelectionCvScope, scopeBeanObserveValue, null, null);
        ISWTObservableValue observeTextTxtFileObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtFile);
        IObservableValue modelPathBeanObserveValue = PojoProperties.value((String)"destination").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeTextTxtFileObserveWidget, modelPathBeanObserveValue, null, null);
        return bindingContext;
    }

    public boolean isPageComplete() {
        StringBuffer error = new StringBuffer();
        boolean result = true;
        if (this.bean.getDataModel() == null) {
            error.append("Choose a Data Model\n");
            result = false;
        }
        if (this.bean.getScope() == null) {
            error.append("Choose a Scope\n");
            result = false;
        }
        if (this.bean.getDestination() == null || this.bean.getDestination().isEmpty()) {
            error.append("Choose a destination repository");
            result = false;
        }
        if (!result) {
            this.setErrorMessage(error.toString());
        } else {
            this.setErrorMessage(null);
        }
        return result;
    }

    public void handleEvent(Event event) {
        this.getContainer().updateButtons();
    }

    public void setFileName(String fileName) {
        this.bean.setFileName(fileName);
    }

    public static class Bean {
        private IDataModel dataModel;
        private Scope scope;
        private String destination;
        private Listener listener;
        private String fileName;

        public Bean(Listener listener) {
            this.listener = listener;
        }

        public IDataModel getDataModel() {
            return this.dataModel;
        }

        public void setDataModel(IDataModel dataModel) {
            this.dataModel = dataModel;
            this.listener.handleEvent(new Event());
        }

        public Scope getScope() {
            return this.scope;
        }

        public void setScope(Scope scope) {
            this.scope = scope;
            this.listener.handleEvent(new Event());
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
            this.listener.handleEvent(new Event());
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }
}

