/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.emf;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.polarsys.reqcycle.traceability.emf.Activator;
import org.polarsys.reqcycle.traceability.emf.Messages;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.EReachable;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.ReqCycleTraceabilityFactory;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.types.scopes.ConfigurationScope;
import org.polarsys.reqcycle.uri.model.Reachable;

public class ETraceabilityResource
extends ResourceImpl {
    private Set<EObject> contents = Sets.newHashSet();
    protected boolean flag = false;
    protected Request request = new Request();
    @Inject
    ITraceabilityEngine engine;
    private HashMap<String, EReachable> map = new HashMap();

    public EObject getEObject(String uri) {
        if (!this.map.containsKey(uri)) {
            return this.createEReachable(uri);
        }
        return this.map.get(uri);
    }

    private EObject createEReachable(String uri) {
        EReachable reach = ReqCycleTraceabilityFactory.eINSTANCE.createEReachable();
        reach.setURI(uri);
        if (reach instanceof InternalEObject) {
            InternalEObject internal = (InternalEObject)reach;
            internal.eSetResource((Resource.Internal)this, null);
        }
        this.contents.add(reach);
        this.map.put(uri, reach);
        return reach;
    }

    public void load(Map<?, ?> options) throws IOException {
    }

    public EList<EObject> getContents() {
        if (!this.flag) {
            CompositeScope scope = new CompositeScope();
            scope.add(Scopes.getWorkspaceScope());
            scope.add((IScope)new ConfigurationScope());
            this.request.setScope((IScope)scope);
            this.request.setDepth(Request.DEPTH.INFINITE);
            this.request.setDirection(ITraceabilityEngine.DIRECTION.UPWARD);
            try {
                this.loadAllTraceability(ITraceabilityEngine.DIRECTION.DOWNWARD);
                this.loadAllTraceability(ITraceabilityEngine.DIRECTION.UPWARD);
            }
            catch (EngineException e) {
                Activator.log(0, Messages.ETraceabilityResource_0, e);
            }
            this.flag = true;
        }
        return new BasicEList(this.contents);
    }

    private void loadAllTraceability(ITraceabilityEngine.DIRECTION direction) throws EngineException {
        this.request.setDirection(direction);
        Iterator traceability = this.engine.getTraceability(new Request[]{this.request});
        Iterator reachables = Iterators.transform((Iterator)traceability, (Function)new Function<Pair<Link, Reachable>, Reachable>(){

            public Reachable apply(Pair<Link, Reachable> arg0) {
                Reachable second = (Reachable)arg0.getSecond();
                return second;
            }
        });
        while (reachables.hasNext()) {
            EReachable eReachable = (EReachable)this.getEObject(((Reachable)reachables.next()).getURI().toString());
            this.contents.addAll((Collection<EObject>)eReachable.getDownwards());
            this.contents.addAll((Collection<EObject>)eReachable.getUpwards());
        }
    }
}

