/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.types.ui.providers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.reqcycle.types.IType;

public class IterableOfTypesContentProvider
implements ITreeContentProvider {
    Set<IType> roots = new HashSet<IType>();
    Multimap<IType, IType> tree = HashMultimap.create();

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.tree.clear();
        this.roots.clear();
        if (newInput instanceof Iterable) {
            Iterable it = (Iterable)newInput;
            Iterable types = Iterables.filter((Iterable)it, IType.class);
            HashSet aSet = Sets.newHashSet((Iterable)types);
            for (IType t : types) {
                IType aSuperType = this.getASuperType(aSet, t);
                if (aSuperType != null) {
                    this.tree.put((Object)aSuperType, (Object)t);
                    continue;
                }
                this.roots.add(t);
            }
        }
    }

    private IType getASuperType(Set<IType> aSet, IType t) {
        IType subType = t.getSuperType();
        while (subType != null) {
            if (aSet.contains(subType)) {
                return subType;
            }
            subType = subType.getSuperType();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.roots.isEmpty()) {
            this.inputChanged(null, null, inputElement);
        }
        return this.roots.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IType) {
            IType type = (IType)parentElement;
            Collection collection = this.tree.get((Object)type);
            return collection != null ? collection.toArray() : new Object[]{};
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }
}

