/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.ui.preferences;

import java.io.File;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;

public class XMLPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final IPreferenceStore STORE = Activator.getDefault().getPreferenceStore();
    public static final String XML_PREFERENCES_CATAGLOGS = "wildwebdeveloper.xml.catalogs";
    public static final Comparator<File> FILE_CASE_INSENSITIVE_ORDER = new FileComparator();

    public void initializeDefaultPreferences() {
        STORE.setDefault(XML_PREFERENCES_CATAGLOGS, "");
    }

    public static Set<File> getCatalogs(IPreferenceStore store) {
        TreeSet<File> catalogs = new TreeSet<File>(FILE_CASE_INSENSITIVE_ORDER);
        String[] stringArray = store.getString(XML_PREFERENCES_CATAGLOGS).split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filepath = stringArray[n2];
            if (!filepath.isEmpty()) {
                catalogs.add(new File(filepath));
            }
            ++n2;
        }
        return catalogs;
    }

    public static void storeCatalogs(IPreferenceStore store, Set<File> catalogs) {
        String catalogsStr = "";
        if (!catalogs.isEmpty()) {
            for (File f : catalogs) {
                catalogsStr = String.valueOf(catalogsStr) + f.getAbsolutePath() + ",";
            }
        }
        store.setValue(XML_PREFERENCES_CATAGLOGS, catalogsStr);
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File n1, File n2) {
            return String.CASE_INSENSITIVE_ORDER.compare(n1.getAbsolutePath(), n2.getAbsolutePath());
        }
    }
}

