/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;
import org.swtchart.Range;

@Deprecated
public class TmfMouseDragProvider
extends TmfBaseProvider
implements MouseListener,
MouseMoveListener {
    private long fStartTime;
    private long fEndTime;
    private boolean fIsUpdate;
    private int fStartPosition;

    public TmfMouseDragProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseListener((MouseListener)this);
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseListener((MouseListener)this);
            this.getChart().getPlotArea().removeMouseMoveListener((MouseMoveListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L && (e.button == 2 || e.button == 1 && (e.stateMask & 0x40000) != 0)) {
            this.fStartPosition = e.x;
            this.fIsUpdate = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.fIsUpdate && this.fStartTime != this.fEndTime) {
            ITmfChartTimeProvider viewer = this.getChartViewer();
            viewer.updateWindow(this.fStartTime, this.fEndTime);
        }
        this.fIsUpdate = false;
    }

    public void mouseMove(MouseEvent e) {
        if (this.fIsUpdate) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            ITmfChartTimeProvider viewer = this.getChartViewer();
            this.fStartTime = viewer.getWindowStartTime();
            this.fEndTime = viewer.getWindowEndTime();
            long startTime = viewer.getStartTime();
            long endTime = viewer.getEndTime();
            long delta = 0L;
            if (this.fStartPosition > e.x) {
                delta = (long)(xAxis.getDataCoordinate(this.fStartPosition) - xAxis.getDataCoordinate(e.x));
                long max = endTime - this.fEndTime;
                delta = Math.max(0L, Math.min(delta, max));
                this.fStartTime += delta;
                this.fEndTime += delta;
            } else if (this.fStartPosition < e.x) {
                delta = (long)(xAxis.getDataCoordinate(e.x) - xAxis.getDataCoordinate(this.fStartPosition));
                long max = this.fStartTime - startTime;
                delta = Math.max(0L, Math.min(delta, max));
                this.fStartTime -= delta;
                this.fEndTime -= delta;
            }
            xAxis.setRange(new Range((double)(this.fStartTime - viewer.getTimeOffset()), (double)(this.fEndTime - viewer.getTimeOffset())));
            this.getChart().redraw();
        }
    }
}

