/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.Nameable;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;

public class EClassValue
implements Nameable {
    protected final @NonNull EClass eClass;
    protected final @NonNull SerializationRule @NonNull [] serializationRules;
    protected final @NonNull EReference_TargetGrammarRuleVector @Nullable [] eReferenceRuleIndexes;

    public EClassValue(EClass eClass, @NonNull SerializationRule @NonNull [] serializationRules, @NonNull EReference_TargetGrammarRuleVector @Nullable [] eReferenceRuleIndexes) {
        assert (eClass != null);
        this.eClass = eClass;
        this.serializationRules = serializationRules;
        this.eReferenceRuleIndexes = eReferenceRuleIndexes;
    }

    public @NonNull EReference_TargetGrammarRuleVector @Nullable [] basicGetEReferenceRuleIndexes() {
        return this.eReferenceRuleIndexes;
    }

    public @NonNull SerializationRule @NonNull [] createDynamicSerializationRules(@Nullable GrammarRuleVector targetRuleValueIndexes) {
        if (targetRuleValueIndexes == null) {
            return this.serializationRules;
        }
        ArrayList<@NonNull SerializationRule> newSerializationRules = new ArrayList<SerializationRule>();
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationRule serializationRule = serializationRuleArray[n2];
            int ruleValueIndex = serializationRule.getGrammarRuleValueIndex();
            if (targetRuleValueIndexes.test(ruleValueIndex)) {
                newSerializationRules.add(serializationRule);
            }
            ++n2;
        }
        @NonNull SerializationRule @NonNull [] newEmptyArray = new SerializationRule[newSerializationRules.size()];
        @NonNull SerializationRule @NonNull [] newFullArray = newSerializationRules.toArray(newEmptyArray);
        return newFullArray;
    }

    public @Nullable GrammarRuleVector getAssignedTargetRuleValues(@NonNull EReference eContainmentFeature) {
        if (this.eReferenceRuleIndexes != null) {
            EReference_TargetGrammarRuleVector[] eReference_TargetGrammarRuleVectorArray = this.eReferenceRuleIndexes;
            int n = this.eReferenceRuleIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull EReference_TargetGrammarRuleVector eReferenceRuleIndex = eReference_TargetGrammarRuleVectorArray[n2];
                if (eReferenceRuleIndex.getEReference() == eContainmentFeature) {
                    return eReferenceRuleIndex.getTargetGrammarRuleVector();
                }
                ++n2;
            }
        }
        return null;
    }

    public @NonNull EClass getEClass() {
        return this.eClass;
    }

    @Override
    public @NonNull String getName() {
        return SerializationUtils.getName((ENamedElement)this.eClass);
    }

    public @NonNull SerializationRule @NonNull [] getSerializationRules() {
        return this.serializationRules;
    }

    public @NonNull String toString() {
        return this.getName();
    }

    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        s.appendObject(SerializationUtils.getName((ENamedElement)SerializationUtils.getEPackage((EClassifier)this.eClass)));
        s.append("::");
        s.appendObject(SerializationUtils.getName((ENamedElement)this.eClass));
        s.append(" <=>");
        s.appendObject(SerializationUtils.getName((ENamedElement)SerializationUtils.getEPackage((EClassifier)this.eClass)));
        s.append("::");
        s.appendObject(SerializationUtils.getName((ENamedElement)this.eClass));
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationRule serializationRule = serializationRuleArray[n2];
            s.appendIndentation(depth + 1);
            serializationRule.toMatchTermString(s, depth + 2);
            ++n2;
        }
    }

    public static class EReference_TargetGrammarRuleVector
    implements Nameable {
        protected final @NonNull EReference eReference;
        protected final @NonNull GrammarRuleVector targetGrammarRuleVector;

        public EReference_TargetGrammarRuleVector(EReference eReference, @NonNull GrammarRuleVector targetGrammarRuleVector) {
            assert (eReference != null);
            this.eReference = eReference;
            this.targetGrammarRuleVector = targetGrammarRuleVector;
        }

        public @NonNull EReference getEReference() {
            return this.eReference;
        }

        @Override
        public @NonNull String getName() {
            return SerializationUtils.getName((ENamedElement)this.eReference);
        }

        public @NonNull GrammarRuleVector getTargetGrammarRuleVector() {
            return this.targetGrammarRuleVector;
        }

        public @NonNull String toString() {
            return String.valueOf(this.eReference.getEContainingClass().getName()) + "::" + this.eReference.getName() + " " + this.targetGrammarRuleVector;
        }
    }
}

