/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.net.Socket;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.communication.BroadcastConnection;

public class BroadcastDaemon
extends AbstractDebuggerCommunicationDaemon {
    public static final String ZEND_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private IEclipsePreferences.IPreferenceChangeListener broadcastChangeListener;

    @Override
    public void init() {
        super.init();
        this.registerListeners();
    }

    @Override
    public void handleMultipleBindingError() {
        int port = this.getReceiverPort();
        Logger.log(4, "Could not open a broadcast port on: " + port + " (port might be in use). Please select a different port number");
    }

    @Override
    public int getReceiverPort() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").getInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, 20080);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean isDebuggerDaemon() {
        return false;
    }

    @Override
    public String getDebuggerID() {
        return ZEND_DEBUGGER_ID;
    }

    @Override
    protected void startConnection(Socket socket) {
        new BroadcastConnection(socket);
    }

    private void registerListeners() {
        if (this.broadcastChangeListener == null) {
            this.broadcastChangeListener = new BroadcastChangeListener();
            InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").addPreferenceChangeListener(this.broadcastChangeListener);
        }
    }

    private class BroadcastChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private BroadcastChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals(PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT)) {
                BroadcastDaemon.this.resetSocket();
            }
        }
    }
}

