/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal;

import java.net.InetAddress;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnection {
    private static Logger log = LoggerFactory.getLogger(BaseConnection.class);
    private Communicator m_communicator;
    private boolean m_connected = false;

    protected BaseConnection() {
    }

    public synchronized Communicator getCommunicator() {
        return this.m_communicator;
    }

    protected synchronized void setCommunicator(Communicator communicator) {
        if (communicator == null) {
            throw new IllegalArgumentException("Communicator must not be null");
        }
        this.m_communicator = communicator;
        this.m_communicator.addCommunicationErrorListener((ICommunicationErrorListener)new CommunicationListener());
    }

    public synchronized void run() throws AlreadyConnectedException, JBVersionException {
        if (this.isConnected()) {
            log.error("run() called to an already connected connection");
            throw new AlreadyConnectedException("This connection is already connected", MessageIDs.E_CONNECTED_CONNECTION);
        }
        this.m_communicator.run();
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(this.getClass().getName()) + ": Connection established on port: " + this.getCommunicator().getPort() + " and local port: " + this.getCommunicator().getLocalPort());
        }
    }

    public synchronized void send(Message message) throws IllegalArgumentException, NotConnectedException, CommunicationException {
        if (!this.isConnected()) {
            if (log.isWarnEnabled()) {
                log.warn("send() called to an unconnected connection");
            }
            throw new NotConnectedException("This connection is not connected", MessageIDs.E_UNCONNECTED_CONNECTION);
        }
        this.m_communicator.send(message);
    }

    public synchronized void request(Message message, ICommand response, int timeout) throws NotConnectedException, CommunicationException {
        if (!this.isConnected()) {
            log.error("request() called to an unconnected connection");
            throw new NotConnectedException("This connection is not connected", MessageIDs.E_UNCONNECTED_CONNECTION);
        }
        this.m_communicator.request(message, response, timeout);
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close() called on " + this.getClass().getName() + "on port: " + this.getCommunicator().getPort() + " and local port: " + this.getCommunicator().getLocalPort());
        }
        if (!this.isConnected()) {
            if (log.isDebugEnabled()) {
                log.debug("close() called to an unconnected connection");
            }
        } else {
            this.m_communicator.close();
            this.setConnected(false);
        }
        if (log.isDebugEnabled()) {
            log.debug("leaving close() in: " + this.getClass().getName());
        }
    }

    public synchronized boolean isConnected() {
        return this.m_connected;
    }

    private synchronized void setConnected(boolean connected) {
        this.m_connected = connected;
        if (log.isDebugEnabled()) {
            log.debug("setConnected() set to " + connected);
        }
    }

    public static class AlreadyConnectedException
    extends CommunicationException {
        public AlreadyConnectedException(String message, Integer id) {
            super(message, id);
        }
    }

    private class CommunicationListener
    implements ICommunicationErrorListener {
        private CommunicationListener() {
        }

        public void acceptingFailed(int port) {
            BaseConnection.this.setConnected(false);
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            BaseConnection.this.setConnected(false);
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            BaseConnection.this.setConnected(true);
        }

        public void sendFailed(Message message) {
        }

        public void shutDown() {
            BaseConnection.this.setConnected(false);
        }
    }

    public static class NotConnectedException
    extends CommunicationException {
        public NotConnectedException(String message, Integer id) {
            super(message, id);
        }
    }
}

